/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.ensj.controller;

import apollo.dataadapter.ensj.EnsJConnectionUtil;
import apollo.dataadapter.ensj.NonFatalException;
import apollo.dataadapter.ensj.controller.Controller;
import apollo.dataadapter.ensj.controller.EventHandler;
import apollo.dataadapter.ensj.model.Model;
import apollo.dataadapter.ensj.model.TypesModel;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class ShowGeneCountsByTypeHandler
extends EventHandler {
    public ShowGeneCountsByTypeHandler(Controller controller, String key) {
        super(controller, key);
    }

    public void doAction(Model model) {
        TypesModel myModel = model.getTypesModel();
        this.log("Fetching & showing gene counts by type");
        this.doUpdate();
        if (myModel.getTypePanelToShow().equals("GENE")) {
            myModel.setTypePanelToShow("NONE");
        } else {
            this.log("Setting type panel to show type " + "GENE");
            myModel.setTypePanelToShow("GENE");
        }
        if (!myModel.isGeneTypeCountInitialised()) {
            HashMap geneTypeCounts = this.getGeneCountsByType(model);
            myModel.setGeneTypeCounts(geneTypeCounts);
            ArrayList geneTypes = new ArrayList(geneTypeCounts.keySet());
            Collections.sort(geneTypes);
            myModel.setGeneTypes(geneTypes);
            myModel.setGeneTypeCountInitialised(true);
        }
        this.doRead();
    }

    public HashMap getGeneCountsByType(Model model) {
        HashMap<String, Integer> returnMap = new HashMap<String, Integer>();
        Connection connection = this.getConnectionForModel(model);
        int schema = EnsJConnectionUtil.getEnsemblSchema(connection);
        String sql = schema == 34 ? "select biotype,count(*),status,source from gene group by biotype,source,status order by biotype,source,status" : (schema == 32 ? "select biotype,count(*),confidence,source from gene group by biotype,source,confidence order by biotype,source,confidence" : "select type,count(*) from gene group by type order by type");
        try {
            ResultSet results = connection.createStatement().executeQuery(sql);
            while (results.next()) {
                String typeStr = schema > 30 ? (results.getString(1) == null ? "" : results.getString(1)) + "_" + (results.getString(3) == null ? "" : results.getString(3)) + "_" + (results.getString(4) == null ? "" : results.getString(4)) : results.getString(1);
                returnMap.put(typeStr, new Integer(results.getInt(2)));
            }
            this.log("Found " + returnMap.keySet().size() + " Different types");
            connection.close();
        }
        catch (SQLException exception) {
            throw new NonFatalException(exception.getMessage(), exception);
        }
        return returnMap;
    }
}

