/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.ensj.controller;

import apollo.dataadapter.ensj.NonFatalException;
import apollo.dataadapter.ensj.controller.Controller;
import apollo.dataadapter.ensj.controller.EventHandler;
import apollo.dataadapter.ensj.model.Model;
import apollo.dataadapter.ensj.model.TypesModel;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;

public class ShowDnaDnaAlignCountsByTypeHandler
extends EventHandler {
    public ShowDnaDnaAlignCountsByTypeHandler(Controller controller, String key) {
        super(controller, key);
    }

    public void doAction(Model model) {
        TypesModel myModel = model.getTypesModel();
        this.log("Fetching & showing dna-dna align counts by type");
        this.doUpdate();
        if (myModel.getTypePanelToShow().equals("DNADNA")) {
            myModel.setTypePanelToShow("NONE");
        } else {
            this.log("Setting type panel to show type " + "DNADNA");
            myModel.setTypePanelToShow("DNADNA");
        }
        if (!myModel.isDnaDnaAlignmentTypeCountInitialised()) {
            HashMap typeCounts = this.getCountsByType(model);
            myModel.setDnaDnaAlignmentTypeCounts(typeCounts);
            myModel.setDnaDnaAlignTypes(new ArrayList(typeCounts.keySet()));
            myModel.setDnaDnaAlignmentTypeCountInitialised(true);
        }
        this.doRead();
    }

    public HashMap getCountsByType(Model model) {
        HashMap<String, Integer> returnMap = new HashMap<String, Integer>();
        Connection connection = this.getConnectionForModel(model);
        String sql = "select logic_name, count(*) from dna_align_feature, analysis where dna_align_feature.analysis_id = analysis.analysis_id group by dna_align_feature.analysis_id";
        try {
            ResultSet results = connection.createStatement().executeQuery(sql);
            while (results.next()) {
                returnMap.put(results.getString(1), new Integer(results.getInt(2)));
            }
            this.log("Found " + returnMap.keySet().size() + " Different types");
        }
        catch (SQLException exception) {
            throw new NonFatalException(exception.getMessage(), exception);
        }
        return returnMap;
    }
}

