/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.ensj.controller;

import apollo.dataadapter.ensj.EnsJConnectionUtil;
import apollo.dataadapter.ensj.controller.Controller;
import apollo.dataadapter.ensj.controller.EventHandler;
import apollo.dataadapter.ensj.model.DatabaseModel;
import apollo.dataadapter.ensj.model.LocationModel;
import apollo.dataadapter.ensj.model.Model;
import java.sql.Connection;
import java.util.ArrayList;

public class FindCoordSystemsHandler
extends EventHandler {
    public FindCoordSystemsHandler(Controller controller, String key) {
        super(controller, key);
    }

    public void doAction(Model model) {
        this.doUpdate();
        DatabaseModel databaseModel = model.getDatabaseModel();
        LocationModel locationModel = model.getLocationModel();
        if (locationModel.isCoordSystemInitialised()) {
            this.log("Coord systems already initialised - returning");
            return;
        }
        this.log("Finding available coord systems");
        ArrayList<String> returnList = new ArrayList<String>();
        returnList.add("");
        String jdbcDriver = "org.gjt.mm.mysql.Driver";
        String host = databaseModel.getHost();
        String port = databaseModel.getPort();
        String database = databaseModel.getSelectedEnsemblDatabase();
        String url = "jdbc:mysql://" + host + ":" + port + "/" + database;
        String user = databaseModel.getUser();
        String password = databaseModel.getPassword();
        Connection connection = EnsJConnectionUtil.getConnection(jdbcDriver, host, port, database, user, password);
        if (password == null) {
            password = "";
        }
        returnList.addAll(this.findCoordinateSystems(connection));
        locationModel.setCoordSystems(returnList);
        locationModel.setCoordSystemInitialised(true);
        locationModel.setSeqRegions(new ArrayList());
        locationModel.setSeqRegionInitialised(false);
        locationModel.setStableIDLocation(false);
        this.doRead();
    }
}

