/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.ensj.controller;

import apollo.dataadapter.ensj.EnsJConnectionUtil;
import apollo.dataadapter.ensj.FatalException;
import apollo.dataadapter.ensj.NonFatalException;
import apollo.dataadapter.ensj.controller.Controller;
import apollo.dataadapter.ensj.model.DatabaseModel;
import apollo.dataadapter.ensj.model.LocationModel;
import apollo.dataadapter.ensj.model.Model;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class EventHandler {
    private Controller _controller;
    private String _key;
    public static final String NULL_VERSION = "(No Version)";

    public EventHandler(Controller controller, String key) {
        this._controller = controller;
        this._key = key;
    }

    protected Controller getController() {
        return this._controller;
    }

    public abstract void doAction(Model var1);

    public String getKey() {
        return this._key;
    }

    public void doRead() {
        this.getController().doRead();
    }

    public void doUpdate() {
        this.getController().doUpdate();
    }

    public void log(String message) {
        this.getController().log("EVENT:(" + this.getKey() + "):" + message);
    }

    public int getRowCountForTable(String tableName, Connection connection) {
        int rowCount = 0;
        try {
            Statement statement = connection.createStatement();
            ResultSet count = statement.executeQuery("select count(*) from " + tableName);
            while (count.next()) {
                rowCount = count.getInt(1);
            }
        }
        catch (SQLException exception) {
            throw new FatalException(exception.getMessage(), exception);
        }
        return rowCount;
    }

    public Connection getConnectionForModel(Model model) {
        DatabaseModel databaseModel = model.getDatabaseModel();
        String jdbcDriver = "org.gjt.mm.mysql.Driver";
        String host = databaseModel.getHost();
        String port = databaseModel.getPort();
        String database = databaseModel.getSelectedEnsemblDatabase();
        String user = databaseModel.getUser();
        String password = databaseModel.getPassword();
        return EnsJConnectionUtil.getConnection("org.gjt.mm.mysql.Driver", host, port, database, user, password);
    }

    public List findCoordinateSystems(Connection connection) {
        ArrayList<String> returnList = new ArrayList<String>();
        try {
            Statement statement = connection.createStatement();
            ResultSet names = statement.executeQuery("select version, name from coord_system");
            while (names.next()) {
                String version = names.getString(1);
                if (this.isNull(version)) {
                    version = NULL_VERSION;
                }
                String name = names.getString(2);
                String composite = version + "--" + name;
                returnList.add(composite);
            }
        }
        catch (SQLException exception) {
            throw new FatalException(exception.getMessage(), exception);
        }
        return returnList;
    }

    public List findSeqRegions(Model model) {
        DatabaseModel databaseModel = model.getDatabaseModel();
        LocationModel locationModel = model.getLocationModel();
        String jdbcDriver = "org.gjt.mm.mysql.Driver";
        String host = databaseModel.getHost();
        String port = databaseModel.getPort();
        String database = databaseModel.getSelectedEnsemblDatabase();
        String user = databaseModel.getUser();
        String password = databaseModel.getPassword();
        ArrayList<String> returnList = new ArrayList<String>();
        ArrayList<String> unsortedReturnList = new ArrayList<String>();
        returnList.add("");
        Connection connection = EnsJConnectionUtil.getConnection(jdbcDriver, host, port, database, user, password);
        String versionAndCoordSystem = locationModel.getSelectedCoordSystem();
        if (this.isNull(versionAndCoordSystem)) {
            throw new NonFatalException("Coordinate system must be populated");
        }
        this.log("Found version/coord system: " + versionAndCoordSystem);
        Pattern pattern = Pattern.compile("([^--]*)--(.*)");
        Matcher matcher = pattern.matcher(versionAndCoordSystem);
        if (!matcher.matches()) {
            throw new NonFatalException("The chosen version and coord system: " + versionAndCoordSystem + " don't fit the pattern" + " version--coordsystem");
        }
        String version = matcher.group(1);
        String coordSystem = matcher.group(2);
        this.log("Matched to version : " + version + ", and coord system: " + coordSystem);
        if (this.isNull(version) || this.isNull(coordSystem)) {
            throw new NonFatalException("The chosen version and coord system " + versionAndCoordSystem + " can't be resolved " + " into a separate, non-null version and coord system string");
        }
        try {
            Statement statement = connection.createStatement();
            ResultSet names = version.equals(NULL_VERSION) ? statement.executeQuery("select seq_region.name, seq_region.length from seq_region, coord_system where  seq_region.coord_system_id = coord_system.coord_system_id and  coord_system.name = '" + coordSystem + "' and " + " coord_system.version is null ") : statement.executeQuery("select seq_region.name, seq_region.length from seq_region, coord_system where  seq_region.coord_system_id = coord_system.coord_system_id and  coord_system.name = '" + coordSystem + "' and " + " coord_system.version = '" + version + "'");
            while (names.next()) {
                String name = names.getString(1);
                int length = names.getInt(2);
                unsortedReturnList.add(name);
                locationModel.getSeqRegionToLengthsMap().put(name, new Integer(length));
                this.log("Retreived seq-region: " + name + "(" + length + ")");
            }
        }
        catch (SQLException exception) {
            throw new FatalException(exception.getMessage(), exception);
        }
        Collections.sort(unsortedReturnList);
        returnList.addAll(unsortedReturnList);
        return returnList;
    }

    public String findCoordSystemForNamedSeqRegion(Model model) {
        DatabaseModel databaseModel = model.getDatabaseModel();
        LocationModel locationModel = model.getLocationModel();
        String jdbcDriver = "org.gjt.mm.mysql.Driver";
        String host = databaseModel.getHost();
        String port = databaseModel.getPort();
        String database = databaseModel.getSelectedEnsemblDatabase();
        String user = databaseModel.getUser();
        String password = databaseModel.getPassword();
        String regionName = locationModel.getSelectedSeqRegion();
        String returnString = null;
        Connection connection = EnsJConnectionUtil.getConnection(jdbcDriver, host, port, database, user, password);
        try {
            Statement statement = connection.createStatement();
            ResultSet names = statement.executeQuery("select coord_system.name, coord_system.version from seq_region, coord_system where  seq_region.coord_system_id = coord_system.coord_system_id and  seq_region.name = '" + regionName + "'");
            while (names.next()) {
                String name = names.getString(1);
                String version = names.getString(2);
                returnString = version == null ? new String("(No Version)--" + name) : new String(version + "--" + name);
                this.log("Retreived coord system: " + name + " " + version);
            }
        }
        catch (SQLException exception) {
            throw new FatalException(exception.getMessage(), exception);
        }
        return returnString;
    }

    public boolean isNull(String string) {
        return string == null || string.trim().length() <= 0;
    }

    public void closeConnection(Connection connection) {
        try {
            connection.close();
        }
        catch (SQLException exception) {
            throw new NonFatalException("Problem closing connection: " + exception.getMessage(), exception);
        }
    }
}

