/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.ensj;

import apollo.dataadapter.ApolloAdapterException;
import apollo.dataadapter.ensj.EnsJAdapter;
import apollo.dataadapter.ensj.EnsJConnectionUtil;
import apollo.datamodel.AnnotatedFeature;
import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.CurationSet;
import apollo.datamodel.FeaturePair;
import apollo.datamodel.FeatureSet;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.SeqFeature;
import apollo.datamodel.StrandedFeatureSet;
import apollo.datamodel.StrandedFeatureSetI;
import apollo.datamodel.Synonym;
import apollo.datamodel.Transcript;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.ensembl.datamodel.Accessioned;
import org.ensembl.datamodel.DnaDnaAlignment;
import org.ensembl.datamodel.DnaProteinAlignment;
import org.ensembl.datamodel.Exon;
import org.ensembl.datamodel.Gene;
import org.ensembl.datamodel.InvalidLocationException;
import org.ensembl.datamodel.Location;
import org.ensembl.datamodel.PredictionExon;
import org.ensembl.datamodel.PredictionTranscript;
import org.ensembl.datamodel.ProteinFeature;
import org.ensembl.datamodel.RepeatConsensus;
import org.ensembl.datamodel.RepeatFeature;
import org.ensembl.datamodel.SimpleFeature;
import org.ensembl.datamodel.Translation;
import org.ensembl.driver.AdaptorException;
import org.ensembl.driver.DnaDnaAlignmentAdaptor;
import org.ensembl.driver.DnaProteinAlignmentAdaptor;
import org.ensembl.driver.GeneAdaptor;
import org.ensembl.driver.PredictionTranscriptAdaptor;
import org.ensembl.driver.ProteinFeatureAdaptor;
import org.ensembl.driver.RepeatFeatureAdaptor;
import org.ensembl.driver.SimpleFeatureAdaptor;
import org.ensembl.util.JDBCUtil;

public class DataFetcher {
    private EnsJAdapter _adapter;

    public DataFetcher(EnsJAdapter adapter) {
        this._adapter = adapter;
    }

    private EnsJAdapter getAdapter() {
        return this._adapter;
    }

    public List addGenes(StrandedFeatureSet results, Location location, List includedTypes) throws AdaptorException {
        GeneAdaptor adaptor = this.getAdapter().getDriver().getGeneAdaptor();
        System.out.println("Doing initial gene fetch");
        Iterator genes = adaptor.fetch(location, true).iterator();
        System.out.println("Done initial gene fetch");
        ArrayList<Gene> returnListOfEnsJGenes = new ArrayList<Gene>();
        int returnedNumber = 0;
        boolean checkType = includedTypes.size() > 0;
        List codingLocations = null;
        Location firstLocation = null;
        Location lastLocation = null;
        Connection conn = this.getAdapter().getDriver().getConnection();
        int schema = EnsJConnectionUtil.getEnsemblSchema(conn);
        JDBCUtil.close((Connection)conn);
        while (genes.hasNext()) {
            Gene ensJGene = (Gene)genes.next();
            String type = schema == 30 ? ensJGene.getType() : (ensJGene.getType() != null ? ensJGene.getType() : "") + "_" + (ensJGene.getConfidence() != null ? ensJGene.getConfidence() : "") + "_" + (ensJGene.getSource() != null ? ensJGene.getSource() : "");
            if (checkType && !includedTypes.contains(type)) continue;
            returnListOfEnsJGenes.add(ensJGene);
            ++returnedNumber;
            FeatureSet geneFeature = new FeatureSet();
            geneFeature.setFeatureType(type);
            if (ensJGene.getAccessionID() != null) {
                geneFeature.setName(ensJGene.getAccessionID());
            } else {
                geneFeature.setName(String.valueOf(ensJGene.getInternalID()));
            }
            geneFeature.setId(String.valueOf(ensJGene.getInternalID()));
            Iterator transcripts = ensJGene.getTranscripts().iterator();
            while (transcripts.hasNext()) {
                org.ensembl.datamodel.Transcript ensJTranscript = (org.ensembl.datamodel.Transcript)transcripts.next();
                FeatureSet transcriptFeature = new FeatureSet();
                transcriptFeature.setFeatureType(type);
                if (ensJTranscript.getAccessionID() != null) {
                    transcriptFeature.setName(ensJTranscript.getAccessionID());
                } else {
                    try {
                        Iterator supports = ensJTranscript.getSupportingFeatures().iterator();
                        if (supports.hasNext()) {
                            org.ensembl.datamodel.FeaturePair sf = (org.ensembl.datamodel.FeaturePair)supports.next();
                            String tscriptName = sf.getHitAccession() + " (" + ensJTranscript.getInternalID() + ")";
                            transcriptFeature.setName(tscriptName);
                        } else {
                            transcriptFeature.setName(String.valueOf(ensJTranscript.getInternalID()));
                        }
                    }
                    catch (Exception e) {
                        transcriptFeature.setName(String.valueOf(ensJTranscript.getInternalID()));
                    }
                }
                transcriptFeature.setId(String.valueOf(ensJTranscript.getInternalID()));
                Iterator exons = ensJTranscript.getExons().iterator();
                while (exons.hasNext()) {
                    Exon ensJExon = (Exon)exons.next();
                    Location exonLocation = ensJExon.getLocation();
                    SeqFeature exonFeature = new SeqFeature();
                    exonFeature.setLow(exonLocation.getStart());
                    exonFeature.setHigh(exonLocation.getEnd());
                    exonFeature.setStrand(exonLocation.getStrand());
                    exonFeature.setName(transcriptFeature.getName());
                    exonFeature.setId(transcriptFeature.getName());
                    exonFeature.setFeatureType(type);
                    geneFeature.setStrand(exonLocation.getStrand());
                    transcriptFeature.setStrand(exonLocation.getStrand());
                    transcriptFeature.addFeature(exonFeature);
                }
                if (ensJTranscript.getTranslation() != null && (codingLocations = ensJTranscript.getTranslation().getCodingLocations()).size() > 0) {
                    firstLocation = (Location)codingLocations.get(0);
                    lastLocation = (Location)codingLocations.get(codingLocations.size() - 1);
                    if (transcriptFeature.getStrand() == 1) {
                        transcriptFeature.setTranslationStart(firstLocation.getStart());
                        transcriptFeature.setTranslationEnd(lastLocation.getEnd());
                    } else {
                        transcriptFeature.setTranslationStart(firstLocation.getEnd());
                        transcriptFeature.setTranslationEnd(lastLocation.getStart());
                    }
                }
                geneFeature.addFeature(transcriptFeature);
            }
            results.addFeature(geneFeature, false);
        }
        return returnListOfEnsJGenes;
    }

    public int addRepeatFeatures(CurationSet curationSet, List flatFeatures, Location location) throws AdaptorException {
        RepeatFeatureAdaptor adaptor = this.getAdapter().getDriver().getRepeatFeatureAdaptor();
        List features = adaptor.fetch(location);
        Iterator iterator = features.iterator();
        int returnedNumber = 0;
        Connection conn = this.getAdapter().getDriver().getConnection();
        int schema = EnsJConnectionUtil.getEnsemblSchema(conn);
        JDBCUtil.close((Connection)conn);
        while (iterator.hasNext()) {
            RepeatFeature feature = (RepeatFeature)iterator.next();
            if (schema > 30 && feature.getLocation().containsGapNodes()) continue;
            ++returnedNumber;
            SeqFeature genomeHit = new SeqFeature();
            Location genomeLocation = feature.getLocation();
            if (genomeLocation.getStart() <= genomeLocation.getEnd()) {
                genomeHit.setLow(genomeLocation.getStart());
                genomeHit.setHigh(genomeLocation.getEnd());
            } else {
                genomeHit.setLow(genomeLocation.getEnd());
                genomeHit.setHigh(genomeLocation.getStart());
            }
            genomeHit.setStrand(genomeLocation.getStrand());
            SeqFeature repeatHit = new SeqFeature();
            repeatHit.setName(feature.getHitDisplayName());
            Location repeatLocation = feature.getHitLocation();
            if (repeatLocation.getStart() <= repeatLocation.getEnd()) {
                repeatHit.setLow(repeatLocation.getStart());
                repeatHit.setHigh(repeatLocation.getEnd());
            } else {
                repeatHit.setLow(repeatLocation.getEnd());
                repeatHit.setHigh(repeatLocation.getStart());
            }
            RepeatConsensus repeatConsensus = feature.getRepeatConsensus();
            if (repeatConsensus != null) {
                genomeHit.setName(repeatConsensus.getName());
                genomeHit.setId(repeatConsensus.getName());
                repeatHit.setName(repeatConsensus.getName());
                repeatHit.setId(repeatConsensus.getName());
            } else {
                genomeHit.setName(feature.getDisplayName());
                genomeHit.setId(feature.getDisplayName());
                repeatHit.setName(feature.getHitDisplayName());
                repeatHit.setId(feature.getHitDisplayName());
            }
            genomeHit.setFeatureType(feature.getAnalysis().getLogicalName());
            genomeHit.setScore(feature.getScore());
            repeatHit.setScore(feature.getScore());
            FeaturePair featurePair = new FeaturePair(genomeHit, repeatHit);
            this.getAdapter().setSequence(featurePair, curationSet);
            flatFeatures.add(featurePair);
        }
        return returnedNumber;
    }

    public int addProteinAlignFeatures(CurationSet curationSet, List flatFeatures, Location location, List includedTypes) throws AdaptorException {
        String[] logicalNames = new String[includedTypes.size()];
        DnaProteinAlignmentAdaptor adaptor = this.getAdapter().getDriver().getDnaProteinAlignmentAdaptor();
        Iterator features = null;
        int returnedNumber = 0;
        logicalNames = includedTypes.toArray(logicalNames);
        features = includedTypes.size() > 0 ? adaptor.fetch(location, logicalNames).iterator() : adaptor.fetch(location).iterator();
        Connection conn = this.getAdapter().getDriver().getConnection();
        int schema = EnsJConnectionUtil.getEnsemblSchema(conn);
        JDBCUtil.close((Connection)conn);
        while (features.hasNext()) {
            DnaProteinAlignment feature = (DnaProteinAlignment)features.next();
            if (schema > 30 && feature.getLocation().containsGapNodes()) continue;
            ++returnedNumber;
            SeqFeature proteinHit = new SeqFeature();
            proteinHit.setName(feature.getHitAccession());
            proteinHit.setId(feature.getHitAccession());
            proteinHit.setScore(feature.getScore());
            Location proteinLocation = feature.getHitLocation();
            proteinHit.setLow(proteinLocation.getStart());
            proteinHit.setHigh(proteinLocation.getEnd());
            SeqFeature genomeHit = new SeqFeature();
            genomeHit.setName(feature.getHitAccession());
            genomeHit.setId(feature.getHitAccession());
            genomeHit.setFeatureType(feature.getAnalysis().getLogicalName());
            genomeHit.setScore(feature.getScore());
            Location genomeLocation = feature.getLocation();
            genomeHit.setLow(genomeLocation.getStart());
            genomeHit.setHigh(genomeLocation.getEnd());
            genomeHit.setStrand(genomeLocation.getStrand());
            FeaturePair pair = new FeaturePair(genomeHit, proteinHit);
            this.getAdapter().setSequence(pair, curationSet);
            flatFeatures.add(pair);
        }
        return returnedNumber;
    }

    public int addDnaAlignFeatures(CurationSet curationSet, List flatFeatures, Location location, List includedTypes) throws AdaptorException {
        String[] logicalNames = new String[includedTypes.size()];
        DnaDnaAlignmentAdaptor adaptor = this.getAdapter().getDriver().getDnaDnaAlignmentAdaptor();
        int returnedNumber = 0;
        logicalNames = includedTypes.toArray(logicalNames);
        Iterator features = includedTypes.size() > 0 ? adaptor.fetch(location, logicalNames).iterator() : adaptor.fetch(location).iterator();
        Connection conn = this.getAdapter().getDriver().getConnection();
        int schema = EnsJConnectionUtil.getEnsemblSchema(conn);
        JDBCUtil.close((Connection)conn);
        while (features.hasNext()) {
            DnaDnaAlignment feature = (DnaDnaAlignment)features.next();
            if (schema > 30 && feature.getLocation().containsGapNodes()) continue;
            ++returnedNumber;
            SeqFeature targetDnaHit = new SeqFeature();
            targetDnaHit.setName(feature.getHitAccession());
            targetDnaHit.setId(feature.getHitAccession());
            targetDnaHit.setScore(feature.getScore());
            Location proteinLocation = feature.getHitLocation();
            targetDnaHit.setLow(proteinLocation.getStart());
            targetDnaHit.setHigh(proteinLocation.getEnd());
            SeqFeature genomeHit = new SeqFeature();
            genomeHit.setName(feature.getHitAccession());
            genomeHit.setId(feature.getHitAccession());
            genomeHit.setFeatureType(feature.getAnalysis().getLogicalName());
            genomeHit.setScore(feature.getScore());
            Location genomeLocation = feature.getLocation();
            genomeHit.setLow(genomeLocation.getStart());
            genomeHit.setHigh(genomeLocation.getEnd());
            genomeHit.setStrand(genomeLocation.getStrand());
            FeaturePair pair = new FeaturePair(genomeHit, targetDnaHit);
            this.getAdapter().setSequence(pair, curationSet);
            flatFeatures.add(pair);
        }
        return returnedNumber;
    }

    public int addPredictionTranscripts(StrandedFeatureSet results, Location location, List includedTypes) throws AdaptorException {
        String[] logicalNames = new String[includedTypes.size()];
        PredictionTranscriptAdaptor adaptor = this.getAdapter().getDriver().getPredictionTranscriptAdaptor();
        Iterator features = null;
        int returnedNumber = 0;
        logicalNames = includedTypes.toArray(logicalNames);
        features = includedTypes.size() > 0 ? adaptor.fetch(location, logicalNames).iterator() : adaptor.fetch(location).iterator();
        Connection conn = this.getAdapter().getDriver().getConnection();
        int schema = EnsJConnectionUtil.getEnsemblSchema(conn);
        JDBCUtil.close((Connection)conn);
        while (features.hasNext()) {
            PredictionTranscript transcript = (PredictionTranscript)features.next();
            if (schema > 30 && transcript.getLocation().containsGapNodes()) continue;
            ++returnedNumber;
            FeatureSet transcriptFeature = new FeatureSet();
            String type = transcript.getAnalysis().getLogicalName();
            transcriptFeature.setFeatureType(type);
            transcriptFeature.setName(type + ":" + transcript.getInternalID());
            transcriptFeature.setId(String.valueOf(transcript.getInternalID()));
            Iterator predictionExons = transcript.getExons().iterator();
            while (predictionExons.hasNext()) {
                PredictionExon exon = (PredictionExon)predictionExons.next();
                Location exonLocation = exon.getLocation();
                SeqFeature exonFeature = new SeqFeature();
                exonFeature.setLow(exonLocation.getStart());
                exonFeature.setHigh(exonLocation.getEnd());
                exonFeature.setStrand(exonLocation.getStrand());
                exonFeature.setName(transcriptFeature.getName());
                exonFeature.setId(transcriptFeature.getName());
                exonFeature.setFeatureType(type);
                if (exon.getPvalue() > 0.0) {
                    exonFeature.setScore(exon.getPvalue());
                } else {
                    exonFeature.setScore(exon.getScore());
                }
                transcriptFeature.setStrand(exonLocation.getStrand());
                transcriptFeature.addFeature(exonFeature);
            }
            results.addFeature(transcriptFeature, false);
        }
        return returnedNumber;
    }

    public int addSimpleFeatures(CurationSet curationSet, List flatFeatures, Location location, List includedTypes) throws AdaptorException {
        String[] logicalNames = new String[includedTypes.size()];
        SimpleFeatureAdaptor adaptor = this.getAdapter().getDriver().getSimpleFeatureAdaptor();
        Iterator features = null;
        int returnedNumber = 0;
        logicalNames = includedTypes.toArray(logicalNames);
        features = includedTypes.size() > 0 ? adaptor.fetch(location, logicalNames).iterator() : adaptor.fetch(location).iterator();
        Connection conn = this.getAdapter().getDriver().getConnection();
        int schema = EnsJConnectionUtil.getEnsemblSchema(conn);
        JDBCUtil.close((Connection)conn);
        while (features.hasNext()) {
            SimpleFeature feature = (SimpleFeature)features.next();
            if (schema > 30 && feature.getLocation().containsGapNodes()) continue;
            ++returnedNumber;
            SeqFeature genomeFeature = new SeqFeature();
            genomeFeature.setName(feature.getDisplayName());
            genomeFeature.setId(feature.getDisplayName());
            genomeFeature.setFeatureType(feature.getAnalysis().getLogicalName());
            genomeFeature.setScore(feature.getScore());
            Location genomeLocation = feature.getLocation();
            genomeFeature.setLow(genomeLocation.getStart());
            genomeFeature.setHigh(genomeLocation.getEnd());
            genomeFeature.setStrand(genomeLocation.getStrand());
            flatFeatures.add(genomeFeature);
        }
        return returnedNumber;
    }

    public int addProteinAnnotations(CurationSet curationSet, List flatFeatures, List retrievedGenes) throws AdaptorException {
        ProteinFeatureAdaptor adaptor = this.getAdapter().getDriver().getProteinFeatureAdaptor();
        int returnedNumber = 0;
        List retrievedTranscripts = null;
        ArrayList<Translation> translations = new ArrayList<Translation>();
        int start = 0;
        int end = 0;
        for (int i = 0; i < retrievedGenes.size(); ++i) {
            retrievedTranscripts = ((Gene)retrievedGenes.get(i)).getTranscripts();
            for (int j = 0; j < retrievedTranscripts.size(); ++j) {
                if (((org.ensembl.datamodel.Transcript)retrievedTranscripts.get(j)).getTranslation() == null) continue;
                translations.add(((org.ensembl.datamodel.Transcript)retrievedTranscripts.get(j)).getTranslation());
            }
        }
        Iterator translationIterator = translations.iterator();
        while (translationIterator.hasNext()) {
            Translation translation = (Translation)translationIterator.next();
            Iterator annotationIterator = adaptor.fetch(translation).iterator();
            while (annotationIterator.hasNext()) {
                ProteinFeature feature = (ProteinFeature)annotationIterator.next();
                start = feature.getPeptideStart();
                end = feature.getPeptideEnd();
                String displayName = feature.getDisplayName();
                double score = feature.getScore();
                feature.setTranslation(translation);
                Location location = feature.getLocation();
                SeqFeature peptideHit = new SeqFeature();
                peptideHit.setLow(start);
                peptideHit.setHigh(end);
                peptideHit.setName(displayName);
                SeqFeature genomeHit = new SeqFeature();
                genomeHit.setLow(location.getStart());
                genomeHit.setHigh(location.getEnd());
                genomeHit.setStrand(location.getStrand());
                genomeHit.setName(feature.getDisplayName());
                genomeHit.setId(feature.getDisplayName());
                genomeHit.setFeatureType(feature.getAnalysis().getLogicalName());
                genomeHit.setScore(score);
                flatFeatures.add(new FeaturePair(genomeHit, peptideHit));
            }
        }
        return returnedNumber;
    }

    protected StrandedFeatureSetI getAnnotations(CurationSet curationSet, List genes) throws ApolloAdapterException {
        StrandedFeatureSet root = new StrandedFeatureSet((FeatureSetI)new AnnotatedFeature(), new AnnotatedFeature());
        Iterator geneIter = genes.iterator();
        while (geneIter.hasNext()) {
            Gene gene = (Gene)geneIter.next();
            AnnotatedFeatureI apolloGene = this.createGene(gene);
            root.addFeature(apolloGene);
        }
        return root;
    }

    private AnnotatedFeatureI createGene(Gene ensjGene) {
        AnnotatedFeature gene = new AnnotatedFeature();
        String source = ensjGene.getType();
        String id = Long.toString(ensjGene.getInternalID());
        gene.setId(id);
        gene.setName(this.getName((Accessioned)ensjGene, id));
        gene.setDescription(ensjGene.getDescription());
        Location loc = ensjGene.getLocation();
        gene.setStrand(loc.getStrand());
        Iterator transcripts = ensjGene.getTranscripts().iterator();
        while (transcripts.hasNext()) {
            Transcript transcript = this.createTranscript((org.ensembl.datamodel.Transcript)transcripts.next());
            gene.addFeature(transcript);
            transcript.setOwner(source);
        }
        Vector synonyms = gene.getSynonyms();
        for (int i = 0; i < synonyms.size(); ++i) {
            String synonym = (String)synonyms.get(i);
            gene.addSynonym(new Synonym(synonym));
        }
        return gene;
    }

    private Transcript createTranscript(org.ensembl.datamodel.Transcript ensjTranscript) {
        Transcript transcript = new Transcript();
        String id = Long.toString(ensjTranscript.getInternalID());
        transcript.setId(id);
        transcript.setName(this.getName((Accessioned)ensjTranscript, id));
        Location loc = ensjTranscript.getLocation();
        transcript.setStrand(loc.getStrand());
        Iterator exons = ensjTranscript.getExons().iterator();
        while (exons.hasNext()) {
            apollo.datamodel.Exon exon = this.createExon((Exon)exons.next());
            transcript.addExon(exon);
        }
        this.setTranslationStartEndFromEnsjTranscript(transcript, ensjTranscript);
        return transcript;
    }

    private void setTranslationStartEndFromEnsjTranscript(FeatureSetI set, org.ensembl.datamodel.Transcript ensjTranscript) {
        if (ensjTranscript.getTranslation() != null) {
            List locs = null;
            try {
                locs = ensjTranscript.getTranslation().getCodingLocations();
            }
            catch (InvalidLocationException e) {
                locs = Collections.EMPTY_LIST;
            }
            int nLocs = locs.size();
            if (nLocs == 0) {
                String desc = Long.toString(ensjTranscript.getInternalID());
                String t = ensjTranscript.getAccessionID();
                if (t != null) {
                    desc = desc + " (" + t + ")";
                }
                System.err.println("Failed to translate transcript: " + desc);
                return;
            }
            Location firstLoc = (Location)locs.get(0);
            Location lastLoc = (Location)locs.get(nLocs - 1);
            if (set.getStrand() == 1) {
                set.setTranslationStart(firstLoc.getStart());
                set.setTranslationEnd(lastLoc.getEnd());
            } else {
                set.setTranslationStart(firstLoc.getEnd());
                set.setTranslationEnd(lastLoc.getStart());
            }
        }
    }

    private apollo.datamodel.Exon createExon(Exon ensjExon) {
        apollo.datamodel.Exon exon = new apollo.datamodel.Exon();
        String id = Long.toString(ensjExon.getInternalID());
        exon.setId(id);
        exon.setName(this.getName((Accessioned)ensjExon, id));
        Location loc = ensjExon.getLocation();
        exon.setStrand(loc.getStrand());
        exon.setLow(loc.getStart());
        exon.setHigh(loc.getEnd());
        return exon;
    }

    private String getName(Accessioned item, String defaultName) {
        String name = item.getAccessionID();
        if (name == null) {
            name = defaultName;
        }
        return name;
    }
}

