/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.das2;

import apollo.dataadapter.das.simple.SimpleDASDsn;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SourceParser
extends DefaultHandler {
    private String baseURL;
    private String mode;
    private Stack modeStack = new Stack();
    private List dsns = new ArrayList();
    private String segment_uri;
    private String SOURCE = "SOURCE";
    private String SOURCES = "SOURCES";
    private String VERSION = "VERSION";
    private String CAPABILITY = "CAPABILITY";
    private String SOURCE_ID = "id";
    private String BASE_URL = "xml:base";
    private SimpleDASDsn currentDsn;

    private SimpleDASDsn getCurrentDsn() {
        return this.currentDsn;
    }

    private void setCurrentDsn(SimpleDASDsn theDsn) {
        this.currentDsn = theDsn;
    }

    private void addDsn(SimpleDASDsn theDsn) {
        this.getDsns().add(theDsn);
    }

    public List getDsns() {
        return this.dsns;
    }

    private Stack getModeStack() {
        return this.modeStack;
    }

    private void setMode(String theMode) {
        this.getModeStack().push(theMode);
    }

    private String getMode() {
        if (!this.getModeStack().isEmpty()) {
            return (String)this.getModeStack().peek();
        }
        return null;
    }

    private void closeMode() {
        if (!this.getModeStack().isEmpty()) {
            this.getModeStack().pop();
        }
    }

    public void setURL(String url) {
        this.baseURL = url;
    }

    public String getURL() {
        return this.baseURL;
    }

    public void startElement(String namespaceURI, String tag, String qualifiedName, Attributes attributes) throws SAXException {
        this.setMode(tag);
        if (tag.equals(this.SOURCES)) {
            String url = attributes.getValue(this.BASE_URL);
            if (url != null) {
                this.setURL(url);
            }
        } else if (!tag.equals(this.SOURCE)) {
            if (tag.equals(this.VERSION)) {
                String version = attributes.getValue(this.SOURCE_ID);
                if (version != null) {
                    if (this.getCurrentDsn() != null) {
                        System.out.println("SourceParser.startElement: adding current dsn " + this.getCurrentDsn());
                        this.addDsn(this.getCurrentDsn());
                        this.setCurrentDsn(null);
                    }
                    SimpleDASDsn source = new SimpleDASDsn(this.baseURL + version, version, "", this.getURL(), "");
                    this.setCurrentDsn(source);
                }
            } else if (tag.equals("CAPABILITY") || tag.equals("CATEGORY")) {
                if (this.getCurrentDsn() == null) {
                    System.out.println("Got new cability element " + attributes.getValue("type") + ", " + attributes.getValue("query_id") + " but current DSN is null");
                } else {
                    this.getCurrentDsn().addCapability(attributes.getValue("type"), attributes.getValue("query_id"));
                }
            }
        }
    }

    public void endElement(String namespaceURI, String tag, String qualifiedName) throws SAXException {
        this.closeMode();
        if (tag.equals(this.SOURCE) && this.getCurrentDsn() != null) {
            this.addDsn(this.getCurrentDsn());
            this.setCurrentDsn(null);
        }
    }

    public void characters(char[] text, int start, int length) throws SAXException {
    }
}

