/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.das.simple;

import apollo.dataadapter.das.DASSegment;
import apollo.dataadapter.das.simple.SimpleDASSegment;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DASEntryPointContentHandler
extends DefaultHandler {
    private String mode;
    private Stack modeStack = new Stack();
    private List segments = new ArrayList();
    private String ENTRY_POINTS = "ENTRY_POINTS";
    private String SEGMENT = "SEGMENT";
    private String SEGMENT_ID = "id";
    private String SEGMENT_SIZE = "size";
    private String SEGMENT_START = "start";
    private String SEGMENT_STOP = "stop";
    private String SEGMENT_ORIENTATION = "orientation";
    private String SEGMENT_SUBPARTS = "subparts";
    private DASSegment currentSegment;

    private DASSegment getCurrentSegment() {
        return this.currentSegment;
    }

    private void setCurrentSegment(DASSegment theSegment) {
        this.currentSegment = theSegment;
    }

    private void addSegment(DASSegment theSegment) {
        this.getSegments().add(theSegment);
    }

    public List getSegments() {
        return this.segments;
    }

    private Stack getModeStack() {
        return this.modeStack;
    }

    private void setMode(String theMode) {
        this.getModeStack().push(theMode);
    }

    private String getMode() {
        if (!this.getModeStack().isEmpty()) {
            return (String)this.getModeStack().peek();
        }
        return null;
    }

    private void closeMode() {
        if (!this.getModeStack().isEmpty()) {
            this.getModeStack().pop();
        }
    }

    public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes attributes) throws SAXException {
        if (this.ENTRY_POINTS.equals(localName)) {
            this.setMode(this.ENTRY_POINTS);
        } else if (this.SEGMENT.equals(localName)) {
            this.setMode(this.SEGMENT);
            this.setCurrentSegment(new SimpleDASSegment(attributes.getValue(""), attributes.getValue(this.SEGMENT_ID), attributes.getValue(this.SEGMENT_START), attributes.getValue(this.SEGMENT_STOP), attributes.getValue(this.SEGMENT_ORIENTATION), attributes.getValue(this.SEGMENT_SUBPARTS), attributes.getValue(this.SEGMENT_SIZE)));
        }
    }

    public void endElement(String namespaceURI, String localName, String qualifiedName) throws SAXException {
        if (this.ENTRY_POINTS.equals(localName)) {
            this.closeMode();
            Iterator iterator = this.getSegments().iterator();
        } else if (this.SEGMENT.equals(localName)) {
            this.addSegment(this.getCurrentSegment());
            this.setCurrentSegment(null);
            this.closeMode();
        }
    }

    public void characters(char[] text, int start, int length) throws SAXException {
        String characters = new StringBuffer().append(text, start, length).toString();
        String mode = this.getMode();
        DASSegment segment = this.getCurrentSegment();
        if (mode != null && segment != null && mode.equals(this.SEGMENT)) {
            segment.setSegment(characters);
        }
    }
}

