/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.das.simple;

import apollo.dataadapter.das.DASDsn;
import apollo.dataadapter.das.simple.SimpleDASDsn;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DASDsnContentHandler
extends DefaultHandler {
    private String mode;
    private Stack modeStack = new Stack();
    private List dsns = new ArrayList();
    private String DASDSN = "DASDSN";
    private String DSN = "DSN";
    private String SOURCE = "SOURCE";
    private String MAPMASTER = "MAPMASTER";
    private String DESCRIPTION = "DESCRIPTION";
    private String SOURCE_ID = "id";
    private String SOURCE_VERSION = "version";
    private DASDsn currentDsn;

    private DASDsn getCurrentDsn() {
        return this.currentDsn;
    }

    private void setCurrentDsn(DASDsn theDsn) {
        this.currentDsn = theDsn;
    }

    private void addDsn(DASDsn theDsn) {
        this.getDsns().add(theDsn);
    }

    public List getDsns() {
        return this.dsns;
    }

    private Stack getModeStack() {
        return this.modeStack;
    }

    private void setMode(String theMode) {
        this.getModeStack().push(theMode);
    }

    private String getMode() {
        if (!this.getModeStack().isEmpty()) {
            return (String)this.getModeStack().peek();
        }
        return null;
    }

    private void closeMode() {
        if (!this.getModeStack().isEmpty()) {
            this.getModeStack().pop();
        }
    }

    public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes attributes) throws SAXException {
        if (this.DASDSN.equals(localName)) {
            this.setMode(this.DASDSN);
        } else if (this.DSN.equals(localName)) {
            this.setMode(this.DSN);
            this.setCurrentDsn(new SimpleDASDsn("", "", "", "", ""));
        } else if (this.SOURCE.equals(localName)) {
            this.setMode(this.SOURCE);
            this.getCurrentDsn().setSourceId(attributes.getValue(this.SOURCE_ID));
            this.getCurrentDsn().setSourceVersion(attributes.getValue(this.SOURCE_VERSION));
        } else if (this.MAPMASTER.equals(localName)) {
            this.setMode(this.MAPMASTER);
        } else if (this.DESCRIPTION.equals(localName)) {
            this.setMode(this.DESCRIPTION);
        }
    }

    public void endElement(String namespaceURI, String localName, String qualifiedName) throws SAXException {
        if (this.DASDSN.equals(localName)) {
            this.closeMode();
        } else if (this.DSN.equals(localName)) {
            this.addDsn(this.getCurrentDsn());
            this.setCurrentDsn(null);
            this.closeMode();
        } else if (this.SOURCE.equals(localName)) {
            this.closeMode();
        } else if (this.MAPMASTER.equals(localName)) {
            this.closeMode();
        } else if (this.DESCRIPTION.equals(localName)) {
            this.closeMode();
        }
    }

    public void characters(char[] text, int start, int length) throws SAXException {
        String characters = new StringBuffer().append(text, start, length).toString();
        String mode = this.getMode();
        DASDsn dsn = this.getCurrentDsn();
        if (mode != null && dsn != null) {
            if (mode.equals(this.SOURCE)) {
                dsn.setSource(characters);
            } else if (mode.equals(this.MAPMASTER)) {
                dsn.setMapMaster(characters);
            } else if (mode.equals(this.DESCRIPTION)) {
                dsn.setDescription(characters);
            }
        }
    }
}

