/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.chadoxml;

import apollo.dataadapter.ApolloAdapterException;
import apollo.dataadapter.ApolloDataAdapterI;
import apollo.dataadapter.chadoxml.ChadoXmlAdapter;
import apollo.datamodel.ApolloDataI;
import apollo.datamodel.CurationSet;
import apollo.gui.GenericFileAdapterGUI;
import java.awt.BorderLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.bdgp.io.DataAdapter;
import org.bdgp.io.IOOperation;

public class ChadoXmlAdapterGUI
extends GenericFileAdapterGUI {
    private IOOperation ioOperation;
    private ChadoXmlAdapter driver;
    private JCheckBox saveAnnots = new JCheckBox("Save annotations");
    private JCheckBox saveResults = new JCheckBox("Save evidence (computational results)");

    ChadoXmlAdapterGUI() {
    }

    public void init() {
    }

    private void addCheckboxes() {
        JPanel checkboxPanel = new JPanel();
        checkboxPanel.setLayout(new BorderLayout());
        checkboxPanel.add("North", this.saveAnnots);
        checkboxPanel.add("South", this.saveResults);
        this.panel.add("South", checkboxPanel);
        this.saveAnnots.setEnabled(true);
        this.saveAnnots.setSelected(true);
        this.saveResults.setEnabled(true);
        this.saveResults.setSelected(true);
    }

    void setIOOperation(IOOperation op) {
        if (!op.equals((Object)this.ioOperation)) {
            this.ioOperation = op;
            this.removeAll();
            super.initGUI();
            super.buildGUI();
            super.attachListeners();
            if (this.ioOperation.equals((Object)ApolloDataAdapterI.OP_WRITE_DATA)) {
                this.addCheckboxes();
            }
        }
    }

    public Object doOperation(Object values) throws ApolloAdapterException {
        this.driver.setInput(this.getSelectedPath());
        if (this.ioOperation.equals((Object)ApolloDataAdapterI.OP_READ_DATA)) {
            return this.driver.getCurationSet();
        }
        if (this.ioOperation.equals((Object)ApolloDataAdapterI.OP_APPEND_DATA)) {
            return this.driver.addToCurationSet();
        }
        if (this.ioOperation.equals((Object)ApolloDataAdapterI.OP_WRITE_DATA)) {
            ApolloDataI apolloData = (ApolloDataI)values;
            CurationSet curSet = null;
            if (apolloData.isCurationSet()) {
                curSet = apolloData.getCurationSet();
            } else if (apolloData.isCompositeDataHolder()) {
                curSet = apolloData.getCompositeDataHolder().getCurationSet(0);
            }
            this.driver.commitChanges(curSet, this.saveAnnots.isSelected(), this.saveResults.isSelected());
            return null;
        }
        System.err.println("doOperation: unknown operation " + this.ioOperation);
        return null;
    }

    public void setDataAdapter(DataAdapter driver) {
        super.setDataAdapter(driver);
        if (driver instanceof ChadoXmlAdapter) {
            this.driver = (ChadoXmlAdapter)driver;
        } else {
            System.err.println("ChadoXmlAdapterGUI not compatible with adapter " + driver + " ( class " + driver.getClass().getName() + ")");
        }
    }
}

