/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.chadoxml;

import apollo.dataadapter.chado.ChadoTransaction;
import apollo.dataadapter.chado.ChadoUpdateTransaction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ChadoTransactionXMLTemplate {
    private Document doc;
    private Map defaultValues = new HashMap();
    private String startIndent = "";
    private String indent = "    ";

    public ChadoTransactionXMLTemplate(String fileName) {
        this.loadTemplates(fileName);
    }

    public ChadoTransactionXMLTemplate(String fileName, String startIndent, String indent) {
        this(fileName);
        this.startIndent = startIndent;
        this.indent = indent;
    }

    public void setStartIndent(String indent) {
        this.startIndent = indent;
    }

    public void setIndent(String indent) {
        this.indent = indent;
    }

    private void loadTemplates(String fileName) {
        try {
            DocumentBuilderFactory df = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = df.newDocumentBuilder();
            this.doc = builder.parse(fileName);
        }
        catch (Exception e) {
            System.err.println("XMLTemplate.loadTemplates(): " + e);
            e.printStackTrace();
        }
    }

    public String generateElement(ChadoTransaction tn) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.startIndent);
        buffer.append("<");
        buffer.append(tn.getTableName());
        buffer.append(" op=\"");
        buffer.append(tn.getOperation());
        buffer.append("\"");
        if (tn.getID() != null) {
            buffer.append(" id=\"");
            buffer.append(tn.getID());
            buffer.append("\"");
        }
        buffer.append(">\n");
        this.outputProperties(buffer, this.startIndent + this.indent, tn.getProperties());
        if (tn instanceof ChadoUpdateTransaction) {
            this.outputUpdateProperties(buffer, this.startIndent + this.indent, ((ChadoUpdateTransaction)tn).getUpdateProperies());
        }
        this.closeElementTag(buffer, this.indent, tn);
        return buffer.toString();
    }

    private void outputProperties(StringBuffer buffer, String indent, Map properties) {
        Iterator it = properties.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            String value = (String)properties.get(key);
            buffer.append(indent);
            buffer.append("<");
            buffer.append(key);
            buffer.append(">");
            buffer.append(value);
            buffer.append("</");
            buffer.append(key);
            buffer.append(">\n");
        }
    }

    private void outputUpdateProperties(StringBuffer buffer, String indent, Map updateProps) {
        if (updateProps == null || updateProps.size() == 0) {
            return;
        }
        Iterator it = updateProps.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            String value = (String)updateProps.get(key);
            buffer.append(indent);
            buffer.append("<");
            buffer.append(key);
            buffer.append(" op=\"update\">");
            buffer.append(value);
            buffer.append("</");
            buffer.append(key);
            buffer.append(">\n");
        }
    }

    private void closeElementTag(StringBuffer buffer, String indent, ChadoTransaction ts) {
        buffer.append(this.startIndent);
        buffer.append("</");
        buffer.append(ts.getTableName());
        buffer.append(">\n");
    }

    public Element getElement(String elmName) {
        Element root = this.doc.getDocumentElement();
        NodeList children = root.getChildNodes();
        int size = children.getLength();
        for (int i = 0; i < size; ++i) {
            Node node = children.item(i);
            if (!node.getNodeName().equals(elmName)) continue;
            return (Element)node;
        }
        return null;
    }

    public String getRootStartTag() {
        Element rootElm = this.getTxRootElement();
        StringBuffer buffer = new StringBuffer();
        buffer.append("<");
        buffer.append(rootElm.getNodeName());
        NamedNodeMap atts = rootElm.getAttributes();
        if (atts != null) {
            int size = atts.getLength();
            for (int i = 0; i < size; ++i) {
                Node node = atts.item(i);
                if (node.getNodeType() != 2) continue;
                Attr att = (Attr)node;
                buffer.append(" ");
                buffer.append(att.getName());
                buffer.append("=\"");
                buffer.append(att.getName());
                buffer.append("\"");
            }
        }
        buffer.append(">\n");
        return buffer.toString();
    }

    public String getRootEndTag() {
        Element txRootElm = this.getTxRootElement();
        return "</" + txRootElm.getNodeName() + ">\n";
    }

    private Element getTxRootElement() {
        Element rootElm = this.getElement("root");
        NodeList children = rootElm.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (node.getNodeType() != 1) continue;
            return (Element)node;
        }
        return null;
    }

    public String getPreambleString() {
        Element preamleElm = this.getElement("preamble");
        if (preamleElm != null) {
            StringBuffer buffer = new StringBuffer();
            NodeList children = preamleElm.getChildNodes();
            int size = children.getLength();
            for (int i = 0; i < size; ++i) {
                Node node = children.item(i);
                if (node.getNodeType() != 1) continue;
                this.convertElementToString((Element)node, buffer, this.startIndent);
            }
            return buffer.toString();
        }
        return null;
    }

    private void convertElementToString(Element element, StringBuffer buffer, String indent1) {
        int i;
        buffer.append(indent1);
        buffer.append("<");
        buffer.append(element.getNodeName());
        NamedNodeMap attributes = element.getAttributes();
        if (attributes != null) {
            int size = attributes.getLength();
            Node node = null;
            for (i = 0; i < size; ++i) {
                node = attributes.item(i);
                if (node.getNodeType() != 2) continue;
                Attr att = (Attr)node;
                buffer.append(" ");
                buffer.append(att.getName());
                buffer.append("=\"");
                buffer.append(att.getValue());
                buffer.append("\"");
            }
        }
        buffer.append(">");
        NodeList children = element.getChildNodes();
        int size = children.getLength();
        if (size == 1 && children.item(0).getNodeType() == 3) {
            Node textNode = children.item(0);
            buffer.append(textNode.getNodeValue());
        } else {
            buffer.append("\n");
            for (i = 0; i < size; ++i) {
                Node node = children.item(i);
                if (node.getNodeType() != 1) continue;
                this.convertElementToString((Element)node, buffer, indent1 + this.indent);
            }
            buffer.append(indent1);
        }
        buffer.append("</");
        buffer.append(element.getNodeName());
        buffer.append(">\n");
    }
}

