/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.chado.jdbc;

import apollo.dataadapter.chado.jdbc.JdbcChadoAdapter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class SybaseChadoAdapter
extends JdbcChadoAdapter {
    public SybaseChadoAdapter() {
        try {
            Driver sybDriver = (Driver)Class.forName("com.sybase.jdbc2.jdbc.SybDriver").newInstance();
            DriverManager.registerDriver(sybDriver);
        }
        catch (Throwable t) {
            System.err.println(this.getClass() + ": error initializing Sybase JDBC driver JConnect");
            t.printStackTrace(System.err);
        }
    }

    protected boolean setForcePlan(Statement stmt, boolean on) {
        String sql = "set forceplan " + (on ? "on" : "off");
        int resultval = -1;
        try {
            resultval = stmt.executeUpdate(sql);
        }
        catch (SQLException sqle) {
            return false;
        }
        return true;
    }

    protected Connection getNewConnection() throws SQLException {
        Connection conn;
        block5: {
            conn = null;
            Properties props = new Properties();
            props.setProperty("applicationname", "Apollo");
            props.setProperty("user", this.username);
            props.setProperty("password", this.password);
            try {
                conn = DriverManager.getConnection(this.jdbcUrl, props);
                if (!debug) break block5;
                try {
                    DatabaseMetaData dmd = conn.getMetaData();
                    System.err.println("   DatabaseProductName = " + dmd.getDatabaseProductName());
                    System.err.println("DatabaseProductVersion = " + dmd.getDatabaseProductVersion());
                    System.err.println("  DatabaseMajorVersion = " + dmd.getDatabaseMajorVersion());
                    System.err.println("  DatabaseMinorVersion = " + dmd.getDatabaseMinorVersion());
                }
                catch (Throwable t) {}
            }
            catch (SQLException sqle) {
                System.err.println(this.getClass() + ": exception connecting to Sybase Chado database");
                System.err.println(sqle);
                sqle.printStackTrace(System.err);
                SQLException next = sqle;
                while ((next = next.getNextException()) != null) {
                    System.err.println(next);
                    next.printStackTrace(System.err);
                }
            }
        }
        return conn;
    }

    protected String getAnalysisFeatureIdentityField() {
        return "pidentity";
    }

    protected String getBooleanTrueValue() {
        return "1";
    }

    protected String getBooleanFalseValue() {
        return "0";
    }
}

