/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.chado.jdbc;

import apollo.dataadapter.chado.jdbc.JdbcChadoAdapter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;

public class PostgresChadoAdapter
extends JdbcChadoAdapter {
    public PostgresChadoAdapter() {
        try {
            Driver pgDriver = (Driver)Class.forName("org.postgresql.Driver").newInstance();
            DriverManager.registerDriver(pgDriver);
        }
        catch (Exception e) {
            System.err.println(this.getClass() + ": error initializing Postgres JDBC driver");
            e.printStackTrace(System.err);
        }
    }

    private void setSeqscan(Connection conn, boolean on) {
        String sql = "SET ENABLE_SEQSCAN TO " + (on ? "ON" : "OFF");
        if (debug) {
            System.err.println("\n" + this + " turning off seqscan in postgres sql = " + sql + "\n");
        }
        try {
            conn.createStatement().executeUpdate(sql);
        }
        catch (SQLException sqle) {
            System.err.println(this.getClass() + ": SQLException turning off seq scan " + " in postgres " + sql);
            sqle.printStackTrace(System.err);
        }
    }

    protected String getBooleanTrueValue() {
        return "'t'";
    }

    protected String getBooleanFalseValue() {
        return "'f'";
    }
}

