/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.chado.jdbc;

import apollo.dataadapter.Region;
import apollo.dataadapter.chado.jdbc.FeatureLocImplementation;

class ChromosomeFeatureLocImp
extends FeatureLocImplementation {
    private int interbaseStart;
    private int interbaseEnd;

    protected ChromosomeFeatureLocImp(long featureId, Region baseOrientedRegion) {
        this.featId = (int)featureId;
        this.interbaseStart = baseOrientedRegion.getStart() - 1;
        this.interbaseEnd = baseOrientedRegion.getEnd();
    }

    int getBaseOrientedMinWithPadding() {
        return this.interbaseStart + 1;
    }

    int getContainingFeatureId() {
        return this.featId;
    }

    String getContainingFeatureWhereClause(String featLocTableName) {
        return " AND " + featLocTableName + ".fmax > " + this.interbaseStart + " AND " + featLocTableName + ".fmin < " + this.interbaseEnd + " ";
    }

    int getLengthWithPadding() {
        return this.interbaseEnd - this.interbaseStart;
    }

    int getMaxWithPadding() {
        return this.interbaseEnd;
    }

    boolean hasTopLevelName() {
        return true;
    }

    protected boolean featLocSameAsFeatRange() {
        return false;
    }
}

