/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.chado.jdbc;

import apollo.dataadapter.chado.jdbc.JdbcChadoAdapter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

class ChadoFeatureLoc {
    protected int fmin;
    protected int fmax;
    protected int strand;
    protected int sourceFeatureId;
    protected int featId;
    private String srcType;

    ChadoFeatureLoc(int fmin, int fmax, int strand) {
        if (fmin > fmax) {
            this.fmin = fmax;
            this.fmax = fmin;
            this.strand = -1;
        } else {
            this.fmin = fmin;
            this.fmax = fmax;
            this.strand = strand;
        }
    }

    ChadoFeatureLoc(int featId, Connection conn) {
        this.featId = featId;
        this.queryFeatLoc(conn);
        this.queryFeatType(conn);
    }

    private void queryFeatLoc(Connection conn) {
        String sql = "SELECT srcfeature_id, fmax, fmin FROM featureloc WHERE feature_id =" + this.featId;
        if (JdbcChadoAdapter.debug) {
            System.err.println("\n" + this + " get srcfeature_id sql = " + sql + "\n");
        }
        try {
            Statement s = conn.createStatement();
            ResultSet rs = s.executeQuery(sql);
            if (rs.next()) {
                this.sourceFeatureId = rs.getInt("srcfeature_id");
                this.fmin = rs.getInt("fmin");
                this.fmax = rs.getInt("fmax");
            } else {
                System.err.println(this.getClass() + ": no rows returned by sql query '" + sql + "'\n");
            }
        }
        catch (SQLException sqle) {
            System.err.println(this.getClass() + ": SQLException retrieving feature loc" + " for feature_id = " + this.featId);
            sqle.printStackTrace(System.err);
        }
    }

    protected int getSourceFeatureId() {
        return this.sourceFeatureId;
    }

    public int getFmin() {
        return this.fmin;
    }

    int getBaseOrientedMin() {
        return JdbcChadoAdapter.adjustLowForInterbaseToBaseOrientedConversion(this.getFmin());
    }

    public int getFmax() {
        return this.fmax;
    }

    public int getLength() {
        return this.fmax - this.fmin;
    }

    public int getStrand() {
        int realStrand;
        int n = realStrand = this.strand == -1 ? -1 : 1;
        if (this.fmin > this.fmax) {
            realStrand = -1;
        }
        return realStrand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void queryFeatType(Connection conn) {
        block15: {
            ResultSet result;
            PreparedStatement stat;
            block14: {
                String query = "select cv.name from cvterm cv, feature f where f.feature_id = ? AND f.type_id=cv.cvterm_id";
                stat = null;
                result = null;
                stat = conn.prepareStatement(query);
                stat.setInt(1, this.sourceFeatureId);
                result = stat.executeQuery();
                if (!result.next()) break block14;
                this.srcType = result.getString(1);
            }
            Object var7_5 = null;
            try {
                if (stat != null) {
                    stat.close();
                }
                if (result != null) {
                    result.close();
                }
                break block15;
            }
            catch (SQLException e2) {}
            break block15;
            {
                catch (SQLException e) {
                    System.err.println("ChadoFeatureLoc.queryFeatType(): " + e);
                    e.printStackTrace();
                    Object var7_6 = null;
                    try {
                        if (stat != null) {
                            stat.close();
                        }
                        if (result != null) {
                            result.close();
                        }
                        break block15;
                    }
                    catch (SQLException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                try {
                    if (stat != null) {
                        stat.close();
                    }
                    if (result != null) {
                        result.close();
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public String getSourceFeatureType() {
        return this.srcType;
    }
}

