/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.chado;

import apollo.config.Config;
import apollo.dataadapter.TransactionTransformException;
import apollo.dataadapter.TransactionTransformer;
import apollo.dataadapter.chado.ChadoTransaction;
import apollo.dataadapter.chado.ChadoUpdateTransaction;
import apollo.dataadapter.chado.jdbc.ChadoInstance;
import apollo.datamodel.AbstractSequence;
import apollo.datamodel.AnnotatedFeature;
import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.Comment;
import apollo.datamodel.DbXref;
import apollo.datamodel.ExonI;
import apollo.datamodel.Range;
import apollo.datamodel.RangeI;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.Synonym;
import apollo.datamodel.Transcript;
import apollo.editor.AddTransaction;
import apollo.editor.DeleteTransaction;
import apollo.editor.Transaction;
import apollo.editor.TransactionManager;
import apollo.editor.TransactionSubpart;
import apollo.editor.UpdateTransaction;
import apollo.editor.UserName;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class ChadoTransactionTransformer
implements TransactionTransformer {
    private Map featureLookupTns;
    private Map nameToPubLookupTns;
    private String pub_id;
    private SimpleDateFormat dateFormat;
    private List oneLevelAnnotTypes;
    private List threeLevelAnnotTypes;
    private String polypeptideType = "polypeptide";
    private String transProtRelationTerm = "derives_from";
    private boolean debug = Config.DEBUG;
    private boolean userPubTransactionAdded = false;

    public ChadoTransactionTransformer() {
        this.featureLookupTns = new HashMap();
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.oneLevelAnnotTypes = new ArrayList();
        this.threeLevelAnnotTypes = new ArrayList();
    }

    public List transform(TransactionManager transManager) throws TransactionTransformException {
        transManager.replaceIdUpdatesWithDelAndAdd();
        transManager.coalesce();
        List transactions = transManager.getTransactions();
        if (transactions == null || transactions.size() == 0) {
            return new ArrayList();
        }
        ArrayList rtn = new ArrayList(transactions.size());
        Transaction tn = null;
        Iterator it = transactions.iterator();
        while (it.hasNext()) {
            tn = (Transaction)it.next();
            if (tn.isDelete()) {
                this.transformDeleteTransaction((DeleteTransaction)tn, rtn);
                continue;
            }
            if (tn.isAdd()) {
                this.transformAddTransaction((AddTransaction)tn, rtn);
                continue;
            }
            if (!tn.isUpdate()) continue;
            this.transformUpdateTransaction((UpdateTransaction)tn, rtn);
        }
        return rtn;
    }

    private void transformUpdateTransaction(UpdateTransaction updateTn, List transformedTns) throws TransactionTransformException {
        if (updateTn.getSubpart() == null) {
            throw new IllegalArgumentException("ChadoTransactionTransformed.transformUpdateTransaction(): UpdateTransaction should have suppart defined!");
        }
        SeqFeatureI feature = updateTn.getSeqFeature();
        TransactionSubpart subpart = updateTn.getSubpart();
        if (feature instanceof ExonI) {
            this.transformExonUpdateTransactions(feature, subpart, updateTn.getOldSubpartValue(), transformedTns);
        } else {
            Object preValue = updateTn.getOldSubpartValue();
            if (subpart == TransactionSubpart.IS_DICISTRONIC) {
                boolean oldValue = (Boolean)preValue;
                this.updateBooleanProperty("dicistronic", oldValue, feature, transformedTns);
            } else if (subpart == TransactionSubpart.IS_PROBLEMATIC) {
                boolean oldValue = (Boolean)preValue;
                this.updateBooleanProperty("problem", oldValue, feature, transformedTns);
            } else if (subpart == TransactionSubpart.FINISHED) {
                boolean oldValue = (Boolean)preValue;
                this.updateBooleanProperty("finished", oldValue, feature, transformedTns);
            } else if (subpart == TransactionSubpart.COMMENT) {
                this.updateComment(updateTn, transformedTns);
            } else if (subpart == TransactionSubpart.PEPTIDE_LIMITS) {
                this.updateTranslationRange(feature, transformedTns);
            } else if (subpart == TransactionSubpart.PEPTIDE_NAME) {
                this.updatePeptideName(preValue.toString(), feature, transformedTns);
            } else if (subpart == TransactionSubpart.LIMITS) {
                this.updateFeatureRange(feature, transformedTns);
            } else if (subpart.isType()) {
                this.updateFeatureType(preValue.toString(), feature, updateTn.getOldId(), transformedTns);
            } else if (subpart == TransactionSubpart.NAME) {
                this.updateFeatureName(preValue.toString(), feature, transformedTns);
            } else if (subpart == TransactionSubpart.ID) {
                this.updateFeatureID(preValue.toString(), feature, transformedTns);
            }
        }
    }

    private void updateFeatureID(String oldId, SeqFeatureI feature, List transformedTns) {
        ChadoUpdateTransaction updateTn = new ChadoUpdateTransaction();
        updateTn.setTableName("feature");
        updateTn.addProperty("uniquename", oldId);
        updateTn.addProperty("organism_id", "organism");
        updateTn.addProperty("type_id", this.getChadoType(feature));
        updateTn.addUpdateProperty("uniquename", feature.getId());
        transformedTns.add(updateTn);
    }

    private void updateFeatureName(String oldName, SeqFeatureI feature, List transformedTns) {
        String type = this.getChadoType(feature);
        ChadoUpdateTransaction updateTn = this.makeNameTransaction(feature.getId(), feature, type, oldName, feature.getName());
        transformedTns.add(updateTn);
    }

    private void updateExonFeatName(String oldName, SeqFeatureI exon, List trans) {
        String type = this.getChadoType(exon);
        String newName = this.getChadoExonName(exon);
        ChadoUpdateTransaction ut = this.makeNameTransaction(null, exon, type, oldName, newName);
        ut.removeProperty("uniquename");
        ut.setID(newName);
        ut.setIsExon(true);
        trans.add(ut);
    }

    private ChadoUpdateTransaction makeNameTransaction(String uniqueName, SeqFeatureI feature, String type, String oldName, String newName) {
        ChadoUpdateTransaction updateTn = new ChadoUpdateTransaction();
        updateTn.setTableName("feature");
        updateTn.addProperty("uniquename", uniqueName);
        updateTn.addProperty("organism_id", "organism");
        updateTn.addProperty("type_id", type);
        if (oldName != null) {
            updateTn.addProperty("name", oldName);
        }
        updateTn.addUpdateProperty("name", newName);
        return updateTn;
    }

    private void updateFeatureType(String oldType, SeqFeatureI feature, String featureId, List transformedTns) throws TransactionTransformException {
        ChadoTransaction transaction = this.generateTnFromOperation(ChadoTransaction.DELETE);
        transaction.setTableName("feature");
        transaction.addProperty("organism_id", "organism");
        transaction.addProperty("uniquename", featureId);
        Object type = null;
        if (this.oneLevelAnnotTypes.contains(oldType)) {
            transaction.addProperty("type_id", oldType);
        } else {
            transaction.addProperty("type_id", "gene");
        }
        transformedTns.add(transaction);
        this.insertRootFeature(feature, transformedTns);
    }

    private void updateFeatureRange(SeqFeatureI feature, List transformedTns) {
        ChadoTransaction tn = (ChadoTransaction)this.featureLookupTns.get(feature.getId());
        if (tn == null) {
            tn = this.generateFeatureTransaction(feature, ChadoTransaction.LOOKUP);
            transformedTns.add(tn);
        }
        ChadoUpdateTransaction updateTn = new ChadoUpdateTransaction();
        updateTn.setTableName("featureloc");
        updateTn.addProperty("feature_id", feature.getId());
        updateTn.addProperty("strand", feature.getStrand() + "");
        int[] coord = this.convertToChadoCoord(feature);
        updateTn.addUpdateProperty("fmin", coord[0] + "");
        updateTn.addUpdateProperty("fmax", coord[1] + "");
        transformedTns.add(updateTn);
    }

    private void updateTranslationRange(SeqFeatureI feature, List transformedTns) {
        AbstractSequence sequence = (AbstractSequence)feature.getPeptideSequence();
        if (sequence == null) {
            return;
        }
        String id = sequence.getAccessionNo();
        ChadoTransaction tn = (ChadoTransaction)this.featureLookupTns.get(id);
        if (tn == null) {
            tn = this.generateTnFromOperation(ChadoTransaction.UPDATE);
            tn.setTableName("feature");
            tn.setID(id);
            tn.addProperty("uniquename", id);
            tn.addProperty("organism_id", "organism");
            tn.addProperty("type_id", this.getPolypeptideType());
            ((ChadoUpdateTransaction)tn).addUpdateProperty("residues", sequence.getResidues());
            ((ChadoUpdateTransaction)tn).addUpdateProperty("seqlen", sequence.getLength() + "");
            transformedTns.add(tn);
            this.featureLookupTns.put(id, tn);
        }
        ChadoUpdateTransaction updateTn = new ChadoUpdateTransaction();
        updateTn.setTableName("featureloc");
        updateTn.addProperty("feature_id", id);
        updateTn.addProperty("strand", feature.getStrand() + "");
        AnnotatedFeature transcript = (AnnotatedFeature)feature;
        int[] coord = this.convertToChadoCoordForProtein(transcript);
        updateTn.addUpdateProperty("fmin", coord[0] + "");
        updateTn.addUpdateProperty("fmax", coord[1] + "");
        transformedTns.add(updateTn);
    }

    private void updatePeptideName(String oldUniqueName, SeqFeatureI feature, List transformedTns) {
        String pepNewName = feature.getPeptideSequence().getAccessionNo();
        if (feature.getProteinFeat() != null) {
            pepNewName = feature.getProteinFeat().getName();
        }
        ChadoUpdateTransaction cut = this.makeNameTransaction(oldUniqueName, feature, this.getPolypeptideType(), null, pepNewName);
        transformedTns.add(cut);
    }

    public void setChadoInstance(ChadoInstance instance) {
        this.setPolypeptideType(instance.getPolypeptideType());
        this.setOneLevelAnnotTypes(instance.getOneLevelAnnotTypes());
        this.setThreeLevelAnnotTypes(instance.getThreeLevelAnnotTypes());
        this.transProtRelationTerm = instance.getTransProtRelationTerm();
    }

    public String getPolypeptideType() {
        return this.polypeptideType;
    }

    public void setPolypeptideType(String type) {
        this.polypeptideType = type;
    }

    private void updateComment(UpdateTransaction updateTn, List transformedTns) {
        AnnotatedFeature feature = (AnnotatedFeature)updateTn.getSeqFeature();
        ChadoTransaction tn = (ChadoTransaction)this.featureLookupTns.get(feature.getId());
        if (tn == null) {
            tn = this.generateFeatureTransaction(feature, ChadoTransaction.LOOKUP);
            transformedTns.add(tn);
        }
        int index = updateTn.getSubpartRank();
        Comment comment = (Comment)feature.getComments().get(index);
        String newValue = this.createChadoCommentValue(comment.getText(), comment);
        String oldText = updateTn.getOldComment().getText();
        String oldValue = this.createChadoCommentValue(oldText, comment);
        tn = new ChadoUpdateTransaction();
        tn.setTableName("featureprop");
        tn.addProperty("feature_id", feature.getId());
        tn.addProperty("type_id", "comment");
        tn.addProperty("value", oldValue);
        ((ChadoUpdateTransaction)tn).addUpdateProperty("value", newValue);
        transformedTns.add(tn);
    }

    private void updateBooleanProperty(String propName, boolean preValue, SeqFeatureI feature, List transformedTns) {
        ChadoTransaction tn = (ChadoTransaction)this.featureLookupTns.get(feature.getId());
        if (tn == null) {
            tn = this.generateFeatureTransaction(feature, ChadoTransaction.LOOKUP);
            transformedTns.add(tn);
        }
        tn = this.generatePropertyTransaction(feature.getId(), propName, preValue + "", 0, ChadoTransaction.DELETE);
        transformedTns.add(tn);
        tn = this.generatePropertyTransaction(feature.getId(), propName, !preValue + "", 0, ChadoTransaction.INSERT);
        transformedTns.add(tn);
    }

    private void transformExonUpdateTransactions(SeqFeatureI feature, TransactionSubpart subpart, Object preValue, List transformedTns) throws TransactionTransformException {
        if (subpart == TransactionSubpart.LIMITS) {
            this.updateExonRange(feature, (Range)preValue, transformedTns);
        } else if (subpart == TransactionSubpart.PARENT) {
            this.updateExonParent(feature, (SeqFeatureI)preValue, transformedTns);
        }
    }

    private void updateExonParent(SeqFeatureI feature, SeqFeatureI oldParent, List transformedTns) {
        SeqFeatureI newParent = feature.getRefFeature();
        ChadoTransaction lookupTn = (ChadoTransaction)this.featureLookupTns.get(feature.getId());
        if (lookupTn == null) {
            lookupTn = this.generateFeatureTransaction(feature, ChadoTransaction.LOOKUP);
            transformedTns.add(lookupTn);
        }
        if ((lookupTn = (ChadoTransaction)this.featureLookupTns.get(newParent.getId())) == null) {
            lookupTn = this.generateFeatureTransaction(newParent, ChadoTransaction.LOOKUP);
            transformedTns.add(lookupTn);
        }
        if ((lookupTn = (ChadoTransaction)this.featureLookupTns.get(oldParent.getId())) == null) {
            lookupTn = this.generateFeatureTransaction(oldParent, ChadoTransaction.LOOKUP);
            transformedTns.add(lookupTn);
        }
        ChadoUpdateTransaction updateTn = new ChadoUpdateTransaction();
        updateTn.setTableName("feature_relationship");
        updateTn.addProperty("subject_id", feature.getId());
        updateTn.addProperty("object_id", oldParent.getId());
        updateTn.addProperty("type_id", "partof");
        updateTn.addUpdateProperty("object_id", newParent.getId());
        transformedTns.add(updateTn);
    }

    private void updateExonRange(SeqFeatureI exon, Range oldRange, List transformedTns) throws TransactionTransformException {
        SeqFeatureI transcript = exon.getRefFeature();
        String geneName = transcript.getRefFeature().getName();
        String oldChadoName = this.getChadoExonName(geneName, oldRange);
        String newName = this.getChadoExonName(exon);
        boolean isOldShared = this.isExonShared(transcript, oldRange.getStart(), oldRange.getEnd());
        boolean isNewShared = this.isExonShared(transcript, exon.getStart(), exon.getEnd());
        if (!isOldShared && !isNewShared) {
            this.updateExonFeatName(oldChadoName, exon, transformedTns);
            ChadoUpdateTransaction chadoTn = new ChadoUpdateTransaction();
            chadoTn.setTableName("featureloc");
            chadoTn.addProperty("feature_id", newName);
            chadoTn.addProperty("strand", exon.getStrand() + "");
            int[] coord = this.convertToChadoCoord(exon);
            chadoTn.addUpdateProperty("fmin", coord[0] + "");
            chadoTn.addUpdateProperty("fmax", coord[1] + "");
            transformedTns.add(chadoTn);
        } else if (!isOldShared && isNewShared) {
            ChadoTransaction lookupTran;
            ChadoTransaction deleteExon = this.generateTnFromOperation(ChadoTransaction.DELETE);
            deleteExon.setTableName("feature");
            deleteExon.addProperty("name", oldChadoName);
            deleteExon.addProperty("type_id", "exon");
            deleteExon.addProperty("organism_id", "organism");
            transformedTns.add(deleteExon);
            ChadoTransaction lookupExon = (ChadoTransaction)this.featureLookupTns.get(newName);
            if (lookupExon == null) {
                lookupExon = this.generateExonFeatureTransaction(exon, newName, ChadoTransaction.LOOKUP);
                transformedTns.add(lookupExon);
            }
            if ((lookupTran = (ChadoTransaction)this.featureLookupTns.get(transcript)) == null) {
                lookupTran = this.generateFeatureTransaction(transcript, ChadoTransaction.LOOKUP);
                transformedTns.add(lookupTran);
            }
            ChadoTransaction addFeatRel = this.generateExonFeatRelTrans(exon, newName, transcript, ChadoTransaction.INSERT);
            transformedTns.add(addFeatRel);
        } else if (isOldShared && !isNewShared) {
            ChadoTransaction lookupTran = (ChadoTransaction)this.featureLookupTns.get(transcript.getId());
            if (lookupTran == null) {
                lookupTran = this.generateFeatureTransaction(transcript, ChadoTransaction.LOOKUP);
                transformedTns.add(lookupTran);
            }
            if (!this.haveLookupTransaction(oldChadoName)) {
                ChadoTransaction lookupExon = this.generateExonFeatureTransaction(exon, oldChadoName, ChadoTransaction.LOOKUP);
                transformedTns.add(lookupExon);
            }
            ChadoTransaction delFeatRel = this.generateTnFromOperation(ChadoTransaction.DELETE);
            delFeatRel.setTableName("feature_relationship");
            delFeatRel.addProperty("subject_id", oldChadoName);
            delFeatRel.addProperty("object_id", transcript.getId());
            delFeatRel.addProperty("type_id", "partof");
            transformedTns.add(delFeatRel);
            this.insertExon(exon, transformedTns);
        } else {
            ChadoTransaction lookupTran;
            ChadoTransaction lookupExon = (ChadoTransaction)this.featureLookupTns.get(oldChadoName);
            if (lookupExon == null) {
                exon.setId(oldChadoName);
                lookupExon = this.generateFeatureTransaction(exon, ChadoTransaction.LOOKUP);
                transformedTns.add(lookupExon);
                exon.setId(newName);
            }
            if ((lookupExon = (ChadoTransaction)this.featureLookupTns.get(newName)) == null) {
                lookupExon = this.generateFeatureTransaction(exon, ChadoTransaction.LOOKUP);
                transformedTns.add(lookupExon);
            }
            if ((lookupTran = (ChadoTransaction)this.featureLookupTns.get(transcript)) == null) {
                lookupTran = this.generateFeatureTransaction(transcript, ChadoTransaction.LOOKUP);
                transformedTns.add(lookupTran);
            }
            ChadoUpdateTransaction update = new ChadoUpdateTransaction();
            update.setTableName("feature_relationship");
            update.addProperty("object_id", transcript.getId());
            update.addProperty("subject_id", oldChadoName);
            update.addProperty("type_id", "partof");
            update.addUpdateProperty("subject_id", newName);
            transformedTns.add(update);
        }
    }

    private void transformAddSubpartTransaction(AddTransaction tn, List transformedTns) {
        SeqFeatureI feature = tn.getSeqFeature();
        Object chadoTn = null;
        TransactionSubpart subpart = tn.getSubpart();
        Object newValue = tn.getNewSubpartValue();
        if (subpart == TransactionSubpart.SYNONYM) {
            this.addSynonymTransactions(feature.getAnnotatedFeature(), 0, newValue.toString(), transformedTns);
        } else if (subpart == TransactionSubpart.COMMENT) {
            this.addCommentsTransaction(feature.getAnnotatedFeature(), tn.getSubpartRank(), (Comment)newValue, transformedTns);
        }
    }

    private void transformAddTransaction(AddTransaction tn, List transformedTns) throws TransactionTransformException {
        if (tn.getSubpart() != null) {
            this.transformAddSubpartTransaction(tn, transformedTns);
            return;
        }
        SeqFeatureI feature = tn.getSeqFeature();
        if (tn.isAddPeptide()) {
            this.addProteinTransactions(feature.getAnnotatedFeature(), transformedTns);
        } else if (feature.isExon()) {
            this.insertExon(feature, transformedTns);
        } else if (feature.isTranscript()) {
            this.insertTranscript(feature, transformedTns, true);
        } else {
            String residues = tn.getResidues();
            this.insertRootFeature(feature, residues, transformedTns);
        }
    }

    private void insertRootFeature(SeqFeatureI f, List chadoTrans) throws TransactionTransformException {
        this.insertRootFeature(f, null, chadoTrans);
    }

    private void insertRootFeature(SeqFeatureI feature, String residues, List transformedTns) throws TransactionTransformException {
        String type = feature.getFeatureType();
        if (type.equals("miscellaneous curator's observation")) {
            type = "remark";
        }
        if (this.oneLevelAnnotTypes != null && this.oneLevelAnnotTypes.contains(type)) {
            this.insertOneLevelFeature(feature, residues, transformedTns);
        } else {
            this.insertGene(feature, transformedTns);
        }
    }

    private void insertOneLevelFeature(SeqFeatureI f, List chadoTrans) throws TransactionTransformException {
        this.insertOneLevelFeature(f, null, chadoTrans);
    }

    private void insertOneLevelFeature(SeqFeatureI feature, String residues, List transformedTns) throws TransactionTransformException {
        AnnotatedFeatureI annotFeat = feature.getAnnotatedFeature();
        ChadoTransaction chadoTn = this.generateFeatureTransaction(annotFeat, residues, ChadoTransaction.INSERT);
        transformedTns.add(chadoTn);
        chadoTn = this.generateFeatureLocTransaction(annotFeat, ChadoTransaction.INSERT);
        transformedTns.add(chadoTn);
        this.addCommentsTransaction(annotFeat, transformedTns);
        this.addSynTransForNewAnnot(annotFeat, transformedTns);
        this.addDbxrefTransactions(annotFeat.getDbXrefs(), transformedTns, feature.getId());
        this.addPropsTransactions(annotFeat, transformedTns);
    }

    private void insertGene(SeqFeatureI feature, List transformedTns) throws TransactionTransformException {
        ChadoTransaction chadoTn;
        this.insertOneLevelFeature(feature, transformedTns);
        AnnotatedFeature annotFeat = (AnnotatedFeature)feature;
        Vector transcripts = annotFeat.getFeatures();
        if (transcripts.size() == 0) {
            ChadoTransactionTransformer.debugPrint("Gene has 0 transcripts to insert, very suspicious");
        }
        Iterator it = transcripts.iterator();
        while (it.hasNext()) {
            SeqFeatureI feat = (SeqFeatureI)it.next();
            if (!feat.isTranscript()) continue;
            this.insertTranscript(feat, transformedTns, false);
        }
        List exons = this.getExonsFromAnnotFeat(annotFeat);
        Iterator it2 = exons.iterator();
        while (it2.hasNext()) {
            SeqFeatureI exon = (SeqFeatureI)it2.next();
            String chadoExonName = this.getNewChadoExonName(exon);
            chadoTn = this.generateExonFeatureTransaction(exon, chadoExonName, ChadoTransaction.INSERT);
            transformedTns.add(chadoTn);
            chadoTn = this.genExonFeatLocTransaction(exon, chadoExonName, ChadoTransaction.INSERT);
            transformedTns.add(chadoTn);
        }
        it2 = transcripts.iterator();
        while (it2.hasNext()) {
            SeqFeatureI transcript = (SeqFeatureI)it2.next();
            if (!transcript.isTranscript()) continue;
            Iterator it1 = transcript.getFeatures().iterator();
            while (it1.hasNext()) {
                SeqFeatureI exon = (SeqFeatureI)it1.next();
                if (!exon.isExon()) continue;
                String chadoExonName = this.getNewChadoExonName(exon);
                chadoTn = this.generateExonFeatRelTrans(exon, chadoExonName, transcript, ChadoTransaction.INSERT);
                transformedTns.add(chadoTn);
            }
        }
    }

    private List getExonsFromAnnotFeat(AnnotatedFeature gene) {
        HashMap<String, SeqFeatureI> exons = new HashMap<String, SeqFeatureI>();
        SeqFeatureI feat = null;
        Iterator it = gene.getFeatures().iterator();
        while (it.hasNext()) {
            feat = (SeqFeatureI)it.next();
            if (!(feat instanceof Transcript)) continue;
            Iterator it1 = feat.getFeatures().iterator();
            while (it1.hasNext()) {
                SeqFeatureI feat1 = (SeqFeatureI)it1.next();
                if (!(feat1 instanceof ExonI)) continue;
                String key = feat1.getStart() + "-" + feat1.getEnd();
                exons.put(key, feat1);
            }
        }
        return new ArrayList(exons.values());
    }

    private void insertTranscript(SeqFeatureI feature, List transformedTns, boolean needExon) throws TransactionTransformException {
        Transcript transcript = (Transcript)feature;
        AnnotatedFeatureI gene = transcript.getGene();
        ChadoTransaction chadoTn = (ChadoTransaction)this.featureLookupTns.get(gene.getId());
        if (chadoTn == null) {
            chadoTn = this.generateFeatureTransaction(gene, ChadoTransaction.LOOKUP);
            transformedTns.add(chadoTn);
        }
        chadoTn = this.generateFeatureTransaction(feature, ChadoTransaction.INSERT);
        transformedTns.add(chadoTn);
        try {
            chadoTn = this.generateFeatureLocTransaction(feature, ChadoTransaction.INSERT);
        }
        catch (FeatLocException fle) {
            System.out.println("ERROR: Faulty featureLoc/Range. Disregarding rest of transcript insert." + fle.getMessage());
        }
        transformedTns.add(chadoTn);
        chadoTn = this.generateFeatureRelTransaction(feature, ChadoTransaction.INSERT);
        transformedTns.add(chadoTn);
        this.addCommentsTransaction(transcript, transformedTns);
        this.addSynTransForNewAnnot(transcript, transformedTns);
        this.addDbxrefTransactions(transcript.getDbXrefs(), transformedTns, feature.getId());
        this.addPropsTransactions(transcript, transformedTns);
        if (needExon) {
            Vector exons = transcript.getFeatures();
            Iterator it = exons.iterator();
            while (it.hasNext()) {
                SeqFeatureI feat = (SeqFeatureI)it.next();
                if (!feat.isExon()) continue;
                this.insertExon(feat, transformedTns);
            }
        }
        this.addProteinTransactions(transcript, transformedTns);
    }

    private void addProteinTransactions(AnnotatedFeatureI transcript, List chadoTransactions) {
        if (!transcript.isProteinCodingGene()) {
            return;
        }
        AbstractSequence sequence = (AbstractSequence)transcript.getPeptideSequence();
        if (sequence == null) {
            return;
        }
        ChadoTransaction tn = this.generateTnFromOperation(ChadoTransaction.INSERT);
        tn.setTableName("feature");
        tn.setID(sequence.getAccessionNo());
        tn.addProperty("uniquename", sequence.getAccessionNo());
        tn.addProperty("residues", sequence.getResidues());
        tn.addProperty("organism_id", "organism");
        if (sequence.getChecksum() != null) {
            tn.addProperty("md5checksum", sequence.getChecksum());
        }
        tn.addProperty("seqlen", sequence.getLength() + "");
        tn.addProperty("type_id", this.getPolypeptideType());
        chadoTransactions.add(tn);
        this.featureLookupTns.put(sequence.getAccessionNo(), tn);
        if (!this.haveLookupTransaction(transcript)) {
            tn = this.generateFeatureTransaction(transcript, ChadoTransaction.LOOKUP);
            chadoTransactions.add(tn);
        }
        tn = this.generateTnFromOperation(ChadoTransaction.INSERT);
        tn.setTableName("feature_relationship");
        tn.addProperty("object_id", transcript.getId());
        tn.addProperty("subject_id", sequence.getAccessionNo());
        tn.addProperty("type_id", this.transProtRelationTerm);
        chadoTransactions.add(tn);
        tn = this.generateTnFromOperation(ChadoTransaction.INSERT);
        tn.setTableName("featureloc");
        tn.addProperty("feature_id", sequence.getAccessionNo());
        tn.addProperty("srcfeature_id", "genomicSequence");
        tn.addProperty("strand", transcript.getStrand() + "");
        int[] coord = this.convertToChadoCoordForProtein(transcript);
        tn.addProperty("fmin", coord[0] + "");
        tn.addProperty("fmax", coord[1] + "");
        chadoTransactions.add(tn);
    }

    private void addSynTransForNewAnnot(AnnotatedFeatureI newAnnot, List chadoTransactions) {
        Vector synonyms = newAnnot.getSynonyms();
        if (synonyms == null || synonyms.size() == 0) {
            return;
        }
        Synonym synonym = null;
        Object tn = null;
        int index = 0;
        Iterator it = synonyms.iterator();
        while (it.hasNext()) {
            synonym = (Synonym)it.next();
            this.addSynonymTransactions(newAnnot, index, synonym.getName(), chadoTransactions);
            ++index;
        }
    }

    private void addSynonymTransactions(AnnotatedFeatureI feature, int index, String synonym, List chadoTransactions) {
        this.addUserPubTransaction(chadoTransactions);
        ChadoTransaction tn = null;
        tn = this.generateTnFromOperation(ChadoTransaction.FORCE);
        String id = feature.getId() + ".synonym." + index;
        tn.setID(id);
        tn.setTableName("synonym");
        tn.addProperty("name", synonym);
        tn.addProperty("synonym_sgml", synonym);
        tn.addProperty("type_id", "synonym");
        chadoTransactions.add(tn);
        tn = (ChadoTransaction)this.featureLookupTns.get(feature.getId());
        if (tn == null) {
            tn = this.generateFeatureTransaction(feature, ChadoTransaction.LOOKUP);
            chadoTransactions.add(tn);
        }
        tn = this.generateTnFromOperation(ChadoTransaction.INSERT);
        tn.setTableName("feature_synonym");
        tn.addProperty("feature_id", feature.getId());
        tn.addProperty("synonym_id", id);
        tn.addProperty("pub_id", this.pub_id);
        tn.addProperty("is_internal", "0");
        tn.addProperty("is_current", "1");
        chadoTransactions.add(tn);
    }

    private void insertExon(SeqFeatureI exon, List transformedTns) throws FeatLocException {
        SeqFeatureI transcript = exon.getRefFeature();
        ChadoTransaction chadoTn = (ChadoTransaction)this.featureLookupTns.get(transcript.getId());
        if (chadoTn == null) {
            chadoTn = this.generateFeatureTransaction(transcript, ChadoTransaction.LOOKUP);
            transformedTns.add(chadoTn);
        }
        if (exon.getId().indexOf("temp") == -1) {
            exon.setId(exon.getId() + "-temp");
        }
        ChadoTransaction.Operation FORCE = ChadoTransaction.FORCE;
        String chadoExName = this.getChadoExonName(exon);
        chadoTn = this.generateExonFeatureTransaction(exon, chadoExName, FORCE);
        transformedTns.add(chadoTn);
        chadoTn = this.genExonFeatLocTransaction(exon, chadoExName, FORCE);
        transformedTns.add(chadoTn);
        chadoTn = this.generateExonFeatRelTrans(exon, chadoExName, transcript, FORCE);
        transformedTns.add(chadoTn);
    }

    private void addDbxrefTransactions(List dbxrefs, List chadoTransactions, String featureID) {
        if (dbxrefs == null || dbxrefs.size() == 0) {
            return;
        }
        DbXref xref = null;
        ChadoTransaction tn = null;
        int index = 0;
        Iterator it = dbxrefs.iterator();
        while (it.hasNext()) {
            xref = (DbXref)it.next();
            tn = this.generateTnFromOperation(ChadoTransaction.FORCE);
            String id = featureID + ".dbxref." + index;
            tn.setID(id);
            tn.setTableName("dbxref");
            String dbName = xref.getDbName();
            if (!dbName.startsWith("DB")) {
                dbName = "DB:" + dbName;
            }
            tn.addProperty("db_id", dbName);
            tn.addProperty("accession", xref.getIdValue());
            chadoTransactions.add(tn);
            tn = this.generateTnFromOperation(ChadoTransaction.INSERT);
            tn.setTableName("feature_dbxref");
            tn.addProperty("feature_id", featureID);
            tn.addProperty("dbxref_id", id);
            chadoTransactions.add(tn);
            ++index;
        }
    }

    private void addPropsTransactions(AnnotatedFeatureI transcript, List chadoTransactions) {
        Hashtable properties;
        String id = transcript.getId();
        ChadoTransaction tn = null;
        String owner = transcript.getOwner();
        if (owner != null && owner.length() > 0) {
            tn = this.generatePropertyTransaction(id, "owner", owner, 0, ChadoTransaction.INSERT);
            chadoTransactions.add(tn);
        }
        if (transcript.isProblematic()) {
            tn = this.generatePropertyTransaction(id, "problem", "true", 0, ChadoTransaction.INSERT);
            chadoTransactions.add(tn);
        }
        if (transcript.getDescription() != null && transcript.getDescription().length() > 0) {
            tn = this.generatePropertyTransaction(id, "description", transcript.getDescription(), 0, ChadoTransaction.INSERT);
            chadoTransactions.add(tn);
        }
        if ((properties = transcript.getProperties()) != null && properties.size() > 0) {
            Iterator it = properties.keySet().iterator();
            while (it.hasNext()) {
                String name = (String)it.next();
                Object obj = properties.get(name);
                if (obj instanceof List) {
                    List values = (List)properties.get(name);
                    if (values == null || values.size() == 0) continue;
                    for (int i = 0; i < values.size(); ++i) {
                        String value = (String)values.get(0);
                        tn = this.generatePropertyTransaction(id, name, value, i, ChadoTransaction.INSERT);
                        chadoTransactions.add(tn);
                    }
                    continue;
                }
                if (obj.toString().length() <= 0) continue;
                tn = this.generatePropertyTransaction(id, name, obj.toString(), 0, ChadoTransaction.INSERT);
                chadoTransactions.add(tn);
            }
        }
    }

    private void addCommentsTransaction(AnnotatedFeatureI feature, List chadoTransactions) {
        if (feature.getComments() == null || feature.getComments().size() == 0) {
            return;
        }
        String id = feature.getId();
        Vector comments = feature.getComments();
        Comment comment = null;
        Object value = null;
        Object tn = null;
        int index = 0;
        Iterator it = comments.iterator();
        while (it.hasNext()) {
            comment = (Comment)it.next();
            this.addCommentsTransaction(feature, index, comment, chadoTransactions);
            ++index;
        }
    }

    private void addCommentsTransaction(AnnotatedFeatureI feature, int index, Comment comment, List chadoTransactions) {
        this.addUserPubTransaction(chadoTransactions);
        if (comment == null) {
            String m = "Cant transform comment transaction to chado trans as comment is null";
            System.out.println(m);
            return;
        }
        ChadoTransaction tn = (ChadoTransaction)this.featureLookupTns.get(feature.getId());
        if (tn == null) {
            tn = this.generateFeatureTransaction(feature, ChadoTransaction.LOOKUP);
            chadoTransactions.add(tn);
        }
        String value = this.createChadoCommentValue(comment.getText(), comment);
        tn = this.generatePropertyTransaction(feature.getId(), "comment", value, index, ChadoTransaction.INSERT);
        String featPropID = feature.getId() + ".comment." + index;
        tn.setID(featPropID);
        chadoTransactions.add(tn);
        if (this.pub_id != null && this.pub_id.length() > 0) {
            tn = this.generateTnFromOperation(ChadoTransaction.INSERT);
            tn.setTableName("featureprop_pub");
            tn.addProperty("featureprop_id", featPropID);
            tn.addProperty("pub_id", this.pub_id);
            chadoTransactions.add(tn);
        }
    }

    private ChadoTransaction generatePropertyTransaction(String id, String type, String value, int rank, ChadoTransaction.Operation op) {
        ChadoTransaction tn = this.generateTnFromOperation(op);
        tn.setTableName("featureprop");
        tn.addProperty("feature_id", id);
        tn.addProperty("type_id", type);
        tn.addProperty("value", value);
        if (rank > -1) {
            tn.addProperty("rank", rank + "");
        }
        return tn;
    }

    private void transformDeleteSubpartTransaction(DeleteTransaction tn, List transformedTns) {
        SeqFeatureI feature = tn.getSeqFeature();
        Object chadoTn = null;
        TransactionSubpart subpart = tn.getSubpart();
        Object deletedValue = tn.getOldSubpartValue();
        if (deletedValue == null) {
            String m = "\nChado Transaction: Dropping delete transasction - null subpart value for " + subpart + " for feature " + feature.getName() + "\n";
            System.out.println(m);
            if (Config.DEBUG) {
                System.out.println("\nDEBUG:\nStackTrace: ");
                new Throwable().printStackTrace();
            }
            return;
        }
        if (subpart == TransactionSubpart.SYNONYM) {
            Synonym syn = (Synonym)deletedValue;
            this.deleteSynonymTransaction(feature, syn, transformedTns);
        } else if (subpart == TransactionSubpart.COMMENT) {
            this.deleteCommentTransaction((AnnotatedFeatureI)feature, (Comment)deletedValue, transformedTns);
        }
    }

    private void deleteSynonymTransaction(SeqFeatureI feature, Synonym synonym, List transformedTns) {
        String synOwner = synonym.hasOwner() ? synonym.getOwner() : UserName.getUserName();
        this.addPubLookup(synOwner, transformedTns);
        ChadoTransaction tn = null;
        tn = this.generateTnFromOperation(ChadoTransaction.LOOKUP);
        String synonymId = feature.getId() + ".synonym";
        tn.setID(synonymId);
        tn.setTableName("synonym");
        tn.addProperty("name", synonym.getName());
        tn.addProperty("type_id", "synonym");
        transformedTns.add(tn);
        tn = (ChadoTransaction)this.featureLookupTns.get(feature.getId());
        if (tn == null) {
            tn = this.generateFeatureTransaction(feature, ChadoTransaction.LOOKUP);
            transformedTns.add(tn);
        }
        tn = this.generateTnFromOperation(ChadoTransaction.DELETE);
        tn.setTableName("feature_synonym");
        tn.addProperty("feature_id", feature.getId());
        tn.addProperty("synonym_id", synonymId);
        tn.addProperty("pub_id", synOwner);
        transformedTns.add(tn);
    }

    private void deleteCommentTransaction(AnnotatedFeatureI feature, Comment comment, List transformedTns) {
        ChadoTransaction tn = (ChadoTransaction)this.featureLookupTns.get(feature.getId());
        if (tn == null) {
            tn = this.generateFeatureTransaction(feature, ChadoTransaction.LOOKUP);
            transformedTns.add(tn);
        }
        String value = this.createChadoCommentValue(comment.getText(), comment);
        tn = this.generatePropertyTransaction(feature.getId(), "comment", value, -1, ChadoTransaction.DELETE);
        transformedTns.add(tn);
    }

    private String createChadoCommentValue(String text, Comment comment) {
        Date date = new Date(comment.getTimeStamp());
        String dateStr = this.dateFormat.format(date);
        return text + "::DATE:" + dateStr + "::TS:" + comment.getTimeStamp();
    }

    private void transformDeleteTransaction(DeleteTransaction tn, List transformedTns) {
        if (tn.getSubpart() != null) {
            this.transformDeleteSubpartTransaction(tn, transformedTns);
            return;
        }
        ChadoTransaction chadoTn = null;
        SeqFeatureI feature = tn.getSeqFeature();
        if (feature.isExon()) {
            String chadoExonName;
            String transcriptName = tn.getParentFeature().getName();
            if (!this.haveLookupTransaction(tn.getParentFeature())) {
                chadoTn = this.generateFeatureTransaction(tn.getParentFeature(), ChadoTransaction.LOOKUP);
                transformedTns.add(chadoTn);
            }
            if (!this.haveLookupTransaction(chadoExonName = this.getChadoExonName(feature))) {
                chadoTn = this.generateExonFeatureTransaction(feature, chadoExonName, ChadoTransaction.LOOKUP);
                transformedTns.add(chadoTn);
                this.featureLookupTns.put(chadoExonName, chadoTn);
            }
            chadoTn = this.generateFeatureRelTransaction(feature, chadoExonName, tn.getParentFeature(), ChadoTransaction.DELETE);
            transformedTns.add(chadoTn);
        } else if (feature instanceof Transcript) {
            chadoTn = this.generateFeatureTransaction(feature, ChadoTransaction.DELETE);
            transformedTns.add(chadoTn);
        } else {
            chadoTn = this.generateFeatureTransaction(feature, ChadoTransaction.DELETE);
            transformedTns.add(chadoTn);
        }
    }

    private boolean haveLookupTransaction(SeqFeatureI feat) {
        if (feat.isExon()) {
            return this.haveLookupTransaction(this.getChadoExonName(feat));
        }
        return this.haveLookupTransaction(feat.getId());
    }

    private boolean haveLookupTransaction(String lookupKey) {
        return this.featureLookupTns.get(lookupKey) != null;
    }

    private ChadoTransaction generateFeatureTransaction(SeqFeatureI f, ChadoTransaction.Operation op) {
        return this.generateFeatureTransaction(f, null, op);
    }

    private ChadoTransaction generateFeatureTransaction(SeqFeatureI feature, String residues, ChadoTransaction.Operation op) {
        ChadoTransaction transaction = this.generateTnFromOperation(op);
        transaction.setTableName("feature");
        transaction.setID(feature.getId());
        transaction.addProperty("organism_id", "organism");
        String rootType = this.getRootType(feature);
        boolean isRoot = feature.isAnnotTop();
        if (op == ChadoTransaction.INSERT && !rootType.equals("gene")) {
            String id = this.insertTypeToTempName(feature.getId(), rootType, isRoot);
            String name = this.insertTypeToTempName(feature.getName(), rootType, isRoot);
            transaction.addProperty("uniquename", id);
            if (!feature.isExon()) {
                transaction.addProperty("name", name);
            }
        } else {
            transaction.addProperty("uniquename", feature.getId());
            if (!feature.isExon() && op != ChadoTransaction.DELETE) {
                transaction.addProperty("name", feature.getName());
            }
        }
        transaction.addProperty("type_id", this.getChadoType(feature));
        if (residues != null) {
            transaction.addProperty("residues", residues);
        }
        if (op == ChadoTransaction.LOOKUP || op == ChadoTransaction.INSERT || op == ChadoTransaction.FORCE) {
            this.featureLookupTns.put(feature.getId(), transaction);
        }
        return transaction;
    }

    private ChadoTransaction generateExonFeatureTransaction(SeqFeatureI exon, String name, ChadoTransaction.Operation op) {
        ChadoTransaction transaction = this.generateFeatureTransaction(exon, op);
        transaction.setIsExon(true);
        transaction.addProperty("name", name);
        transaction.setID(name);
        return transaction;
    }

    private ChadoTransaction genExonFeatLocTransaction(SeqFeatureI exon, String name, ChadoTransaction.Operation op) throws FeatLocException {
        ChadoTransaction transaction = this.generateFeatureLocTransaction(exon, op);
        transaction.addProperty("feature_id", name);
        return transaction;
    }

    private ChadoTransaction generateExonFeatRelTrans(SeqFeatureI exon, String name, SeqFeatureI transcript, ChadoTransaction.Operation op) {
        ChadoTransaction transaction = this.generateFeatureRelTransaction(exon, transcript, op);
        transaction.addProperty("subject_id", name);
        return transaction;
    }

    private String getChadoExonName(SeqFeatureI exon) {
        String geneName = exon.getRefFeature().getRefFeature().getName();
        return this.getChadoExonName(geneName, exon);
    }

    private String getChadoExonName(String geneName, RangeI range) {
        RangeI interbaseRange = this.convertBaseOrientedToInterbase(range);
        return geneName + ":" + interbaseRange.getLow() + "-" + interbaseRange.getHigh();
    }

    private String getNewChadoExonName(SeqFeatureI exon) {
        return this.getChadoExonName(exon) + "-temp";
    }

    private RangeI convertBaseOrientedToInterbase(RangeI baseOriented) {
        return new Range(baseOriented.getLow() - 1, baseOriented.getHigh());
    }

    private String getRootType(SeqFeatureI feature) {
        if (feature instanceof ExonI) {
            return ((ExonI)feature).getTranscript().getGene().getFeatureType();
        }
        if (feature instanceof Transcript) {
            return ((Transcript)feature).getGene().getFeatureType();
        }
        return feature.getFeatureType();
    }

    private String insertTypeToTempName(String name, String type, boolean isRoot) {
        int index = name.indexOf("temp");
        if (index < 0) {
            return name;
        }
        if (name.startsWith("CG")) {
            name = "CR" + name.substring(2);
        }
        if (this.oneLevelAnnotTypes.contains(type) && (name.startsWith("CG:") || name.startsWith("CR:"))) {
            return name.substring(0, 3) + type + ":" + name.substring(3);
        }
        return name;
    }

    private ChadoTransaction generateFeatureLocTransaction(SeqFeatureI feature, ChadoTransaction.Operation op) throws FeatLocException {
        if (feature.rangeIsUnassigned()) {
            String m = "ERROR: Transaction transform to chado transactions has failed.\nFeature " + feature + " has no range for feat loc transaction. " + "Could be that its been deleted. ";
            throw new FeatLocException(m);
        }
        ChadoTransaction transaction = this.generateTnFromOperation(op);
        transaction.setTableName("featureloc");
        transaction.addProperty("feature_id", feature.getId());
        transaction.addProperty("srcfeature_id", "genomicSequence");
        transaction.addProperty("strand", feature.getStrand() + "");
        int[] coord = this.convertToChadoCoord(feature);
        transaction.addProperty("fmin", coord[0] + "");
        transaction.addProperty("fmax", coord[1] + "");
        return transaction;
    }

    private int[] convertToChadoCoord(SeqFeatureI feature) {
        int[] coord = new int[]{feature.getFeatureType().equals("nucleotide_insertion") ? feature.getLow() : feature.getLow() - 1, feature.getHigh()};
        return coord;
    }

    private int[] convertToChadoCoordForProtein(AnnotatedFeatureI transcript) {
        int[] coord = new int[2];
        int strand = transcript.getStrand();
        int start = transcript.getTranslationStart();
        int end = transcript.getTranslationEnd();
        if (strand >= 0) {
            coord[0] = start - 1;
            if (coord[0] == -1) {
                coord[0] = transcript.getStart() - 1;
            }
            coord[1] = end;
            if (coord[1] == 0) {
                coord[1] = coord[0] + transcript.getPeptideSequence().getLength() * 3;
            }
        } else {
            coord[1] = start;
            if (coord[1] == -1) {
                coord[1] = transcript.getStart();
            }
            coord[0] = end - 1;
            if (coord[0] == -1) {
                coord[0] = coord[1] - transcript.getPeptideSequence().getLength() * 3;
            }
            if (coord[0] < 0) {
                coord[0] = transcript.getEnd() - 1;
            }
        }
        return coord;
    }

    private ChadoTransaction generateFeatureRelTransaction(SeqFeatureI feature, ChadoTransaction.Operation op) {
        if (feature.getParent() == null) {
            throw new IllegalArgumentException("ChadoTransactionTransformer.generateFeatureRelTransaction(): no object feature for feature_relation!");
        }
        return this.generateFeatureRelTransaction(feature, feature.getParent(), op);
    }

    private ChadoTransaction generateFeatureRelTransaction(SeqFeatureI feature, SeqFeatureI parent, ChadoTransaction.Operation op) {
        return this.generateFeatureRelTransaction(feature, feature.getId(), parent, op);
    }

    private ChadoTransaction generateFeatureRelTransaction(SeqFeatureI feat, String subjectId, SeqFeatureI parent, ChadoTransaction.Operation op) {
        ChadoTransaction transaction = this.generateTnFromOperation(op);
        transaction.setTableName("feature_relationship");
        transaction.addProperty("object_id", parent.getId());
        transaction.addProperty("subject_id", subjectId);
        transaction.addProperty("type_id", "partof");
        return transaction;
    }

    private String getChadoType(SeqFeatureI feature) {
        if (feature instanceof ExonI) {
            return feature.getFeatureType();
        }
        if (feature instanceof Transcript) {
            AnnotatedFeature parent = (AnnotatedFeature)feature.getParent();
            if (parent.getFeatureType().equals("gene")) {
                return "mRNA";
            }
            return parent.getFeatureType();
        }
        if (feature instanceof AnnotatedFeature) {
            String type = feature.getFeatureType();
            ChadoTransactionTransformer.debugPrint("###getChadoType " + type + this.oneLevelAnnotTypes.contains(type));
            if (this.oneLevelAnnotTypes != null && this.oneLevelAnnotTypes.contains(type)) {
                return type;
            }
            return "gene";
        }
        return "Unknown Type";
    }

    private ChadoTransaction generateTnFromOperation(ChadoTransaction.Operation op) {
        ChadoTransaction transaction = null;
        if (op == ChadoTransaction.UPDATE) {
            transaction = new ChadoUpdateTransaction();
        } else {
            transaction = new ChadoTransaction();
            transaction.setOperation(op);
        }
        return transaction;
    }

    private boolean isExonShared(SeqFeatureI tst, int start, int end) {
        SeqFeatureI gene = tst.getRefFeature();
        Vector transcripts = gene.getFeatures();
        Transcript tmp = null;
        Iterator it = transcripts.iterator();
        while (it.hasNext()) {
            SeqFeatureI tmp1;
            tmp = (Transcript)it.next();
            if (tmp == tst || (tmp1 = tmp.getFeatureContaining(start)) == null || !tmp1.isExon() || tmp1.getStart() != start || tmp1.getEnd() != end) continue;
            return true;
        }
        return false;
    }

    private void addUserPubTransaction(List transformedTns) {
        if (this.userPubTransactionAdded) {
            return;
        }
        ChadoTransaction ct = this.createUserPubTransaction();
        transformedTns.add(ct);
        this.userPubTransactionAdded = true;
    }

    private ChadoTransaction createUserPubTransaction() {
        String user = UserName.getUserName();
        if (this.havePubLookup(user)) {
            return null;
        }
        if (user == null || user.trim().length() == 0) {
            return null;
        }
        ChadoTransaction ts = this.createPubLookup(user);
        this.pub_id = user;
        return ts;
    }

    private void addPubLookup(String uniquename, List transformedTns) {
        if (this.havePubLookup(uniquename)) {
            return;
        }
        ChadoTransaction ct = this.createPubLookup(uniquename);
        transformedTns.add(ct);
    }

    private ChadoTransaction createPubLookup(String uniquename) {
        ChadoTransaction ts = new ChadoTransaction();
        ts.setOperation(ChadoTransaction.FORCE);
        ts.setTableName("pub");
        ts.setID(uniquename);
        ts.addProperty("uniquename", uniquename);
        ts.addProperty("type_id", "curator");
        if (this.nameToPubLookupTns == null) {
            this.nameToPubLookupTns = new HashMap();
        }
        this.nameToPubLookupTns.put(uniquename, ts);
        return ts;
    }

    private boolean havePubLookup(String uniquename) {
        return this.nameToPubLookupTns != null && this.nameToPubLookupTns.containsKey(uniquename);
    }

    public ChadoTransaction createSrcFeatureIDTransaction(String mapID, String mapType) {
        ChadoTransaction ts = new ChadoTransaction();
        ts.setOperation(ChadoTransaction.LOOKUP);
        ts.setTableName("feature");
        ts.setID("genomicSequence");
        ts.addProperty("uniquename", mapID);
        ts.addProperty("organism_id", "organism");
        ts.addProperty("type_id", mapType);
        return ts;
    }

    public void setOneLevelAnnotTypes(List features) {
        this.oneLevelAnnotTypes = features;
    }

    public void setThreeLevelAnnotTypes(List features) {
        this.threeLevelAnnotTypes = features;
    }

    private static void debugPrint(String m) {
        if (!Config.DEBUG) {
            return;
        }
        System.out.println("DEBUG: " + m);
    }

    private class FeatLocException
    extends TransactionTransformException {
        private FeatLocException(String m) {
            super(m);
        }
    }
}

