/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.chado;

import apollo.dataadapter.ApolloAdapterException;
import apollo.dataadapter.chado.ChadoAdapter;
import apollo.dataadapter.chado.SeqType;
import apollo.dataadapter.chado.jdbc.ChadoInstance;
import apollo.dataadapter.chado.jdbc.JdbcChadoAdapter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class ChadoDatabase {
    protected String name;
    protected String adapterClassName;
    protected String jdbcUrl;
    protected String chadoDb;
    protected String organismLike;
    private String login;
    private String password = null;
    private String styleName;
    private String topLevelFeatType;
    private List chromosomes;
    private ChadoInstance chadoInstance;
    private boolean isDefaultDatabase = false;

    public ChadoDatabase() {
    }

    public ChadoDatabase(String name, String adapterClassName, String jdbcUrl, String chadoDb, String login, String organismLike) {
        this.name = name;
        this.adapterClassName = adapterClassName;
        this.jdbcUrl = jdbcUrl;
        this.chadoDb = chadoDb;
        this.login = login;
        this.organismLike = organismLike;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAdapterClassName() {
        return this.adapterClassName;
    }

    public void setAdapterClassName(String clsName) {
        this.adapterClassName = clsName;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public void setJdbcUrl(String url) {
        this.jdbcUrl = url;
    }

    public String getChadoDb() {
        return this.chadoDb;
    }

    public void setChadoDb(String dbName) {
        this.chadoDb = dbName;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String dbUser) {
        this.login = dbUser;
    }

    boolean hasLogin() {
        return this.login != null;
    }

    void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public String getOrganismLike() {
        return this.organismLike;
    }

    public void setChadoInstance(ChadoInstance chadoInstance) {
        this.chadoInstance = chadoInstance;
    }

    public ChadoInstance getChadoInstance() {
        return this.chadoInstance;
    }

    public void setStyleFileName(String fileName) {
        this.styleName = fileName;
    }

    public String getStyleFileName() {
        return this.styleName;
    }

    List getLocationTopLevelSeqIds(String typeName) {
        SeqType st = this.getChadoInstance().getSeqType(typeName);
        if (st == null) {
            return new ArrayList(0);
        }
        return st.getLocationTopLevelSeqIds(this);
    }

    void setIsDefaultDatabase(boolean isDefault) {
        this.isDefaultDatabase = isDefault;
    }

    boolean isDefaultDatabase() {
        return this.isDefaultDatabase;
    }

    JdbcChadoAdapter getJdbcChadoAdapter() throws ApolloAdapterException {
        Class<?> dc = null;
        try {
            dc = Class.forName(this.adapterClassName);
        }
        catch (ClassNotFoundException cnfe) {
            throw new ApolloAdapterException("Unable to find Chado driver class " + this.adapterClassName);
        }
        try {
            JdbcChadoAdapter chadoAdapter = (JdbcChadoAdapter)dc.newInstance();
            chadoAdapter.initWithException(this.jdbcUrl, this.chadoDb, this.login, this.password, ChadoAdapter.DEBUG, this.organismLike);
            chadoAdapter.setChadoInstance(this.chadoInstance);
            return chadoAdapter;
        }
        catch (IllegalAccessException iae) {
            this.connectError(iae);
        }
        catch (InstantiationException ie) {
            this.connectError(ie);
        }
        catch (SQLException se) {
            this.connectError(se);
        }
        return null;
    }

    private void connectError(Exception e) throws ApolloAdapterException {
        if (this.debug()) {
            System.err.println("ChadoAdapter.getJdbcChadoAdapter(): " + e);
            e.printStackTrace();
        }
        throw new ApolloAdapterException("cant connect to database");
    }

    private boolean debug() {
        return ChadoAdapter.DEBUG;
    }
}

