/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.chado;

import apollo.config.Config;
import apollo.config.Style;
import apollo.dataadapter.AbstractApolloAdapter;
import apollo.dataadapter.ApolloAdapterException;
import apollo.dataadapter.ApolloDataAdapterI;
import apollo.dataadapter.DataInput;
import apollo.dataadapter.NotImplementedException;
import apollo.dataadapter.chado.ChadoAdapterGUI;
import apollo.dataadapter.chado.ChadoDatabase;
import apollo.dataadapter.chado.ChadoTransactionTransformer;
import apollo.dataadapter.chado.XmlConfigFileParser;
import apollo.dataadapter.chado.jdbc.ChadoInstance;
import apollo.dataadapter.chado.jdbc.JDBCTransactionWriter;
import apollo.dataadapter.chado.jdbc.JdbcChadoAdapter;
import apollo.datamodel.CurationSet;
import apollo.datamodel.DbXref;
import apollo.datamodel.SequenceI;
import java.util.Properties;
import java.util.Vector;
import org.bdgp.io.DataAdapterUI;
import org.bdgp.io.IOOperation;
import org.bdgp.util.ProgressEvent;

public class ChadoAdapter
extends AbstractApolloAdapter {
    public static String DRIVER_CLASS = "DRIVER_CLASS";
    public static String JDBC_URL = "JDBC_URL";
    public static String CHADO_DB = "CHADO_DB";
    public static String USERNAME = "USERNAME";
    public static String PASSWORD = "PASSWORD";
    protected Properties stateInfo = new Properties();
    private ChadoDatabase[] databases;
    private ChadoDatabase defaultDatabase;
    private ChadoDatabase activeDatabase;
    protected static boolean DEBUG;
    protected IOOperation[] SUPPORTED_OPS = new IOOperation[]{ApolloDataAdapterI.OP_READ_DATA, ApolloDataAdapterI.OP_WRITE_DATA};
    private ChadoAdapterGUI chadoAdapterGUI = null;

    public ChadoAdapter() {
        DEBUG = Config.DEBUG;
        this.setName("Chado database");
        XmlConfigFileParser parser = new XmlConfigFileParser();
        ChadoDatabase[] databases = parser.readConfigFile();
        this.setDatabases(databases);
    }

    private void setDatabases(ChadoDatabase[] databases) {
        this.databases = databases;
        for (int i = 0; i < databases.length; ++i) {
            if (!databases[i].isDefaultDatabase()) continue;
            this.setDefaultDatabase(databases[i]);
            return;
        }
    }

    public boolean hasLinkData() {
        return true;
    }

    public Properties getStateInformation() {
        return this.stateInfo == null ? null : (Properties)this.stateInfo.clone();
    }

    public void setStateInformation(Properties p) {
        this.stateInfo = p;
    }

    public Style getStyle() {
        String styleFileName = null;
        if (this.getActiveDatabase() != null) {
            styleFileName = this.getActiveDatabase().getStyleFileName();
        }
        this.style = styleFileName == null ? this.getDefaultStyle() : Config.createStyle(styleFileName);
        return this.style;
    }

    public CurationSet getCurationSet() throws ApolloAdapterException {
        this.clearOldData();
        DataInput dataInput = this.getDataInput();
        if (DEBUG) {
            System.out.println("CA act db " + this.getActiveDatabase() + " instance " + this.getActiveDatabase().getChadoInstance());
        }
        this.getActiveDatabase().getChadoInstance().checkForLocation(dataInput);
        String soType = dataInput.getSoType();
        if (soType == null) {
            throw new ApolloAdapterException("failed to get seq type from input");
        }
        String seqId = dataInput.getSeqId();
        JdbcChadoAdapter jdbcAdap = this.getActiveDatabase().getJdbcChadoAdapter();
        jdbcAdap.setPropertyScheme(this.getStyle().getPropertyScheme());
        this.fireProgressEvent(new ProgressEvent((Object)this, new Double(50.0), "Connecting to chado database"));
        jdbcAdap.validateConnectionAndSequence(soType, seqId);
        this.fireProgressEvent(new ProgressEvent((Object)this, new Double(100.0), "Connecting to chado database"));
        CurationSet cset = null;
        cset = dataInput.isRegion() ? jdbcAdap.getCurationSetInRange(this, soType, dataInput.getRegion()) : jdbcAdap.getCurationSet(this, soType, seqId);
        return cset;
    }

    public void commitChanges(CurationSet curation) throws ApolloAdapterException {
        curation.getTransactionManager().coalesce();
        JDBCTransactionWriter processor = new JDBCTransactionWriter(this.getActiveDatabase());
        ChadoInstance chadoInstance = this.getActiveDatabase().getChadoInstance();
        ChadoTransactionTransformer transformer = new ChadoTransactionTransformer();
        if (chadoInstance == null) {
            if (DEBUG) {
                System.out.println("No chado instance to get 1,3 level annots from???");
            }
        } else {
            transformer.setChadoInstance(chadoInstance);
        }
        processor.setTransformer(transformer);
        processor.setMapID(curation.getChromosome());
        if (chadoInstance != null) {
            processor.setMapType(chadoInstance.getTopLevelFeatType());
        }
        try {
            processor.commitTransactions(curation.getTransactionManager());
            curation.getTransactionManager().emptyTransactions();
        }
        catch (Exception e) {
            throw new ApolloAdapterException(e);
        }
    }

    public Boolean addToCurationSet() throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    public SequenceI getSequence(String id) throws ApolloAdapterException {
        System.err.println(this.getClass() + ": getSequence id=" + id);
        throw new NotImplementedException();
    }

    public SequenceI getSequence(DbXref dbxref) throws ApolloAdapterException {
        System.err.println(this.getClass() + ": getSequence dbxref=" + dbxref);
        throw new NotImplementedException();
    }

    public SequenceI getSequence(DbXref dbxref, int start, int end) throws ApolloAdapterException {
        System.err.println(this.getClass() + ": getSequence dbxref=" + dbxref + " start=" + start + " end=" + end);
        throw new NotImplementedException();
    }

    public Vector getSequences(DbXref[] dbxref) throws ApolloAdapterException {
        System.err.println(this.getClass() + ": getSequence dbxrefs=" + dbxref);
        throw new NotImplementedException();
    }

    public Vector getSequences(DbXref[] dbxref, int[] start, int[] end) throws ApolloAdapterException {
        System.err.println(this.getClass() + ": getSequence dbxrefs=" + dbxref + " starts=" + start + " ends=" + end);
        throw new NotImplementedException();
    }

    public String getRawAnalysisResults(String id) throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    public String getType() {
        return "Chado Adapter";
    }

    public IOOperation[] getSupportedOperations() {
        return this.SUPPORTED_OPS;
    }

    public void init() {
    }

    public DataAdapterUI getUI(IOOperation op) {
        if (this.chadoAdapterGUI == null) {
            this.chadoAdapterGUI = new ChadoAdapterGUI(op, this.databases);
        } else {
            this.chadoAdapterGUI.setOperation(op);
        }
        return this.chadoAdapterGUI;
    }

    protected void getSequenceList(String featType, Vector uniquenames, Vector descriptions) throws ApolloAdapterException {
        JdbcChadoAdapter chadoAdapter = this.getActiveDatabase().getJdbcChadoAdapter();
        chadoAdapter.getAllChadoSequencesByType(featType, uniquenames, descriptions);
    }

    void setDefaultDatabase(ChadoDatabase defaultDatabase) {
        this.defaultDatabase = defaultDatabase;
    }

    private ChadoDatabase getDefaultDatabase() {
        return this.defaultDatabase;
    }

    void setActiveDatabase(ChadoDatabase activeDatabase) {
        this.activeDatabase = activeDatabase;
    }

    private ChadoDatabase getActiveDatabase() {
        if (this.activeDatabase == null) {
            return this.defaultDatabase;
        }
        return this.activeDatabase;
    }

    public void setDbPassForDefaultDb(String pass) {
        this.getDefaultDatabase().setPassword(pass);
    }

    private ChadoDatabase getDatabaseByName(String chadoDb) throws Exception {
        ChadoDatabase ch = null;
        for (int i = 0; i < this.databases.length; ++i) {
            if (!this.databases[i].chadoDb.equals(chadoDb)) continue;
            ch = this.databases[i];
        }
        if (ch == null) {
            throw new Exception("Unable to find the cahdo database named : " + chadoDb);
        }
        return ch;
    }

    public void setDbPassForDb(String chadoDb, String pass) throws Exception {
        ChadoDatabase ch = this.getDatabaseByName(chadoDb);
        ch.setPassword(pass);
    }

    public void setDbPassAndActiveForDb(String chadoDb, String pass) throws Exception {
        ChadoDatabase ch = this.getDatabaseByName(chadoDb);
        ch.setPassword(pass);
        this.setActiveDatabase(ch);
    }

    JdbcChadoAdapter getJdbcAdapter() throws ApolloAdapterException {
        return this.getActiveDatabase().getJdbcChadoAdapter();
    }
}

