/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.analysis;

import apollo.analysis.filter.AnalysisInput;
import apollo.dataadapter.analysis.GeneFinderParser;
import apollo.datamodel.CurationSet;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.SeqFeatureI;
import java.io.InputStream;
import java.util.StringTokenizer;

public class FgeneshParser
extends GeneFinderParser {
    private String analysis_date = null;
    private int translation_start = 0;

    public String load(CurationSet curation, boolean new_curation, InputStream data_stream, AnalysisInput input) {
        this.initLoad(curation, new_curation, data_stream, input);
        if (this.parsed) {
            if (this.analysis_date != null) {
                this.forward_analysis.addProperty("date", this.analysis_date);
                this.reverse_analysis.addProperty("date", this.analysis_date);
            }
            try {
                this.parsed = this.grabGenes(curation, this.forward_analysis, this.reverse_analysis);
                this.data.close();
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
                ex.printStackTrace();
                this.parsed = false;
            }
        }
        return this.parsed ? this.getAnalysisType() : null;
    }

    protected boolean isCommentary() {
        if (this.line.indexOf("CDS") < 0) {
            this.comment = this.line;
            return true;
        }
        this.comment = "";
        return false;
    }

    public boolean recognizedInput() {
        int tries = 0;
        try {
            this.readLine();
            while (this.line != null && !this.line.equals("") && !this.parsed && tries < 10) {
                int index1 = this.line.indexOf("FGENESH");
                int index2 = index1 >= 0 ? this.line.indexOf(32, index1) : -1;
                boolean bl = this.parsed = index1 >= 0 && index2 > 0;
                if (!this.parsed) {
                    this.readLine();
                    ++tries;
                    continue;
                }
                this.program = this.line.substring(index1, index2).toLowerCase().trim();
                index1 = index2 + 1;
                if (index1 < this.line.length()) {
                    index2 = this.line.indexOf(32, index1);
                    this.version = index2 > 0 ? this.line.substring(index1, index2) : this.line.substring(index1);
                }
                this.readLine();
                this.line = this.line.trim();
                String header = "";
                int length = 50000000;
                while (this.line != null && !this.line.equals("")) {
                    String val;
                    index1 = this.line.indexOf(58) + 1;
                    String string = val = index1 > 0 && index1 < this.line.length() ? this.line.substring(index1).trim() : null;
                    if (this.line.startsWith("Time")) {
                        this.analysis_date = val;
                    } else if (this.line.startsWith("Seq name")) {
                        header = val;
                    } else if (this.line.startsWith("Length of sequence")) {
                        length = Integer.parseInt(val);
                    } else {
                        System.out.println("Ignoring " + this.line);
                    }
                    this.readLine();
                    this.line = this.line.trim();
                }
                if (this.curation.getRefSequence() != null) continue;
                this.curation.setRefSequence(this.initSequence(this.curation, header, length));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.parsed;
    }

    protected boolean parseLine() {
        this.low = 0;
        this.high = 0;
        this.score = 0.0;
        this.strand = 0;
        this.gene_id = "";
        try {
            if (this.line != null) {
                this.line = this.line.trim();
                int index1 = this.line.indexOf("CDS");
                String gene_str = this.line.substring(0, index1);
                StringTokenizer tokens = new StringTokenizer(gene_str);
                this.gene_id = this.parseToken(tokens, "gene_id");
                String strand_str = this.parseToken(tokens, "strand_str");
                this.parsed &= strand_str.equals("+") || strand_str.equals("-") || strand_str.equals(".");
                this.strand = this.parsed && (strand_str.equals("+") || strand_str.equals(".")) ? 1 : -1;
                int index2 = this.line.indexOf(32, index1);
                String loc_str = this.line.substring(index2).trim();
                tokens = new StringTokenizer(loc_str);
                this.low = this.parseInteger(tokens, "low");
                this.high = this.parseInteger(tokens, "high");
                if (!this.parsed) {
                    this.parsed = true;
                    this.high = this.parseInteger(tokens, "high");
                }
                this.score = this.parseDouble(tokens, "score_str");
                if (this.line.indexOf("CDSf") > 0) {
                    this.translation_start = this.parseInteger(tokens, "TSS");
                    if (this.strand == -1) {
                        this.translation_start = this.parseInteger(tokens, "TSS");
                        if (!this.parsed) {
                            this.parsed = true;
                            this.translation_start = this.parseInteger(tokens, "TSS");
                        }
                    }
                    if (this.strand == 1 && this.translation_start == this.low || this.strand == -1 && this.translation_start == this.high) {
                        this.translation_start = 0;
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error parsing line " + this.line);
            e.printStackTrace();
            this.parsed = false;
        }
        return this.parsed;
    }

    protected boolean grabGenes(CurationSet curation, FeatureSetI forward_analysis, FeatureSetI reverse_analysis) {
        SeqFeatureI gene = null;
        SeqFeatureI transcript = null;
        try {
            while (this.line != null) {
                if (!this.isCommentary()) {
                    this.parseLine();
                    if (gene != null && !gene.getId().equals(this.gene_id)) {
                        transcript.setScore(transcript.getScore() / (double)transcript.size());
                        if (this.translation_start > 0) {
                            transcript.setTranslationStart(this.translation_start, true);
                        }
                        gene.addFeature(transcript);
                        this.addGene((FeatureSetI)gene, forward_analysis, reverse_analysis);
                        gene = null;
                        transcript = null;
                    }
                    if (gene == null) {
                        gene = this.initSet(this.gene_id, this.strand);
                    }
                    if (transcript == null) {
                        transcript = this.initSet(this.gene_id, this.strand);
                        this.translation_start = 0;
                    }
                    SeqFeatureI exon = this.initFeature();
                    exon.setScore(this.score);
                    transcript.setScore(transcript.getScore() + exon.getScore());
                    exon.setStrand(this.strand);
                    exon.setLow(this.low);
                    exon.setHigh(this.high);
                    transcript.addFeature(exon);
                }
                this.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
            this.parsed = false;
        }
        if (transcript != null) {
            gene.addFeature(transcript);
        }
        if (gene != null) {
            this.addGene((FeatureSetI)transcript, forward_analysis, reverse_analysis);
        }
        return this.parsed;
    }
}

