/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.analysis;

import apollo.analysis.filter.AnalysisFilterI;
import apollo.analysis.filter.AnalysisInput;
import apollo.config.Config;
import apollo.config.FeatureProperty;
import apollo.config.PropertyScheme;
import apollo.config.TierProperty;
import apollo.dataadapter.AbstractApolloAdapter;
import apollo.dataadapter.ApolloAdapterException;
import apollo.dataadapter.ApolloDataAdapterI;
import apollo.dataadapter.DataInputType;
import apollo.dataadapter.analysis.AnalysisAdapterGUI;
import apollo.dataadapter.analysis.AnalysisParserI;
import apollo.datamodel.CurationSet;
import apollo.datamodel.FeatureSet;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.SequenceI;
import apollo.datamodel.StrandedFeatureSet;
import apollo.seq.io.FastaFile;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.Vector;
import org.bdgp.io.DataAdapterUI;
import org.bdgp.io.IOOperation;

public class AnalysisAdapter
extends AbstractApolloAdapter {
    private static boolean DEBUG = true;
    private AnalysisParserI parser;
    private AnalysisFilterI filter;
    private AnalysisInput analysis_input;
    SequenceI curated_seq = null;
    IOOperation[] supportedOperations = new IOOperation[]{ApolloDataAdapterI.OP_READ_DATA, ApolloDataAdapterI.OP_APPEND_DATA};

    public AnalysisAdapter() {
        this.setName("Computational analysis results");
    }

    public void init() {
    }

    public String getType() {
        return "Computational analysis results (filename or URL)";
    }

    public IOOperation[] getSupportedOperations() {
        return this.supportedOperations;
    }

    public DataAdapterUI getUI(IOOperation op) {
        if (!super.operationIsSupported(op)) {
            return null;
        }
        Object ui = super.getCachedUI(op);
        if (ui == null) {
            ui = new AnalysisAdapterGUI(op, this.curation_set);
            super.cacheUI(op, (DataAdapterUI)ui);
        }
        return ui;
    }

    public Properties getStateInformation() {
        Properties props = new Properties();
        props.put("inputType", this.getInputType().toString());
        props.put("input", this.getInput());
        return props;
    }

    public void setStateInformation(Properties props) {
        try {
            this.setInputType(DataInputType.stringToType(props.getProperty("inputType")));
        }
        catch (DataInputType.UnknownTypeException e) {
            System.out.println(e.getMessage() + " Can not set analysis state info");
        }
        this.setInput(props.getProperty("input"));
    }

    public void setAnalysisInput(AnalysisInput input) {
        this.analysis_input = input;
    }

    public void setParser(AnalysisParserI parser) {
        this.parser = parser;
    }

    public void setFilter(AnalysisFilterI filter) {
        this.filter = filter;
    }

    public void setRegion(String seq_file) throws ApolloAdapterException {
        if (seq_file != null) {
            try {
                FastaFile ff = new FastaFile(seq_file, "File");
                this.setRegion((SequenceI)ff.getSeqs().elementAt(0));
            }
            catch (IOException e) {
                System.out.println("IOException caught reading sequence file " + seq_file + " " + e);
            }
        }
    }

    public void setRegion(SequenceI seq) throws ApolloAdapterException {
        if (seq != null) {
            this.curated_seq = seq;
            this.region = seq.getName();
        }
    }

    public CurationSet getCurationSet() throws ApolloAdapterException {
        CurationSet curation = new CurationSet();
        if (this.curated_seq != null) {
            curation.setRefSequence(this.curated_seq);
            System.out.println("Current curated_seq is " + this.curated_seq.getName() + " (" + this.curated_seq.getLength() + " bases)");
        }
        curation.setAnnots(new StrandedFeatureSet((FeatureSetI)new FeatureSet(), new FeatureSet()));
        try {
            InputStream analysis_stream = this.getInputStream(this.getInputType(), this.getInput());
            String analysis_type = this.parser.load(curation, true, analysis_stream, this.analysis_input);
            if (analysis_type != null) {
                super.clearOldData();
                this.findOrCreateTier(analysis_type);
                if (this.filter != null) {
                    this.filter.cleanUp(curation, analysis_type, this.analysis_input);
                }
            }
            System.gc();
        }
        catch (ApolloAdapterException dae) {
            throw new ApolloAdapterException(dae.getMessage());
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
            throw new ApolloAdapterException(ex2.getMessage());
        }
        return curation;
    }

    public Boolean addToCurationSet() throws ApolloAdapterException {
        boolean okay = false;
        try {
            InputStream analysis_stream = this.getInputStream(this.getInputType(), this.getInput());
            String analysis_type = this.parser.load(this.curation_set, false, analysis_stream, this.analysis_input);
            if (analysis_type != null) {
                this.findOrCreateTier(analysis_type);
                if (this.filter != null) {
                    this.filter.cleanUp(this.curation_set, analysis_type, this.analysis_input);
                }
                okay = true;
            }
        }
        catch (ApolloAdapterException dae) {
            throw new ApolloAdapterException(dae.getMessage());
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
            throw new ApolloAdapterException(ex2.getMessage());
        }
        return new Boolean(okay);
    }

    private void findOrCreateTier(String analysis_type) {
        PropertyScheme scheme = Config.getPropertyScheme();
        String tier = this.analysis_input.getTier();
        String type = this.analysis_input.getType();
        TierProperty tp = scheme.getTierProperty(tier, false);
        if (tp == null) {
            System.out.println("Creating new tier " + tier + " and type " + type);
            int max_rows = this.analysis_input.getMaxCover();
            if (max_rows < 0) {
                max_rows = 10;
            }
            tp = new TierProperty(tier, true, true, true, max_rows, false);
            scheme.addTierType(tp);
            Vector<String> types = new Vector<String>();
            types.addElement(analysis_type);
            FeatureProperty fp = new FeatureProperty(tp, type, types);
            fp = scheme.getFeatureProperty(analysis_type);
            tp = scheme.getTierProperty(tier);
        } else {
            FeatureProperty fp = tp.getFeatureProperty(type);
            if (fp == null) {
                Vector<String> types = new Vector<String>();
                types.addElement(analysis_type);
                fp = new FeatureProperty(tp, type, types);
            } else if (tp.featureForAnalysisType(analysis_type) == null) {
                fp.addAnalysisType(analysis_type);
            }
        }
        tp.setVisible(true);
    }

    private InputStream getInputStream(DataInputType type, String input) throws ApolloAdapterException {
        InputStream stream = null;
        if (type == DataInputType.FILE) {
            stream = this.getStreamFromFile(input);
        } else if (type == DataInputType.URL) {
            stream = this.getStreamFromUrl(this.getUrlFromString(input), "URL " + input + " not found");
        }
        return stream;
    }

    private InputStream getStreamFromUrl(URL url, String notFoundMessage) throws ApolloAdapterException {
        InputStream stream = null;
        if (url == null) {
            String message = "Couldn't find url for " + this.getInput();
            System.err.println(message);
            throw new ApolloAdapterException(message);
        }
        if (url != null) {
            try {
                System.err.println("Trying to open url " + url);
                stream = url.openStream();
                if (DEBUG) {
                    System.err.println("Succesfully opened url " + url);
                }
            }
            catch (IOException e) {
                System.err.println(notFoundMessage);
                stream = null;
                throw new ApolloAdapterException(notFoundMessage);
            }
        }
        return stream;
    }

    private InputStream getStreamFromFile(String filename) throws ApolloAdapterException {
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(filename);
        }
        catch (Exception e) {
            stream = null;
            String rootdir = System.getProperty("APOLLO_ROOT");
            if (!(filename.startsWith("/") || filename.startsWith("\\") || filename.startsWith(rootdir))) {
                String absolute = rootdir + "/" + filename;
                try {
                    InputStream newstream = this.getStreamFromFile(absolute);
                    return newstream;
                }
                catch (ApolloAdapterException e2) {
                    absolute = rootdir + "/data/" + filename;
                    try {
                        InputStream newstream = this.getStreamFromFile(absolute);
                        return newstream;
                    }
                    catch (ApolloAdapterException e3) {
                        throw new ApolloAdapterException("Error: could not open file " + filename + " for reading.");
                    }
                }
            }
            throw new ApolloAdapterException("Error: could not open " + this.getInput() + " for reading.");
        }
        return stream;
    }

    private URL getUrlFromString(String urlString) {
        URL url;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException ex) {
            System.err.println("caught exception creating URL " + urlString);
            System.out.println(ex.getMessage());
            ex.printStackTrace();
            return null;
        }
        return url;
    }
}

