/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.DataInputStream;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class URLDiagnosticTool
extends JDialog {
    private JTextField queryField;
    private JTextArea responseField;
    private JButton executeButton;
    private JButton returnButton;
    private ActionListener executeListener = new ActionListener(){

        public void actionPerformed(ActionEvent event) {
            System.out.println("STARTING on" + URLDiagnosticTool.this.getQueryField().getText());
            try {
                URL url = new URL(URLDiagnosticTool.this.getQueryField().getText());
                URLDiagnosticTool.this.getResponseField().setText("opening URL");
                DataInputStream inputStream = new DataInputStream(url.openStream());
                URLDiagnosticTool.this.getResponseField().setText("collating response");
                String line = inputStream.readLine();
                String totalString = "";
                while (line != null) {
                    totalString = totalString + line + "\n";
                    line = inputStream.readLine();
                }
                System.out.println("FINISHING");
                URLDiagnosticTool.this.getResponseField().setText(totalString);
                System.out.println("FINISHED");
            }
            catch (Exception exception) {
                URLDiagnosticTool.this.getResponseField().setText(exception.getMessage() + "\n");
            }
        }
    };
    private ActionListener returnListener = new ActionListener(){

        public void actionPerformed(ActionEvent event) {
            URLDiagnosticTool.this.dispose();
        }
    };

    public URLDiagnosticTool(String query) {
        super((Frame)null, "URL Diagnostic", true);
        this.setup(query);
    }

    public URLDiagnosticTool(String query, JDialog parent) {
        super(parent, "URL Diagnostic", true);
        this.setup(query);
    }

    private void setup(String query) {
        this.queryField = new JTextField(30);
        this.queryField.setText(query);
        this.executeButton = new JButton("execute query");
        this.executeButton.addActionListener(this.executeListener);
        this.responseField = new JTextArea(20, 30);
        JScrollPane responsePane = new JScrollPane(this.responseField);
        this.responseField.setText("Waiting for response");
        this.returnButton = new JButton("return");
        this.returnButton.addActionListener(this.returnListener);
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        this.getContentPane().add((Component)this.queryField, constraints);
        ++constraints.gridy;
        this.getContentPane().add((Component)this.executeButton, constraints);
        ++constraints.gridy;
        this.getContentPane().add((Component)responsePane, constraints);
        ++constraints.gridy;
        this.getContentPane().add((Component)this.returnButton, constraints);
        this.addWindowListener(new MyWindowListener());
        this.pack();
        this.show();
    }

    public JTextField getQueryField() {
        return this.queryField;
    }

    public void setQueryField(JTextField queryField) {
        this.queryField = queryField;
    }

    public JTextArea getResponseField() {
        return this.responseField;
    }

    public void setResponseField(JTextArea responseField) {
        this.responseField = responseField;
    }

    public JButton getExecuteButton() {
        return this.executeButton;
    }

    public void setExecuteButton(JButton executeButton) {
        this.executeButton = executeButton;
    }

    public JButton getReturnButton() {
        return this.returnButton;
    }

    public void setReturnButton(JButton returnButton) {
        this.returnButton = returnButton;
    }

    public static void main(String[] args) {
        JDialog firstDialog = new JDialog((Frame)null, true);
        firstDialog.getContentPane().setLayout(new BorderLayout());
        firstDialog.getContentPane().add((Component)new JLabel("Hello"), "Center");
        JButton myButton = new JButton("Launch");
        myButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.out.println("Before launching diagnostic");
                URLDiagnosticTool tool = new URLDiagnosticTool("http://www.google.com");
                System.out.println("After launching diagnostic");
            }
        });
        firstDialog.getContentPane().add((Component)myButton, "South");
        firstDialog.pack();
        firstDialog.show();
    }

    public class MyWindowListener
    extends WindowAdapter {
        public void windowClosed(WindowEvent e) {
            Window window = e.getWindow();
            window.dispose();
        }
    }
}

