/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter;

import apollo.dataadapter.ApolloAdapterException;
import apollo.dataadapter.ApolloDataAdapterI;
import apollo.datamodel.CurationSet;
import apollo.datamodel.Range;
import apollo.datamodel.RangeI;
import apollo.gui.ProxyDialog;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.bdgp.io.DataAdapter;
import org.bdgp.io.IOOperation;
import org.bdgp.swing.AbstractDataAdapterUI;

public class GbrowseAdapterGUI
extends AbstractDataAdapterUI {
    JComboBox chrStartEndList;
    JTextField chrTextBox;
    JTextField startTextBox;
    JTextField endTextBox;
    JLabel chrLabel;
    JLabel startLabel;
    JLabel endLabel;
    JLabel chrStartEndLabel;
    JPanel rangePanel;
    JButton proxyButton;
    ActionListener chrAction;
    Vector chrStartEndVector = new Vector();
    public static final int MAX_HISTORY_LENGTH = 5;
    protected DataAdapter driver;
    protected IOOperation op;
    private Properties props;

    public GbrowseAdapterGUI(IOOperation op) {
        this.op = op;
        this.chrTextBox = new JTextField();
        this.startTextBox = new JTextField();
        this.endTextBox = new JTextField();
        this.chrStartEndList = new JComboBox();
        this.chrLabel = new JLabel("Chr");
        this.startLabel = new JLabel("Start");
        this.endLabel = new JLabel("End");
        this.chrStartEndLabel = new JLabel("History");
        this.proxyButton = new JButton("Proxy settings");
        this.proxyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProxyDialog pd = new ProxyDialog(null);
                pd.setVisible(true);
            }
        });
        this.buildGUI();
        this.chrAction = new ChrStartEndListener();
        this.chrStartEndList.addActionListener(this.chrAction);
    }

    public static RangeI parseChrStartEndString(String str) {
        StringTokenizer tokenizer = new StringTokenizer(str);
        if (!tokenizer.nextToken().equals("Chr")) {
            System.out.println("Failed parsing location string " + str);
            return null;
        }
        String chr = tokenizer.nextToken();
        int start = Integer.parseInt(tokenizer.nextToken());
        int end = Integer.parseInt(tokenizer.nextToken());
        return new Range(chr, start, end);
    }

    public void setProperties(Properties in) {
        this.props = in;
        this.chrStartEndVector = new Vector();
        if (this.props.getProperty("chrStartEndItems") != null) {
            int items = Integer.parseInt(this.props.getProperty("chrStartEndItems"));
            for (int i = 0; i < items; ++i) {
                this.chrStartEndVector.addElement(this.props.getProperty("chrStartEndItem" + i));
            }
            this.chrStartEndList.removeActionListener(this.chrAction);
            this.chrStartEndList.setModel(new DefaultComboBoxModel(this.chrStartEndVector));
            this.chrStartEndList.addActionListener(this.chrAction);
        }
    }

    public Properties getProperties() {
        this.chrStartEndList.removeActionListener(this.chrAction);
        String selectedChrStartEnd = this.getSelectedChrStartEnd();
        this.chrStartEndVector.removeElement(selectedChrStartEnd);
        this.chrStartEndVector.insertElementAt(selectedChrStartEnd, 0);
        Properties out = new Properties();
        if (this.chrStartEndVector.size() > 5) {
            out.put("chrStartEndItems", "5");
        } else {
            out.put("chrStartEndItems", this.chrStartEndVector.size() + "");
        }
        for (int i = 0; i < this.chrStartEndVector.size() && i < 5; ++i) {
            out.put("chrStartEndItem" + i, (String)this.chrStartEndVector.elementAt(i));
        }
        this.chrStartEndList.addActionListener(this.chrAction);
        return out;
    }

    public void buildGUI() {
        this.setPreferredSize(new Dimension(450, 100));
        this.chrTextBox.setPreferredSize(new Dimension(150, 10));
        this.chrTextBox.setEditable(true);
        this.startTextBox.setPreferredSize(new Dimension(150, 10));
        this.startTextBox.setEditable(true);
        this.endTextBox.setPreferredSize(new Dimension(150, 10));
        this.endTextBox.setEditable(true);
        this.chrStartEndList.setPreferredSize(new Dimension(150, 20));
        this.chrStartEndList.setEditable(false);
        this.chrLabel.setPreferredSize(new Dimension(130, 12));
        this.startLabel.setPreferredSize(new Dimension(130, 12));
        this.endLabel.setPreferredSize(new Dimension(130, 12));
        this.chrStartEndLabel.setPreferredSize(new Dimension(130, 12));
        Box chrBox = new Box(0);
        chrBox.add(this.chrLabel);
        chrBox.add(this.chrTextBox);
        chrBox.add(Box.createHorizontalGlue());
        Box startBox = new Box(0);
        startBox.add(this.startLabel);
        startBox.add(this.startTextBox);
        startBox.add(Box.createHorizontalGlue());
        Box endBox = new Box(0);
        endBox.add(this.endLabel);
        endBox.add(this.endTextBox);
        endBox.add(Box.createHorizontalGlue());
        Box chrStartEndBox = new Box(0);
        chrStartEndBox.add(this.chrStartEndLabel);
        chrStartEndBox.add(this.chrStartEndList);
        chrStartEndBox.add(Box.createHorizontalGlue());
        Box proxyBox = new Box(0);
        proxyBox.add(Box.createHorizontalGlue());
        proxyBox.add(this.proxyButton);
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.add(chrBox);
        this.add(startBox);
        this.add(endBox);
        this.add(chrStartEndBox);
        this.add(proxyBox);
    }

    public void setDataAdapter(DataAdapter driver) {
        this.driver = driver;
    }

    public String getSelectedChrStartEnd() {
        return new String("Chr " + this.getSelectedChr() + " " + this.getSelectedStart() + " " + this.getSelectedEnd());
    }

    public String getSelectedChr() {
        String selectedChr = this.chrTextBox.getText();
        return selectedChr;
    }

    public String getSelectedStart() {
        String selectedStart = this.startTextBox.getText();
        return selectedStart;
    }

    public String getSelectedEnd() {
        String selectedEnd = this.endTextBox.getText();
        return selectedEnd;
    }

    private boolean areAllTextBoxesFilled() {
        return this.chrTextBox.getText() != null && this.startTextBox.getText() != null && this.endTextBox.getText() != null && !this.chrTextBox.getText().equals("") && !this.startTextBox.getText().equals("") && !this.endTextBox.getText().equals("");
    }

    public Object doOperation(Object values) throws ApolloAdapterException {
        if (this.op.equals((Object)ApolloDataAdapterI.OP_READ_DATA)) {
            CurationSet out = ((ApolloDataAdapterI)this.driver).getCurationSet();
            return out;
        }
        return null;
    }

    public class ChrStartEndListener
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            RangeI loc = GbrowseAdapterGUI.parseChrStartEndString((String)GbrowseAdapterGUI.this.chrStartEndList.getSelectedItem());
            if (loc != null) {
                GbrowseAdapterGUI.this.chrTextBox.setText(loc.getName());
                GbrowseAdapterGUI.this.startTextBox.setText(loc.getStart() + "");
                GbrowseAdapterGUI.this.endTextBox.setText(loc.getEnd() + "");
            }
        }
    }
}

