/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter;

import apollo.config.Style;
import apollo.dataadapter.DataInputType;
import apollo.dataadapter.GuiTabPanel;
import apollo.gui.GenericFileAdapterGUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;

public class FileTabPanel
extends GuiTabPanel {
    private Component parentComponent;

    public FileTabPanel(Component parentComponent, Color bkgnd) {
        super("File", "Filename or URL", bkgnd);
        this.parentComponent = parentComponent;
    }

    public DataInputType getInputType() {
        if (this.getCurrentInput().startsWith("http")) {
            return DataInputType.URL;
        }
        return DataInputType.FILE;
    }

    protected void buildGUI() {
        super.buildGUI();
        JButton browseButton = new JButton("Browse...");
        browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileTabPanel.this.browseFiles();
            }
        });
        this.getInnerPanel().add((Component)browseButton, this.getConstraints().nextColumn());
    }

    public void addCheckbox(JCheckBox checkbox) {
        this.getConstraints().nextRow();
        this.getInnerPanel().add((Component)checkbox, this.getConstraints().nextColumn());
    }

    private void browseFiles() {
        File browsedFile;
        File selectedFile = null;
        if (this.getCurrentInput() != null) {
            selectedFile = new File(this.getCurrentInput());
        }
        if ((browsedFile = GenericFileAdapterGUI.fileBrowser(selectedFile, this.parentComponent)) == null) {
            return;
        }
        this.comboBox.configureEditor(this.comboBox.getEditor(), browsedFile.toString());
    }

    protected boolean showDatabaseList() {
        return false;
    }

    protected Style getAdapterStyle() {
        return null;
    }
}

