/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter;

import apollo.dataadapter.AbstractApolloAdapter;
import apollo.dataadapter.ApolloAdapterException;
import apollo.dataadapter.ApolloDataAdapterI;
import apollo.dataadapter.DataInputType;
import apollo.dataadapter.DataListener;
import apollo.datamodel.DbXref;
import apollo.datamodel.Sequence;
import apollo.datamodel.SequenceI;
import java.util.Vector;
import org.bdgp.io.DataAdapterUI;
import org.bdgp.io.IOOperation;

public class DummySequenceAdapter
extends AbstractApolloAdapter {
    IOOperation[] supportedOperations = new IOOperation[]{ApolloDataAdapterI.OP_READ_SEQUENCE};

    public void init() {
    }

    public String getName() {
        return "Dummy Sequence Adapter";
    }

    public String getType() {
        return "Dummy Sequence Data";
    }

    public DataInputType getInputType() {
        return null;
    }

    public String getInput() {
        return null;
    }

    public IOOperation[] getSupportedOperations() {
        return this.supportedOperations;
    }

    public SequenceI getSequence(String id) throws ApolloAdapterException {
        return this.getSequence(new DbXref("dum", "dum", "dum"), 1, 2000);
    }

    public SequenceI getSequence(DbXref dbxref) throws ApolloAdapterException {
        return this.getSequence(dbxref, 1, 2000);
    }

    public Vector getSequences(DbXref[] dbxref) throws ApolloAdapterException {
        Vector<SequenceI> seqs = new Vector<SequenceI>();
        for (int i = 0; i < dbxref.length; ++i) {
            seqs.addElement(this.getSequence(dbxref[i]));
        }
        return seqs;
    }

    public SequenceI getSequence(DbXref dbxref, int start, int end) throws ApolloAdapterException {
        int len = end - start + 1;
        System.out.println("Getting sequence length " + len);
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < len) {
            int j;
            for (j = 0; j < 10 && i < len; ++j, ++i) {
                sb.append('T');
            }
            for (j = 0; j < 10 && i < len; ++j, ++i) {
                sb.append('A');
            }
        }
        Sequence seq = new Sequence(dbxref.getIdValue(), sb.toString());
        System.out.println("Got sequence " + seq);
        return seq;
    }

    public Vector getSequences(DbXref[] dbxref, int[] start, int[] end) throws ApolloAdapterException {
        Vector<SequenceI> seqs = new Vector<SequenceI>();
        for (int i = 0; i < dbxref.length; ++i) {
            seqs.addElement(this.getSequence(dbxref[i], start[i], end[i]));
        }
        return seqs;
    }

    public void setRegion(String extID) throws ApolloAdapterException {
    }

    public void addDataListener(DataListener d) {
    }

    public DataAdapterUI getUI(IOOperation op) {
        return null;
    }
}

