/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter;

import java.util.HashMap;
import java.util.Set;

public class DataInputType {
    private String typeString;
    private static HashMap stringToType = new HashMap(8);
    private String soType;
    public static DataInputType GENE = new DataInputType("gene");
    public static DataInputType MRNA = new DataInputType("mRNA");
    public static DataInputType CYTOLOGY = new DataInputType("cytology");
    public static DataInputType SCAFFOLD = new DataInputType("scaffold");
    public static DataInputType FILE = new DataInputType("file");
    public static DataInputType URL = new DataInputType("url");
    public static DataInputType SEQUENCE = new DataInputType("sequence");
    public static DataInputType BASEPAIR_RANGE = new DataInputType("base_pair_range");
    public static DataInputType CONTIG = new DataInputType("contig");
    public static DataInputType DIR = new DataInputType("directory");

    public static DataInputType getDataTypeForSoType(String soType) {
        if (soType == null) {
            return null;
        }
        DataInputType dataInputType = null;
        try {
            dataInputType = DataInputType.stringToType(soType);
            dataInputType.setSoType(soType);
            return dataInputType;
        }
        catch (UnknownTypeException unknownTypeException) {
            if (soType.equals("chromosome")) {
                dataInputType = BASEPAIR_RANGE;
            } else if (soType.equals("golden_path_region")) {
                dataInputType = SCAFFOLD;
            }
            dataInputType = new DataInputType(soType);
            dataInputType.setSoType(soType);
            return dataInputType;
        }
    }

    void setSoType(String soType) {
        this.soType = soType;
    }

    public String getSoType() {
        return this.soType;
    }

    private DataInputType(String typeString) {
        this.typeString = typeString;
        stringToType.put(typeString, this);
    }

    public String toString() {
        return this.typeString;
    }

    public static DataInputType stringToType(String s) throws UnknownTypeException {
        DataInputType d = (DataInputType)stringToType.get(s);
        if (d == null) {
            throw new UnknownTypeException(s);
        }
        return d;
    }

    public boolean isLocation() {
        return this == BASEPAIR_RANGE;
    }

    public static String[] getTypeStrings() {
        Set stringSet = stringToType.keySet();
        String[] s = new String[]{};
        return stringSet.toArray(s);
    }

    public static class UnknownTypeException
    extends Exception {
        private UnknownTypeException(String typeString) {
            super("Type " + typeString + " is not a known input type");
        }
    }
}

