/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;

public class CGI
implements Runnable {
    protected String server;
    protected int port = 80;
    protected String location;
    protected String data;
    protected String method = "GET";
    protected PrintStream statout;
    protected Hashtable variables;
    protected URLConnection connection;
    protected PrintStream out;
    protected DataInputStream in;
    protected int timeout = 5000;

    public CGI(String server, int port, String location, Hashtable variables, PrintStream statout, String method) {
        this.server = server;
        this.port = port;
        this.location = location;
        this.variables = variables;
        this.method = method;
        this.statout = statout;
    }

    public CGI(String server, int port, String location, Hashtable variables, PrintStream statout) {
        this(server, port, location, variables, statout, "GET");
    }

    public CGI(String server, int port, String location, PrintStream statout) {
        this(server, port, location, null, statout);
    }

    public CGI(String server, String location, PrintStream statout) {
        this(server, 80, null, statout);
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getServer() {
        return this.server;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public static boolean test(String server, int port, int timeout) {
        try {
            Socket socket = new Socket(server, port);
            socket.setSoTimeout(timeout);
        }
        catch (UnknownHostException e) {
            System.out.println(e);
            return false;
        }
        catch (SocketException e) {
            System.out.println("Socket Exception " + e);
            return false;
        }
        catch (InterruptedIOException e) {
            System.out.println("Read to server timed out " + e);
            return false;
        }
        catch (IOException e) {
            System.out.println("IOException " + e);
            return false;
        }
        return true;
    }

    public void run() {
        URL cgiServer = null;
        try {
            if (this.method.equals("POST")) {
                cgiServer = new URL("http://" + this.server + ":" + this.port + "/" + this.location);
                this.connection = cgiServer.openConnection();
                this.connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                this.connection.setDoOutput(true);
                this.out = new PrintStream(this.connection.getOutputStream());
                if (this.variables != null) {
                    this.out.print(this.getVariablesString());
                }
            } else {
                cgiServer = new URL("http://" + this.server + ":" + this.port + "/" + this.location + "?" + this.getVariablesString());
                for (int attempts = 0; attempts < 10; ++attempts) {
                    this.connection = cgiServer.openConnection();
                    this.connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                    if (this.connection instanceof HttpURLConnection) {
                        ((HttpURLConnection)this.connection).setRequestMethod("GET");
                        ((HttpURLConnection)this.connection).setInstanceFollowRedirects(false);
                    }
                    this.connection.setAllowUserInteraction(false);
                    this.connection.connect();
                    String redirectedTo = this.connection.getHeaderField("Location");
                    if (redirectedTo == null) break;
                    cgiServer = new URL(cgiServer, redirectedTo);
                }
            }
            this.in = new DataInputStream(this.connection.getInputStream());
        }
        catch (MalformedURLException ex) {
            System.out.println("CGI.run: URL = " + cgiServer + ".  Caught malformed URL exception " + ex);
        }
        catch (IOException ioex) {
            System.out.println("CGI.run: URL = " + cgiServer + ".  Caught io exception " + ioex);
        }
        catch (Exception ex) {
            System.out.println("CGI.run: URL = " + cgiServer + ".  Caught exception " + ex);
        }
    }

    private String getVariablesString() {
        StringBuffer buf = new StringBuffer();
        Enumeration en = this.variables.keys();
        String sep = "";
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            String value = (String)this.variables.get(name);
            buf.append(sep + name + "=" + URLEncoder.encode(value));
            sep = "&";
        }
        return buf.toString();
    }

    public void readInput(DataInputStream in) {
        String data = "";
        try {
            while ((data = in.readLine()) != null) {
                this.statout.println(data);
            }
        }
        catch (IOException ioex) {
            System.out.println("Exception " + ioex);
        }
    }

    public DataInputStream getInput() {
        return this.in;
    }

    public void close() {
        ((HttpURLConnection)this.connection).disconnect();
    }
}

