/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter;

import apollo.config.ApolloNameAdapterI;
import apollo.config.Config;
import apollo.config.Style;
import apollo.dataadapter.ApolloAdapterException;
import apollo.dataadapter.ApolloDataAdapterI;
import apollo.dataadapter.CurationState;
import apollo.dataadapter.DataInput;
import apollo.dataadapter.DataInputType;
import apollo.dataadapter.DataLoadEvent;
import apollo.dataadapter.DataLoadListener;
import apollo.dataadapter.NotImplementedException;
import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.CompositeDataHolder;
import apollo.datamodel.CurationSet;
import apollo.datamodel.DbXref;
import apollo.datamodel.GenomicRange;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.SequenceI;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.bdgp.io.AbstractDataAdapter;
import org.bdgp.io.DataAdapterException;
import org.bdgp.io.DataAdapterUI;
import org.bdgp.io.IOOperation;

public abstract class AbstractApolloAdapter
extends AbstractDataAdapter
implements ApolloDataAdapterI {
    private DataInput dataInput;
    private String database;
    protected String region;
    protected CurationSet curation_set;
    protected Style style;
    private boolean styleExplicitlySet = false;
    private DataLoadListener regionChangeListener;
    private CurationState curationState;
    private int curationNumber = 0;
    private String name = "Abstract Apollo Adapter";
    private HashMap opToUI = new HashMap(4);
    private String species = Config.getDefaultSingleSpeciesName();

    public void init() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getType() {
        return "";
    }

    public void setCurationNumber(int curationNumber) {
        this.curationNumber = curationNumber;
    }

    public void setCurationState(CurationState curationState) {
        this.curationState = curationState;
    }

    public CurationState getCurationState() {
        if (this.curationState == null) {
            this.curationState = new CurationState(this.curationNumber);
            this.curationState.setDataAdapter(this);
        }
        return this.curationState;
    }

    protected ApolloNameAdapterI getNameAdapter(AnnotatedFeatureI annot) {
        return this.getCurationState().getNameAdapter(annot);
    }

    public void setDataInput(DataInput dataInput) {
        this.dataInput = dataInput;
    }

    public DataInput getDataInput() {
        return this.dataInput;
    }

    protected String getFilename() {
        if (this.getDataInput() == null) {
            return null;
        }
        return this.getDataInput().getFilename();
    }

    public void setInputType(DataInputType type) {
        if (this.dataInput == null) {
            this.setDataInput(new DataInput(type));
        } else {
            this.getDataInput().setType(type);
        }
    }

    public DataInputType getInputType() {
        if (this.getDataInput() == null) {
            return null;
        }
        return this.getDataInput().getType();
    }

    public String getInput() {
        if (this.getDataInput() == null) {
            return null;
        }
        return this.getDataInput().getInputString();
    }

    public void setInput(String input) {
        if (Config.DEBUG) {
            System.out.println("AAA input " + input + " dataInput " + this.dataInput);
        }
        if (this.dataInput == null) {
            this.setDataInput(new DataInput(input));
        } else {
            this.getDataInput().setInputString(input);
        }
        if (Config.DEBUG) {
            System.out.println("AAA done with set input " + this.getDataInput().getInputString() + " dataInput " + this.dataInput);
        }
    }

    protected void clearOldData() throws ApolloAdapterException {
        this.notifyNewData();
        this.style = null;
        Style style = this.getStyle();
        Config.setStyle(style);
        System.out.println("Set style to " + style + "; style file source(s): " + style.getAllStyleFilesString());
        String tiers = style.getTiersFile();
        if (tiers == null) {
            String message = "\nFatal error: can't find Types (tiers) file!\nPlease fix the Types parameter in " + style.getFileName() + "\n(and if that looks ok, check that a style file is not trying to include itself)." + ".\nYou will then need to restart Apollo.";
            if (style.getFileName().indexOf("game.style") >= 0) {
                message = message + "\n\nYou seem to be using game.style as your primary style file.\nNote that game.style is an abstract style that does not include a Types\nfile setting.  You should be using fly.style or rice.style, each of which\ninherits from game.style";
            }
            throw new ApolloAdapterException(message);
        }
        System.out.println("Using tiers file " + tiers);
        if (Config.internalMode()) {
            System.out.println("Running in internal mode.\n");
        }
    }

    private void notifyNewData() {
        if (this.regionChangeListener == null) {
            return;
        }
        DataLoadEvent e = new DataLoadEvent((Object)this, 0);
        this.regionChangeListener.handleDataLoadEvent(e);
    }

    public boolean rollbackAnnotations(CompositeDataHolder cdh) {
        if (!this.isComposite()) {
            return this.rollbackAnnotations(cdh.getCurationSet(0));
        }
        return true;
    }

    protected boolean rollbackAnnotations(CurationSet curationSet) {
        return true;
    }

    public SequenceI getSequence(String id) throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    public SequenceI getSequence(DbXref dbxref) throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    public SequenceI getSequence(DbXref dbxref, int start, int end) throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    public Vector getSequences(DbXref[] dbxref) throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    public Vector getSequences(DbXref[] dbxref, int[] start, int[] end) throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    public String getRawAnalysisResults(String id) throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    public void setRegion(String region) throws ApolloAdapterException {
        this.region = region;
    }

    public void setCuration(CurationSet curation) throws ApolloAdapterException {
        this.curation_set = curation;
        this.opToUI = new HashMap(4);
    }

    public void commitChanges(CurationSet curation) throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    public void commitChanges(CompositeDataHolder cdh) throws ApolloAdapterException {
        if (!this.isComposite()) {
            this.commitChanges(cdh.getCurationSet(0));
        }
    }

    public void commitChanges(Object values) throws ApolloAdapterException {
        if (values instanceof CurationSet) {
            this.commitChanges((CurationSet)values);
        } else if (values instanceof CompositeDataHolder) {
            this.commitChanges((CompositeDataHolder)values);
        }
    }

    public void commitChanges(Object values, boolean saveAnnots, boolean saveResults) throws ApolloAdapterException {
        if (values instanceof CurationSet) {
            this.commitChanges((CurationSet)values, saveAnnots, saveResults);
        } else if (values instanceof CompositeDataHolder) {
            this.commitChanges((CompositeDataHolder)values, saveAnnots, saveResults);
        }
    }

    public void commitChanges(CurationSet curation, boolean saveAnnots, boolean saveResults) throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    public void commitChanges(CompositeDataHolder cdh, boolean saveAnnots, boolean saveResults) throws ApolloAdapterException {
        if (!this.isComposite()) {
            this.commitChanges(cdh.getCurationSet(0), saveAnnots, saveResults);
        }
    }

    public CurationSet getCurationSet() throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    public Properties getStateInformation() {
        throw new NotImplementedException();
    }

    public void setStateInformation(Properties p) {
        throw new NotImplementedException();
    }

    String getInputTypeString() {
        if (this.getInputType() != null) {
            return this.getInputType().toString();
        }
        return this.getStateInformation().getProperty("Input Type");
    }

    String getInputId() {
        return this.getStateInformation().getProperty("Input");
    }

    int getStart() {
        String startKey = "Segment_start";
        return Integer.parseInt(this.getStateInformation().getProperty(startKey));
    }

    public void setLocation(GenomicRange chromosomeLocation) {
        Properties props = this.getStateInformation();
        props.setProperty("Input Type", "chromosome");
        props.setProperty("Input", chromosomeLocation.getChromosome());
        props.setProperty("Segment_start", chromosomeLocation.getStart() + "");
        props.setProperty("Segment_stop", chromosomeLocation.getEnd() + "");
    }

    public void clearStateInformation() {
        throw new NotImplementedException("clearStateInformation must be implemented by the adapter class!");
    }

    public Boolean addToCurationSet() throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    protected boolean operationIsSupported(IOOperation op) {
        for (int i = 0; i < this.getSupportedOperations().length; ++i) {
            if (!op.equals((Object)this.getSupportedOperations()[i])) continue;
            return true;
        }
        return false;
    }

    public boolean canWriteData() {
        return this.operationIsSupported(ApolloDataAdapterI.OP_WRITE_DATA);
    }

    protected void cacheUI(IOOperation op, DataAdapterUI ui) {
        if (!this.operationIsSupported(op)) {
            return;
        }
        this.opToUI.put(op, ui);
    }

    protected DataAdapterUI getCachedUI(IOOperation op) {
        return (DataAdapterUI)this.opToUI.get(op);
    }

    public boolean hasLinkData() {
        return false;
    }

    public boolean isComposite() {
        return false;
    }

    public ApolloDataAdapterI getChildAdapter(String species) {
        throw new NotImplementedException("getSpeciesAdapter() should not be getting called on AbstractApolloAdapters");
    }

    public ApolloDataAdapterI getChildAdapter(int i) {
        throw new NotImplementedException("getSpeciesAdapter() should not be getting called on AbstractApolloAdapters");
    }

    public int getNumberOfChildAdapters() {
        return 0;
    }

    public Map getAdapters() {
        throw new NotImplementedException("getAdapters() should not be getting called on AbstractApolloAdapters");
    }

    public void setSpecies(String species) {
        this.species = species;
    }

    public String getSpecies() {
        return this.species;
    }

    public Style getStyle() {
        if (this.style == null) {
            this.style = this.getDefaultStyle();
        }
        if (this.styleExplicitlySet) {
            return this.style;
        }
        this.style = this.getDefaultStyle().databaseHasStyle(this.getDatabase()) ? this.getDefaultStyle().getStyleForDb(this.getDatabase()) : this.getDefaultStyle();
        return this.style;
    }

    protected Style getDefaultStyle() {
        return Config.getStyle(this.getClass().getName());
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getDatabase() {
        return this.database;
    }

    public void loadNewSpeciesFromLink(SeqFeatureI link, CompositeDataHolder c) throws DataAdapterException {
        throw new NotImplementedException();
    }

    public void setPadLeft(int padLeft) {
    }

    public void setPadRight(int padRight) {
    }

    public void setStyle(Style style) {
        this.styleExplicitlySet = true;
        this.style = style;
    }

    public void setDataLoadListener(DataLoadListener l) {
        this.regionChangeListener = l;
    }
}

