/*
 * Decompiled with CFR 0.152.
 */
package apollo.config;

import apollo.config.Config;
import apollo.config.DefaultNameAdapter;
import apollo.datamodel.AnnotatedFeature;
import apollo.datamodel.AnnotatedFeatureI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TigrSybilNameAdapter
extends DefaultNameAdapter {
    protected Pattern geneIdPattern = Pattern.compile("(\\S+)\\.(\\d+\\.\\S+)_gene");

    public String generateURL(AnnotatedFeatureI g) {
        if (g instanceof AnnotatedFeature) {
            String geneUrl = Config.getGeneUrl();
            Matcher m = this.geneIdPattern.matcher(g.getId());
            if (m.matches()) {
                String geneDb = m.group(1);
                String geneId = m.group(2);
                return geneUrl + "&db=" + geneDb + "&orf=" + geneId;
            }
            System.err.println("WARNING - failed to parse TIGR eukaryotic annotation database name and transcript id from gene name '" + g.getId() + "'");
        }
        return null;
    }
}

