/*
 * Decompiled with CFR 0.152.
 */
package apollo.config;

import apollo.config.Config;
import apollo.config.FeatureProperty;
import apollo.config.PropertyScheme;
import apollo.config.SimpleOverlap;
import apollo.config.TierProperty;
import apollo.editor.UserName;
import apollo.gui.drawable.Drawable;
import apollo.gui.drawable.DrawableUtil;
import apollo.util.IOUtil;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import javax.swing.JOptionPane;

public class TiersIO {
    protected static final Set stanzaSet = new HashSet();
    protected static final HashMap propertyMap = new HashMap();
    protected String filename;
    private FeatureProperty defaultFeatureProperty = null;
    protected PropertyScheme scheme;
    protected Vector allTypes = new Vector();
    protected Vector comments = new Vector();

    public TiersIO(PropertyScheme scheme) {
        this.scheme = scheme;
    }

    private BufferedReader openFile(String filename) {
        this.filename = filename;
        File tiersfile = new File(filename);
        return this.openFile(tiersfile);
    }

    private BufferedReader openFile(File tiersfile) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(tiersfile));
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return reader;
    }

    public Vector doParse(String filename) {
        block14: {
            int lineNumber = 0;
            String currentLine = null;
            String currentStanza = null;
            TierProperty currentTier = null;
            FeatureProperty currentType = null;
            try {
                BufferedReader reader = this.openFile(filename);
                if (reader != null) {
                    boolean new_format = true;
                    while ((currentLine = reader.readLine()) != null && new_format) {
                        ++lineNumber;
                        if (this.blankLine(currentLine = currentLine.trim())) {
                            currentStanza = null;
                            continue;
                        }
                        if (this.isComment(currentLine)) {
                            Vector currentComments = currentTier != null ? currentTier.getComments() : (currentType != null ? currentType.getComments() : this.comments);
                            currentComments.add(currentLine);
                            continue;
                        }
                        if (this.isStanza(currentLine)) {
                            currentStanza = this.getStanza(currentLine, lineNumber);
                            if (currentStanza != null) {
                                currentTier = this.isStanza(currentStanza, "Tier") ? this.getTier(null) : null;
                                currentType = this.isStanza(currentStanza, "Type") ? this.makeDefaultFeatureProperty() : null;
                                continue;
                            }
                            currentTier = null;
                            currentType = null;
                            continue;
                        }
                        int index = TiersIO.findUnescaped(currentLine, ':');
                        if (index <= 0) continue;
                        String tag = currentLine.substring(0, index).trim();
                        String value = currentLine.substring(++index).trim();
                        if (currentTier != null) {
                            this.updateTier(currentTier, tag.toLowerCase(), value);
                            continue;
                        }
                        if (currentType != null) {
                            this.updateType(currentType, tag.toLowerCase(), value);
                            continue;
                        }
                        System.err.println(filename + " is in old format based on line\n" + currentLine + "\nat line " + lineNumber);
                        new_format = false;
                    }
                    if (new_format) {
                        Iterator i = this.allTypes.iterator();
                        while (i.hasNext()) {
                            currentType = (FeatureProperty)i.next();
                            currentTier = this.getTier(currentType.getTierName());
                            if (currentTier != null) {
                                currentTier.addFeatureProperty(currentType);
                                continue;
                            }
                            System.out.println("No tier " + currentType.getTier() + " for type " + currentType.getDisplayType() + " in tiers file " + filename);
                        }
                        this.repairDrawableNames();
                        this.validateAnnotTypes();
                    } else {
                        reader.close();
                        this.readOld(filename);
                        this.repairDrawableNames();
                        String orig = filename + ".orig";
                        IOUtil.copyFile(filename, orig);
                        System.out.println("Moved old tiers file " + filename + " to " + orig);
                        System.out.println("Saving tiers file " + filename + " in new format ");
                        this.doSave(new File(filename), this.comments);
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Unable to parse line " + lineNumber + ": " + currentLine + "\n in tiers file " + filename);
                if (!Config.DEBUG) break block14;
                e.printStackTrace();
            }
        }
        return this.comments;
    }

    private FeatureProperty makeDefaultFeatureProperty() {
        if (this.defaultFeatureProperty == null) {
            return new FeatureProperty();
        }
        return this.defaultFeatureProperty.cloneFeatureProperty();
    }

    private void setDefaultFeatureProperty(FeatureProperty fp) {
        this.defaultFeatureProperty = fp;
        this.scheme.setDefaultFeatureProperty(fp);
    }

    protected boolean blankLine(String line) {
        return line.length() == 0;
    }

    protected boolean isComment(String line) {
        return line.charAt(0) == '#' || line.charAt(0) == '/' && line.charAt(1) == '/';
    }

    protected boolean isStanza(String line) {
        return line.charAt(0) == '[';
    }

    protected String getStanza(String line, int lineNumber) {
        String stanzaname = null;
        if (this.isStanza(line)) {
            if (line.charAt(line.length() - 1) != ']') {
                System.err.println("Unclosed stanza \"" + line + "\" at line" + lineNumber + " in tiers file " + this.filename);
                stanzaname = line.substring(1);
            } else {
                stanzaname = line.substring(1, line.length() - 1);
            }
            if (stanzaname.length() < 1) {
                System.err.println("Empty stanza \"" + line + "\" at line" + lineNumber + " in tiers file " + this.filename);
                stanzaname = null;
            } else if (!this.isAllowed(stanzaname)) {
                System.err.println("stanza \"" + stanzaname + "\" at line" + lineNumber + " is not allowed" + " in tiers file " + this.filename);
                stanzaname = null;
            }
        }
        return stanzaname;
    }

    protected boolean isStanza(String currentStanza, String stanzaname) {
        return currentStanza != null && currentStanza.equals(stanzaname);
    }

    protected void updateTier(TierProperty tp, String tag, String value) {
        if (this.isAllowed("Tier", tag)) {
            try {
                if ("tiername".equals(tag)) {
                    boolean isFirstTier = this.scheme.getAllTiers().size() == 0;
                    this.initTier(tp, value, isFirstTier);
                } else if ("visible".equals(tag)) {
                    tp.setVisible(new Boolean(value));
                } else if ("expanded".equals(tag)) {
                    tp.setExpanded(new Boolean(value));
                } else if ("sorted".equals(tag)) {
                    tp.setSorted(new Boolean(value));
                } else if ("labeled".equals(tag)) {
                    tp.setLabeled(new Boolean(value));
                } else if ("maxrows".equals(tag)) {
                    tp.setMaxRow(Integer.parseInt(value));
                } else if ("curated".equals(tag)) {
                    tp.setCurated(new Boolean(value));
                } else if ("warnonedit".equalsIgnoreCase(tag)) {
                    tp.setWarnOnEdit(new Boolean(value));
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                System.err.println("Unable to parse tier " + tag + " : " + value + " in tiers file " + this.filename);
                e.printStackTrace();
            }
        } else {
            System.err.println("Invalid tag \"" + tag + "\" for Tier. Ignoring " + tag + " = " + value + " in tiers file " + this.filename);
        }
    }

    protected void updateType(FeatureProperty fp, String tag, String value) {
        block37: {
            if (this.isAllowed("Type", tag)) {
                try {
                    if (tag.equalsIgnoreCase("typename") || tag.equalsIgnoreCase("label")) {
                        Iterator i = this.allTypes.iterator();
                        while (i.hasNext()) {
                            FeatureProperty type = (FeatureProperty)i.next();
                            if (!type.getDisplayType().equalsIgnoreCase(value)) continue;
                            System.out.println("Warning: adding type " + value + " to tier " + fp.getTierName() + ", but another tier, " + type.getTierName() + ", already has a type called " + value + "(in tiers file " + this.filename + ")");
                        }
                        fp.setDisplayType(value);
                        if (value.equalsIgnoreCase("gene") || value.equalsIgnoreCase("pseudogene")) {
                            fp.setNumberOfLevels(3);
                        }
                        if (value.equals("DEFAULT")) {
                            this.setDefaultFeatureProperty(fp);
                        } else {
                            this.allTypes.add(fp);
                        }
                        break block37;
                    }
                    if ("tiername".equalsIgnoreCase(tag)) {
                        fp.setTierName(value);
                        break block37;
                    }
                    if ("resulttype".equalsIgnoreCase(tag) || "datatype".equalsIgnoreCase(tag)) {
                        fp.addAnalysisType(value);
                        break block37;
                    }
                    if ("color".equalsIgnoreCase(tag)) {
                        Color colour = FeatureProperty.toColour(value);
                        fp.setColour(colour, false);
                        break block37;
                    }
                    if ("usescore".equalsIgnoreCase(tag)) {
                        fp.setSizeByScore(new Boolean(value));
                        break block37;
                    }
                    if ("minscore".equalsIgnoreCase(tag)) {
                        fp.setMinScore(new Float(value).floatValue());
                        break block37;
                    }
                    if ("maxscore".equalsIgnoreCase(tag)) {
                        fp.setMaxScore(new Float(value).floatValue());
                        break block37;
                    }
                    if ("minwidth".equalsIgnoreCase(tag)) {
                        fp.setMinWidth(Integer.parseInt(value));
                        break block37;
                    }
                    if ("scorethreshold".equalsIgnoreCase(tag)) {
                        fp.setThreshold(new Float(value).floatValue());
                        break block37;
                    }
                    if ("glyph".equalsIgnoreCase(tag)) {
                        fp.setStyle(value);
                        break block37;
                    }
                    if ("column".equalsIgnoreCase(tag)) {
                        fp.addColumnHeading(value);
                        break block37;
                    }
                    if ("sortbycolumn".equalsIgnoreCase(tag)) {
                        fp.setSortProperty(value);
                        break block37;
                    }
                    if ("reversesort".equalsIgnoreCase(tag)) {
                        fp.setReverseSort(new Boolean(value));
                        break block37;
                    }
                    if ("groupby".equalsIgnoreCase(tag)) {
                        fp.setGroupFlag(value);
                        break block37;
                    }
                    if ("weburl".equalsIgnoreCase(tag)) {
                        fp.setURLString(value);
                        break block37;
                    }
                    if ("freshdate".equalsIgnoreCase(tag)) {
                        fp.setRecentDate(value);
                        break block37;
                    }
                    if ("idformat".equalsIgnoreCase(tag)) {
                        fp.setIdFormat(value);
                        break block37;
                    }
                    if ("annot_type".equalsIgnoreCase(tag)) {
                        fp.setAnnotType(value);
                        break block37;
                    }
                    if ("utr_color".equalsIgnoreCase(tag)) {
                        Color colour = FeatureProperty.toColour(value);
                        fp.setUtrColor(colour);
                        break block37;
                    }
                    if ("name_method".equalsIgnoreCase(tag)) {
                        fp.setNameAdapterString(value);
                        break block37;
                    }
                    if ("overlap_method".equalsIgnoreCase(tag)) {
                        fp.setOverlapper(value);
                        break block37;
                    }
                    if ("synteny_link_type".equalsIgnoreCase(tag)) {
                        fp.setLinkType(value);
                        break block37;
                    }
                    if ("link_query_species".equalsIgnoreCase(tag)) {
                        fp.setLinkSpecies1(value);
                        break block37;
                    }
                    if ("link_hit_species".equalsIgnoreCase(tag)) {
                        fp.setLinkSpecies2(value);
                        break block37;
                    }
                    if ("synteny_link_level".equalsIgnoreCase(tag)) {
                        fp.setSyntenyLinkLevel(value);
                        break block37;
                    }
                    if ("synteny_link_match_on".equalsIgnoreCase(tag)) {
                        fp.setSyntenyLinkMatchOn(value);
                        break block37;
                    }
                    if ("warnonedit".equalsIgnoreCase(tag)) {
                        fp.setWarnOnEdit(new Boolean(value));
                        break block37;
                    }
                    if (!"number_of_levels".equalsIgnoreCase(tag)) break block37;
                    try {
                        int levels = Integer.valueOf(value);
                        fp.setNumberOfLevels(levels);
                    }
                    catch (NumberFormatException e) {
                        System.out.println("non number in levels " + tag);
                    }
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                    System.err.println("Unable to parse type " + tag + " : " + value + " in tiers file " + this.filename);
                    e.printStackTrace();
                    System.exit(1);
                }
            } else {
                System.out.println("Invalid tag \"" + tag + "\" for Type. Ignoring " + value + " in tiers file " + this.filename + " Check that tag" + " is allowed (has to be set in HashSet)");
            }
        }
    }

    protected TierProperty getTier(String tiername) {
        TierProperty tp;
        if (tiername == null) {
            tp = new TierProperty();
        } else {
            tp = this.scheme.getTierProperty(tiername, false);
            if (tp == null) {
                tp = new TierProperty();
                boolean isFirstTier = this.scheme.getAllTiers().size() == 0;
                this.initTier(tp, tiername, isFirstTier);
            }
        }
        return tp;
    }

    protected void initTier(TierProperty tp, String tiername, boolean isFirstTier) {
        tp.setLabel(tiername);
        this.scheme.addTierType(tp);
        tp.setIsFirstTier(isFirstTier);
    }

    protected void initTier(TierProperty tp, String tiername) {
        tp.setLabel(tiername);
        this.scheme.addTierType(tp);
    }

    public boolean isAllowed(String stanza) {
        return stanzaSet.contains(stanza);
    }

    public boolean isAllowed(String stanza, String tag) {
        String key = stanza;
        Set propSet = (Set)propertyMap.get(key);
        if (propSet == null) {
            return false;
        }
        if (propSet.contains(tag)) {
            return true;
        }
        return "resulttype".equalsIgnoreCase(tag) || "typename".equalsIgnoreCase(tag);
    }

    public static int findUnescaped(String str, char toChar) {
        return TiersIO.findUnescaped(str, toChar, 0, str.length());
    }

    public static int findUnescaped(String str, char toChar, int startindex, int endindex) {
        for (int i = startindex; i < endindex; ++i) {
            char c = str.charAt(i);
            if (c == '\\') {
                ++i;
                continue;
            }
            if (c != toChar) continue;
            return i;
        }
        return -1;
    }

    public void doSave(File file, Vector comments) {
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            String date = new Date().toString();
            out.println("# Tiers for " + Config.getStyle().getFileName() + " saved by " + UserName.getUserName() + " on " + date + "\n");
            this.saveComments(out, comments);
            out.println("");
            Vector tiersVect = this.scheme.getAllTiers();
            int tier_count = tiersVect.size();
            TierProperty default_tp = new TierProperty();
            FeatureProperty default_fp = this.makeDefaultFeatureProperty();
            for (int i = 0; i < tier_count; ++i) {
                TierProperty tp = (TierProperty)tiersVect.elementAt(i);
                this.saveTier(out, tp, default_tp);
                Vector typesVect = tp.getFeatureProperties();
                for (int j = 0; j < typesVect.size(); ++j) {
                    FeatureProperty fp = (FeatureProperty)typesVect.elementAt(j);
                    this.saveType(out, fp, default_fp);
                }
            }
            out.close();
        }
        catch (Exception e) {
            System.out.println("Unable to write tiers file " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void saveTier(PrintWriter out, TierProperty tp, TierProperty default_tp) {
        this.saveComments(out, tp.getComments());
        out.println("[Tier]");
        out.println("tiername : " + tp.getLabel());
        if (tp.isVisible() != default_tp.isVisible()) {
            out.println("visible : " + tp.isVisible());
        }
        if (tp.isExpanded() != default_tp.isExpanded()) {
            out.println("expanded : " + tp.isExpanded());
        }
        if (tp.isSorted() != default_tp.isSorted()) {
            out.println("sorted : " + tp.isSorted());
        }
        if (tp.isLabeled() != default_tp.isLabeled()) {
            out.println("labeled : " + tp.isLabeled());
        }
        if (tp.isCurated() != default_tp.isCurated()) {
            out.println("curated : " + tp.isCurated());
        }
        if (tp.getMaxRow() != default_tp.getMaxRow()) {
            out.println("maxrows : " + tp.getMaxRow());
        }
        out.println("");
    }

    private void saveType(PrintWriter out, FeatureProperty fp, FeatureProperty default_fp) {
        Vector column_headings;
        this.saveComments(out, fp.getComments());
        out.println("[Type]");
        out.println("label : " + fp.getDisplayType());
        out.println("tiername : " + fp.getTierName());
        Vector analysis_types = fp.getAnalysisTypes();
        for (int i = 0; i < analysis_types.size(); ++i) {
            out.println("datatype : " + (String)analysis_types.elementAt(i));
        }
        out.println("glyph : " + fp.getStyle());
        out.println("color : " + fp.getColourAsString());
        if (fp.warnOnEdit() != default_fp.warnOnEdit()) {
            out.println("warnonedit : " + fp.warnOnEdit());
        }
        if (fp.getIdFormat() != null && fp.getIdFormat() != default_fp.getIdFormat()) {
            out.println("idformat : " + fp.getIdFormat());
        }
        if (fp.getAnnotType() != null && fp.getAnnotType() != default_fp.getAnnotType()) {
            out.println("annot_type : " + fp.getAnnotType());
        }
        if (fp.getUtrColor() != null && fp.getUtrColor() != default_fp.getUtrColor()) {
            out.println("utr_color : " + fp.getColourAsString(fp.getUtrColor()));
        }
        if (fp.hasNonDefaultNameAdapter()) {
            out.println("name_method : " + fp.getNameAdapterString());
        }
        if (fp.hasOverlapper() && fp.getOverlapper() != SimpleOverlap.getSimpleOverlap()) {
            out.println("overlap_method : " + fp.createNameFromClass(fp.getOverlapper()));
        }
        if (fp.getSizeByScore() != default_fp.getSizeByScore()) {
            out.println("usescore : " + fp.getSizeByScore());
        }
        if (fp.getSizeByScore()) {
            if (fp.getMinScore() != default_fp.getMinScore()) {
                out.println("minscore : " + fp.getMinScore());
            }
            if (fp.getMaxScore() != default_fp.getMaxScore()) {
                out.println("maxscore : " + fp.getMaxScore());
            }
            if (fp.getMinWidth() != default_fp.getMinWidth()) {
                out.println("minwidth : " + fp.getMinWidth());
            }
        }
        if (fp.getThreshold() != default_fp.getThreshold()) {
            out.println("scorethreshold : " + fp.getThreshold());
        }
        if ((column_headings = fp.getColumnHeadings(false)) != null) {
            for (int i = 0; i < column_headings.size(); ++i) {
                out.println("column : " + (String)column_headings.elementAt(i));
            }
        }
        if (fp.getSortProperty() != null && fp.getSortProperty() != default_fp.getSortProperty()) {
            out.println("sortbycolumn : " + fp.getSortProperty());
        }
        if (fp.getReverseSort() != default_fp.getReverseSort()) {
            out.println("reversesort : " + fp.getReverseSort());
        }
        if (fp.getGroupFlag() != null && fp.getGroupFlag() != default_fp.getGroupFlag()) {
            out.println("groupby : " + fp.getGroupFlagAsString());
        }
        if (fp.getURLString() != null) {
            out.println("weburl : " + fp.getURLString());
        }
        if ((double)fp.getThreshold() != -1.0 || fp.getRecentDate() != null) {
            out.println("freshdate : " + fp.getRecentDate());
        }
        out.println("");
        if (fp.getNumberOfLevels() != 1) {
            out.println("number_of_levels : " + fp.getNumberOfLevels());
        }
    }

    private void saveComments(PrintWriter out, Vector comments) {
        for (int i = 0; i < comments.size(); ++i) {
            out.println((String)comments.elementAt(i));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readOld(String fileName) throws IOException, FileNotFoundException {
        File typeFile = new File(fileName);
        Vector bracedStrs = null;
        Stack bracedSets = new Stack();
        boolean inBraces = false;
        String sortProperty = null;
        Hashtable<String, Boolean> datatypeLabels = new Hashtable<String, Boolean>();
        try {
            StreamTokenizer tokenizer = new StreamTokenizer(new BufferedReader(new FileReader(typeFile)));
            tokenizer.resetSyntax();
            tokenizer.wordChars(95, 95);
            tokenizer.wordChars(97, 122);
            tokenizer.wordChars(65, 90);
            tokenizer.wordChars(46, 46);
            tokenizer.wordChars(48, 57);
            tokenizer.wordChars(45, 45);
            tokenizer.wordChars(58, 58);
            tokenizer.wordChars(123, 123);
            tokenizer.wordChars(125, 125);
            tokenizer.wordChars(42, 42);
            tokenizer.commentChar(47);
            tokenizer.quoteChar(34);
            tokenizer.whitespaceChars(32, 32);
            tokenizer.whitespaceChars(44, 44);
            tokenizer.eolIsSignificant(true);
            tokenizer.slashStarComments(true);
            boolean EOF = false;
            int tokType = 0;
            Vector<String> words = new Vector<String>();
            int line_number = 0;
            boolean alreadyPoppedUpAParseError = false;
            while (!EOF) {
                try {
                    String tier_label;
                    tokType = tokenizer.nextToken();
                    if (tokType == -1) {
                        return;
                    }
                    if (tokenizer.sval != null) {
                        if (!inBraces) {
                            if (!tokenizer.sval.startsWith("{")) {
                                words.addElement(tokenizer.sval);
                                continue;
                            }
                            bracedStrs = TiersIO.grabTypeStr(tokenizer.sval, bracedStrs, bracedSets);
                            inBraces = !tokenizer.sval.endsWith("}");
                            continue;
                        }
                        bracedStrs = TiersIO.grabTypeStr(tokenizer.sval, bracedStrs, bracedSets);
                        inBraces = !tokenizer.sval.endsWith("}");
                        continue;
                    }
                    if (tokType == -2) {
                        words.addElement(Double.toString(tokenizer.nval));
                        System.err.print("Warning number in group types file: " + tokenizer.nval);
                        continue;
                    }
                    TierProperty tp = null;
                    ++line_number;
                    if ((words.size() == 4 || words.size() == 5 || words.size() == 6 || words.size() == 7) && bracedSets.size() == 0 && ((String)words.elementAt(0)).equalsIgnoreCase("tier")) {
                        tier_label = (String)words.elementAt(1);
                        Boolean visible = Boolean.valueOf((String)words.elementAt(2));
                        Boolean expand = Boolean.valueOf((String)words.elementAt(3));
                        Boolean sort = words.size() >= 5 ? Boolean.valueOf((String)words.elementAt(4)) : new Boolean(false);
                        Integer maxRow = words.size() >= 6 ? Integer.valueOf((String)words.elementAt(5)) : new Integer(0);
                        Boolean labeled = words.size() == 7 ? Boolean.valueOf((String)words.elementAt(6)) : new Boolean(false);
                        tp = this.scheme.getTierProperty(tier_label, false);
                        if (tp == null) {
                            tp = new TierProperty(tier_label, visible, expand, sort, maxRow, labeled);
                            this.scheme.addTierType(tp);
                        } else {
                            tp.setVisible(visible);
                            tp.setExpanded(expand);
                            tp.setSorted(sort);
                        }
                    } else if (words.size() >= 10 && words.size() <= 14 && bracedSets.size() == 2 && ((String)words.elementAt(0)).equalsIgnoreCase("type")) {
                        tier_label = (String)words.elementAt(1);
                        String type = (String)words.elementAt(2);
                        tp = this.scheme.getTierProperty(tier_label, false);
                        if (tp == null) {
                            tp = new TierProperty(tier_label, true, false);
                            this.scheme.addTierType(tp);
                        }
                        Color colour = FeatureProperty.toColour((String)words.elementAt(3));
                        Boolean size = Boolean.valueOf((String)words.elementAt(4));
                        Float minScore = Float.valueOf((String)words.elementAt(5));
                        Float maxScore = Float.valueOf((String)words.elementAt(6));
                        String style = (String)words.elementAt(7);
                        sortProperty = (String)words.elementAt(8);
                        Boolean reverseSort = Boolean.valueOf((String)words.elementAt(9));
                        Vector column_headings = (Vector)bracedSets.pop();
                        Vector prog_db = (Vector)bracedSets.pop();
                        if (datatypeLabels.containsKey(type)) {
                            System.err.println("WARNING: Type name " + type + " appears twice in tiers file " + Config.getTiersFile());
                        } else {
                            datatypeLabels.put(type, new Boolean(true));
                        }
                        FeatureProperty fp = new FeatureProperty(tp, type, prog_db, colour, style, size, minScore.floatValue(), maxScore.floatValue());
                        fp.setColumnHeadings(column_headings);
                        fp.setSortProperty(sortProperty);
                        fp.setReverseSort(reverseSort);
                        if (words.size() >= 11) {
                            String grouper = (String)words.elementAt(10);
                            fp.setGroupFlag(grouper);
                        }
                        if (words.size() >= 12) {
                            String URLString = (String)words.elementAt(11);
                            fp.setURLString(URLString);
                        }
                        if (words.size() >= 13) {
                            Float threshScore = Float.valueOf((String)words.elementAt(12));
                            fp.setThreshold(threshScore.floatValue());
                        }
                        if (words.size() >= 14) {
                            String dateString = (String)words.elementAt(13);
                            fp.setRecentDate(dateString);
                        }
                    } else if (words.size() > 0) {
                        String first_word = (String)words.elementAt(0);
                        String second_word = "";
                        if (words.size() > 1) {
                            second_word = (String)words.elementAt(1);
                        }
                        String msg = "WARNING: Ignoring type line " + line_number + " in file " + fileName + " due to parse errors.\n" + "The line begins with \"" + first_word + " " + second_word + "\"" + " and has " + words.size() + " words.\n";
                        if (!first_word.equalsIgnoreCase("type")) {
                            msg = msg + " Should start with \"type\".";
                        }
                        if (!alreadyPoppedUpAParseError) {
                            msg = msg + "\nOnly showing this error dialog for first error.";
                            JOptionPane.showMessageDialog(null, msg, "Parse Error in " + fileName, 0);
                        }
                        alreadyPoppedUpAParseError = true;
                        System.out.println(msg);
                    }
                    this.parseKeyValuePairs(words, tp);
                    words.removeAllElements();
                    bracedStrs = null;
                    bracedSets.removeAllElements();
                }
                catch (IOException e) {
                    System.out.println(e);
                    throw e;
                }
            }
            return;
        }
        catch (FileNotFoundException e) {
            System.out.println(e);
            throw e;
        }
    }

    private static String removeBraces(String str) {
        if (str.startsWith("{")) {
            str = str.substring(1);
        }
        if (str.endsWith("}")) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    private static Vector grabTypeStr(String str, Vector bracedStrs, Stack bracedSets) {
        boolean braces_end = str.endsWith("}");
        String clean_str = TiersIO.removeBraces(str);
        if (bracedStrs == null) {
            bracedStrs = new Vector<String>();
        }
        if (clean_str.length() != 0) {
            bracedStrs.addElement(clean_str);
        }
        if (braces_end) {
            bracedSets.push(bracedStrs);
            bracedStrs = null;
        }
        return bracedStrs;
    }

    private void parseKeyValuePairs(Vector words, TierProperty tierProperty) {
        if (tierProperty == null) {
            return;
        }
        for (int i = 0; i < words.size(); ++i) {
            String keyValue;
            int equalsIndex;
            String word = (String)words.get(i);
            if (!this.isKeyValue(word) || (equalsIndex = (keyValue = word.substring(9)).indexOf(61)) == -1) continue;
            String key = keyValue.substring(0, equalsIndex);
            String value = keyValue.substring(equalsIndex + 1);
            if (!key.equals("isProtein")) continue;
            boolean isProtein = Boolean.valueOf(value);
            tierProperty.setIsProtein(isProtein);
        }
    }

    private boolean isKeyValue(String word) {
        return word.startsWith("property:");
    }

    private void repairDrawableNames() {
        Vector tiers = this.scheme.getAllTiers();
        int tier_count = tiers.size();
        for (int i = 0; i < tier_count; ++i) {
            TierProperty tp = (TierProperty)tiers.elementAt(i);
            Vector types = tp.getFeatureProperties();
            int type_count = types.size();
            for (int j = 0; j < type_count; ++j) {
                Drawable glyph;
                int index;
                FeatureProperty fp = (FeatureProperty)types.elementAt(j);
                String style = fp.getStyle();
                if (style.startsWith("apollo.gui.drawable.")) {
                    style = style.substring("apollo.gui.drawable.".length());
                }
                if (style.startsWith("shape:")) {
                    style = style.substring("shape:".length());
                }
                if ((index = style.indexOf("SeqFeature")) > 0) {
                    style = style.substring(0, index) + "FeatureSet";
                }
                if (style.equalsIgnoreCase("DrawableInsertFeatureSet") || style.equalsIgnoreCase("DrawableInsertion")) {
                    style = "Triangle";
                }
                if (style.equalsIgnoreCase("DrawableAnnotatedFeatureSet")) {
                    style = "DrawableGeneFeatureSet";
                }
                if (style.equalsIgnoreCase("DrawableTerminalCodon")) {
                    style = "SiteCodon";
                }
                if ((glyph = DrawableUtil.createGlyph(style)) == null) {
                    System.err.println("HEY! Unable to find drawable Java class for " + style + " in tiers file " + this.filename + ". Will use default DrawableResultFeatureSet");
                    style = "DrawableResultFeatureSet";
                }
                fp.setStyle(style);
            }
        }
    }

    private void validateAnnotTypes() {
        Vector tiers = this.scheme.getAllTiers();
        int tier_count = tiers.size();
        Vector annot_types = this.scheme.getAnnotationFeatureProps();
        for (int i = 0; i < tier_count; ++i) {
            TierProperty tp = (TierProperty)tiers.elementAt(i);
            Vector types = tp.getFeatureProperties();
            int type_count = types.size();
            for (int j = 0; j < type_count; ++j) {
                FeatureProperty fp = (FeatureProperty)types.elementAt(j);
                String annot_type = fp.getAnnotType();
                if (annot_type == null) continue;
                boolean matched = false;
                matched = annot_type.equals(FeatureProperty.getDefaultAnnotType());
                for (int k = 0; k < annot_types.size() && !matched; ++k) {
                    FeatureProperty annot_prop = (FeatureProperty)annot_types.elementAt(k);
                    matched = annot_prop.getDisplayType().equalsIgnoreCase(annot_type);
                }
                if (matched) continue;
                String defaultType = FeatureProperty.getDefaultAnnotType();
                String m = "Feature type " + fp.getDisplayType() + " has non-existent " + "annot_type " + annot_type + " in tiers file " + this.filename + " Setting to " + "default annot type \"" + defaultType + "\"";
                System.out.println(m);
                fp.setAnnotType(defaultType);
            }
        }
    }

    static {
        HashSet<String> temp = new HashSet<String>();
        temp.add("tiername");
        temp.add("visible");
        temp.add("expanded");
        temp.add("sorted");
        temp.add("maxrows");
        temp.add("labeled");
        temp.add("curated");
        temp.add("warnonedit");
        stanzaSet.add("Tier");
        propertyMap.put("Tier", temp);
        temp = new HashSet();
        temp.add("label");
        temp.add("tiername");
        temp.add("datatype");
        temp.add("color");
        temp.add("usescore");
        temp.add("minscore");
        temp.add("maxscore");
        temp.add("minwidth");
        temp.add("scorethreshold");
        temp.add("glyph");
        temp.add("column");
        temp.add("sortbycolumn");
        temp.add("reversesort");
        temp.add("groupby");
        temp.add("weburl");
        temp.add("freshdate");
        temp.add("idformat");
        temp.add("annot_type");
        temp.add("utr_color");
        temp.add("overlap_method");
        temp.add("name_method");
        temp.add("synteny_link_type");
        temp.add("link_query_species");
        temp.add("link_hit_species");
        temp.add("synteny_link_level");
        temp.add("synteny_link_match_on");
        temp.add("number_of_levels");
        temp.add("warnonedit");
        stanzaSet.add("Type");
        propertyMap.put("Type", temp);
    }
}

