/*
 * Decompiled with CFR 0.152.
 */
package apollo.config;

import apollo.config.FeatureProperty;
import apollo.config.PropertyScheme;
import apollo.util.CaseInsensitiveStringHash;
import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class TierProperty
implements Cloneable,
Serializable {
    protected String label;
    protected boolean expanded = false;
    protected boolean visible = false;
    protected boolean sorted = false;
    protected boolean labeled = false;
    protected int maxRow = 0;
    protected boolean curated = false;
    protected boolean warnOnEdit = false;
    protected Vector comments = new Vector();
    protected CaseInsensitiveStringHash analysis_types = new CaseInsensitiveStringHash();
    private CaseInsensitiveStringHash typesHash = new CaseInsensitiveStringHash();
    private PropertyScheme propertyScheme;
    private Vector featProps = new Vector();
    public static boolean VISIBLE = true;
    public static boolean NOT_VISIBLE = false;
    protected boolean isFirstTier = false;
    private boolean isProtein = false;

    public TierProperty() {
        this("", true, false, false, 0, false);
    }

    public TierProperty(String label, boolean visible, boolean expanded, boolean sorted, int maxRow, boolean labeled) {
        this(label, visible, expanded, sorted, maxRow);
        this.setLabeled(labeled);
    }

    public TierProperty(String label, boolean visible, boolean expanded, boolean sorted, int maxRow) {
        this(label, visible, expanded, sorted);
        this.setMaxRow(maxRow);
    }

    public TierProperty(String label, boolean visible, boolean expanded, boolean sorted) {
        this(label, visible, expanded);
        this.setSorted(sorted);
    }

    public TierProperty(String label, boolean visible, boolean expanded) {
        this(label, visible);
        this.setExpanded(expanded);
    }

    public TierProperty(String label, boolean visible) {
        this.setLabel(label);
        this.setVisible(visible);
    }

    public TierProperty(String label) {
        this(label, true, false, false, 0, false);
    }

    public TierProperty(TierProperty from) {
        this(from.getLabel(), from.isVisible(), from.isExpanded(), from.isSorted(), from.getMaxRow(), from.isLabeled());
    }

    void setPropertyScheme(PropertyScheme propertyScheme) {
        this.propertyScheme = propertyScheme;
    }

    void firePropSchemeChangeEvent() {
        if (this.propertyScheme != null) {
            this.propertyScheme.firePropSchemeChangeEvent();
        }
    }

    public void setLabel(String label) {
        if (label == null) {
            throw new NullPointerException("TierProperty.setLabel: can't accept null label");
        }
        this.label = label;
        this.firePropSchemeChangeEvent();
    }

    public String getLabel() {
        return this.label;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        this.firePropSchemeChangeEvent();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
        this.firePropSchemeChangeEvent();
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setSorted(boolean sorted) {
        this.sorted = sorted;
        this.firePropSchemeChangeEvent();
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public void setMaxRow(int maxRow) {
        this.maxRow = maxRow;
        this.firePropSchemeChangeEvent();
    }

    public int getMaxRow() {
        return this.maxRow;
    }

    public void setLabeled(boolean labeled) {
        this.labeled = labeled;
        this.firePropSchemeChangeEvent();
    }

    public boolean isLabeled() {
        if (!this.expanded) {
            return false;
        }
        return this.labeled;
    }

    public void setCurated(boolean curated) {
        this.curated = curated;
        this.firePropSchemeChangeEvent();
    }

    public boolean isCurated() {
        return this.curated;
    }

    public void setWarnOnEdit(boolean warn) {
        this.warnOnEdit = warn;
        this.firePropSchemeChangeEvent();
    }

    public boolean warnOnEdit() {
        return this.warnOnEdit;
    }

    protected String quoteIfSpace(String str) {
        if (str.indexOf(" ") > -1 || str.indexOf("/") > -1) {
            return new String("\"" + str + "\"");
        }
        return str;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public FeatureProperty getFeatureProperty(String type) {
        return (FeatureProperty)this.typesHash.get(type);
    }

    public Vector getFeatureProperties() {
        return this.featProps;
    }

    public void addFeatureProperty(FeatureProperty fp) {
        if (!this.holdsType(fp.getDisplayType())) {
            this.typesHash.put(fp.getDisplayType().toLowerCase(), fp);
            this.featProps.addElement(fp);
            fp.setTier(this);
            fp.inheritWarnOnEdit(this.warnOnEdit());
        }
        this.addAnalysisTypes(fp, fp.getAnalysisTypes());
    }

    private void addAnalysisTypes(FeatureProperty fp, Vector analysis_types) {
        for (int i = 0; i < analysis_types.size(); ++i) {
            String analysis = (String)analysis_types.elementAt(i);
            this.addAnalysisType(fp, analysis);
        }
    }

    public void addAnalysisType(FeatureProperty fp, String analysis) {
        this.analysis_types.put(analysis, fp);
    }

    public FeatureProperty featureForAnalysisType(String analysis_type) {
        return (FeatureProperty)this.analysis_types.get(analysis_type);
    }

    public String getTypesAsString() {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < this.featProps.size(); ++i) {
            FeatureProperty fp = (FeatureProperty)this.featProps.elementAt(i);
            buff.append("\ttype: " + fp.getDisplayType() + " {");
            Vector types = fp.getAnalysisTypes();
            for (int k = 0; k < types.size(); ++k) {
                buff.append(" " + (String)types.elementAt(k));
            }
            buff.append("}\n");
        }
        buff.append("\n");
        return buff.toString();
    }

    public boolean labelEquals(String name) {
        return this.label.equalsIgnoreCase(name);
    }

    public boolean holdsType(String type) {
        return this.typesHash.containsKey(type.toLowerCase());
    }

    public Color getColour() {
        if (this.featProps.size() > 0) {
            return ((FeatureProperty)this.featProps.elementAt(0)).getColour();
        }
        return FeatureProperty.DEFAULT_COLOR;
    }

    void setIsProtein(boolean isProtein) {
        this.isProtein = isProtein;
    }

    public boolean isProtein() {
        return this.isProtein;
    }

    protected void addComment(String comment) {
        this.comments.addElement(comment);
    }

    protected Vector getComments() {
        return this.comments;
    }

    protected void setIsFirstTier(boolean firstTier) {
        this.isFirstTier = firstTier;
    }

    public boolean isFirstTier() {
        return this.isFirstTier;
    }

    private FeatureProperty getFeatureProperty(int i) {
        return (FeatureProperty)this.featProps.get(i);
    }

    List getSyntenyLinkedFeatProps() {
        ArrayList<FeatureProperty> linkedFeatProps = new ArrayList<FeatureProperty>();
        for (int i = 0; i < this.featProps.size(); ++i) {
            FeatureProperty fp = this.getFeatureProperty(i);
            if (!fp.isSyntenyLinked()) continue;
            linkedFeatProps.add(fp);
        }
        return linkedFeatProps;
    }

    boolean hasLinkedFeatProps() {
        return this.getSyntenyLinkedFeatProps().size() != 0;
    }
}

