/*
 * Decompiled with CFR 0.152.
 */
package apollo.config;

import apollo.config.Config;
import apollo.config.DefaultNameAdapter;
import apollo.config.FeatureProperty;
import apollo.datamodel.RangeI;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.StrandedFeatureSetI;
import apollo.util.FeatureList;
import java.util.Vector;

public class SimpleNameAdapter
extends DefaultNameAdapter {
    private static final boolean addAnnotSuffix = true;

    public String generateName(StrandedFeatureSetI annots, String curation_name, SeqFeatureI feature, Vector resultFeats) {
        if (resultFeats == null || resultFeats.size() == 0) {
            if (Config.DEBUG) {
                System.out.println("No result for SimpleNameAdapter to name annot with");
            }
            return super.generateName(annots, curation_name, feature);
        }
        RangeI firstResult = (RangeI)resultFeats.get(0);
        String name = firstResult.getName();
        name = name + "-annot" + this.getSuffixNumber(name, annots);
        return name;
    }

    private int getSuffixNumber(String resultName, StrandedFeatureSetI annots) {
        String nameRegexp = resultName + "-annot\\d+";
        FeatureList anns = annots.findFeaturesByAllNames(nameRegexp, true, true);
        if (anns.isEmpty()) {
            return 1;
        }
        int index = resultName.length() + "-annot".length();
        int largestSuffixNumber = 0;
        for (int i = 0; i < anns.size(); ++i) {
            SeqFeatureI ann = anns.getFeature(i);
            String numString = ann.getName().substring(index);
            try {
                int sfxNum = Integer.valueOf(numString);
                if (sfxNum <= largestSuffixNumber) continue;
                largestSuffixNumber = sfxNum;
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return largestSuffixNumber + 1;
    }

    public String generateName(StrandedFeatureSetI annots, String curation_name, SeqFeatureI feature) {
        if (this.isTranscriptOfOneLevelAnnot(feature)) {
            return feature.getRefFeature().getName();
        }
        return super.generateName(annots, curation_name, feature);
    }

    private boolean isTranscriptOfOneLevelAnnot(SeqFeatureI feat) {
        if (!feat.isTranscript()) {
            return false;
        }
        String annotType = feat.getRefFeature().getFeatureType();
        FeatureProperty fp = Config.getPropertyScheme().getFeatureProperty(annotType);
        return fp.isOneLevel();
    }
}

