/*
 * Decompiled with CFR 0.152.
 */
package apollo.config;

import java.util.HashMap;
import java.util.Map;

public class LinkType
implements Cloneable {
    public static final LinkType NO_LINK = new LinkType("NO_LINK");
    public static final LinkType PEPTIDE = new LinkType("PEPTIDE");
    public static final LinkType TRANSCRIPT = new LinkType("TRANSCRIPT");
    public static final LinkType SELF = new LinkType("SELF");
    private static Map stringToType;
    private static final String PARENT_LEVEL = "PARENT";
    private static final String CHILD_LEVEL = "CHILD";
    private String linkLevel = "CHILD";
    private boolean matchOnId = false;
    private String typeString;

    private LinkType(String typeString) {
        if (stringToType == null) {
            stringToType = new HashMap(4);
        }
        stringToType.put(typeString, this);
        this.typeString = typeString;
    }

    static LinkType getLinkTypeForString(String typeString) {
        LinkType linkType = (LinkType)stringToType.get(typeString);
        if (linkType == null) {
            System.err.println(typeString + " is not a valid link type. Valid types are:" + " PEPTIDE, TRANSCRIPT, and SELF");
            return NO_LINK;
        }
        return linkType;
    }

    void setSyntenyLinkLevel(String level) {
        if (level.equals(PARENT_LEVEL)) {
            this.linkLevel = PARENT_LEVEL;
        } else if (level.equals(CHILD_LEVEL)) {
            this.linkLevel = CHILD_LEVEL;
        } else {
            System.out.println("synteny_link_level " + level + " is invalid. Must be " + PARENT_LEVEL + " or " + CHILD_LEVEL);
        }
    }

    public boolean isParentLevel() {
        return this.linkLevel == PARENT_LEVEL;
    }

    void setSyntenyLinkMatchOn(String matchOn) {
        if (matchOn.equalsIgnoreCase("ID")) {
            this.matchOnId = true;
        } else if (matchOn.equalsIgnoreCase("RANGE")) {
            this.matchOnId = false;
        } else {
            System.out.println(matchOn + " is invalid value for synteny_link_match_on in " + " tiers file, ignoring");
        }
    }

    public boolean isLinkById() {
        return this.matchOnId;
    }

    public String toString() {
        return "LinkType: " + this.typeString;
    }
}

