/*
 * Decompiled with CFR 0.152.
 */
package apollo.config;

import apollo.config.Config;
import apollo.config.DefaultNameAdapter;
import apollo.config.FeatureProperty;
import apollo.datamodel.AnnotatedFeature;
import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.ExonI;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.StrandedFeatureSetI;
import apollo.datamodel.Transcript;
import apollo.editor.AddTransaction;
import apollo.editor.CompoundTransaction;
import apollo.editor.Transaction;
import apollo.editor.TransactionSubpart;
import apollo.editor.UpdateTransaction;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GmodNameAdapter
extends DefaultNameAdapter {
    protected static int annotNumber = 1;
    private static final String transcriptSuffixRoot = "-transcript";
    private static final String peptideSuffixRoot = "-protein";

    public String generateName(StrandedFeatureSetI annots, String curation_name, SeqFeatureI feature) {
        if (feature.isTranscript()) {
            return this.generateTranscriptName(feature);
        }
        if (feature.isExon()) {
            Transcript transcript = ((ExonI)feature).getTranscript();
            if (transcript.isProteinCodingGene()) {
                return transcript.getName() + " exon " + (transcript.getFeatureIndex(feature) + 1);
            }
            return transcript.getName();
        }
        if (feature.hasAnnotatedFeature()) {
            return this.generateId(annots, curation_name, feature);
        }
        return "???";
    }

    private String generateAnnotTempId(StrandedFeatureSetI annots, String prefix) {
        if (annots == null) {
            System.err.println("GmodNameAdapter.genAnnTempId: annots is null!?");
            return "";
        }
        prefix = prefix + this.getTempSuffix();
        int num = this.nextAnnotNumber(annots);
        return prefix + num;
    }

    public String generateAnnotSplitName(SeqFeatureI annot, StrandedFeatureSetI annotParent, String curationName) {
        if (this.isTemp(annot) || this.isAnnotId(annot)) {
            return this.generateAnnotTempId(annotParent, this.getIDPrefix(annot));
        }
        String nameWithoutNumber = annot.getName();
        int index = nameWithoutNumber.lastIndexOf(":");
        if (index > 0 && index + 1 < nameWithoutNumber.length()) {
            nameWithoutNumber = nameWithoutNumber.substring(0, index);
        }
        int nextSplitNumber = 1;
        for (int i = 0; i < annotParent.size(); ++i) {
            SeqFeatureI annotSibling = annotParent.getFeatureAt(i);
            String this_name = annotSibling.getName();
            if (!this_name.startsWith(nameWithoutNumber)) continue;
            try {
                int splitNumber = this.getSplitNumber(this_name);
                if (splitNumber < nextSplitNumber) continue;
                nextSplitNumber = splitNumber + 1;
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return nameWithoutNumber + ":" + nextSplitNumber;
    }

    private int getSplitNumber(String splitName) throws NumberFormatException {
        boolean splitNumber = false;
        int index = splitName.indexOf(":");
        if (index == -1) {
            throw new NumberFormatException("No split number present");
        }
        String num_str = splitName.substring(index + 1);
        int namenum = Integer.parseInt(num_str);
        return namenum;
    }

    private String generateTranscriptName(SeqFeatureI transcript) {
        return this.generateTranscriptNameOrId(transcript, transcript.getRefFeature().getName());
    }

    protected String generateTranscriptId(SeqFeatureI trans) {
        return this.generateTranscriptNameOrId(trans, trans.getRefFeature().getId());
    }

    public boolean needsSuffix(String type) {
        return Config.getPropertyScheme().getTierProperty(type).isFirstTier();
    }

    private String generateTranscriptNameOrId(SeqFeatureI transcript, String annotNameOrId) {
        SeqFeatureI annot = transcript.getRefFeature();
        Vector transcripts = annot.getFeatures();
        int t_index = transcripts.indexOf(transcript);
        if (t_index < 0) {
            t_index = transcripts.size();
        }
        if (!this.needsSuffix(annot.getFeatureType())) {
            return annotNameOrId;
        }
        boolean addTemp = !this.isTemp(annotNameOrId);
        String suffix = this.generateTranscriptSuffix(t_index, transcripts, addTemp);
        String newNameOrId = annotNameOrId + suffix;
        return newNameOrId;
    }

    protected String generateTranscriptSuffix(int t_index, Vector transcripts, boolean addTemp) {
        String suffix;
        if (t_index == 0) {
            ++t_index;
        }
        if (this.suffixInUse(transcripts, suffix = this.getTranscriptSuffixRoot() + t_index, t_index - 1)) {
            suffix = this.generateTranscriptSuffix(++t_index, transcripts, false);
        }
        if (addTemp) {
            suffix = suffix + ":temp";
        }
        if (this.suffixInUse(transcripts, suffix, t_index - 1)) {
            return this.generateTranscriptSuffix(t_index + 1, transcripts, addTemp);
        }
        return suffix;
    }

    public String generateId(StrandedFeatureSetI annots, String curation_name, SeqFeatureI feature) {
        if (feature.isTranscript()) {
            return this.generateTranscriptId(feature);
        }
        if (feature.hasAnnotatedFeature()) {
            return this.generateAnnotTempId(annots, this.getIDPrefix(feature));
        }
        return "???";
    }

    private int nextAnnotNumber(StrandedFeatureSetI annots) {
        int i;
        int num = annotNumber;
        for (i = 0; i < annots.size(); ++i) {
            SeqFeatureI g = annots.getFeatureAt(i);
            String this_id = g.getId();
            num = this.skipUsedTempNum(this_id, num);
        }
        for (i = 0; i < this.getTransactionManager().size(); ++i) {
            Transaction trans = this.getTransactionManager().getTransaction(i);
            String id = trans.getProperty("id", Transaction.OLD);
            num = this.skipUsedTempNum(id, num);
            id = trans.getProperty("id", Transaction.NEW);
            num = this.skipUsedTempNum(id, num);
            id = trans.getProperty("annotation_id", Transaction.OLD);
            num = this.skipUsedTempNum(id, num);
        }
        annotNumber = num;
        return annotNumber;
    }

    public boolean nameIsId(SeqFeatureI feature) {
        String prefix;
        boolean is_ID = false;
        if (feature instanceof ExonI) {
            prefix = "EX";
            is_ID = this.getCG(feature.getName(), prefix) != null || feature.getName().startsWith(prefix + ":temp") || feature.getName().startsWith(prefix) && feature.getName().indexOf("tmp") > 0;
            prefix = "CG";
        } else if (feature instanceof Transcript) {
            prefix = "CT";
            is_ID = this.getCG(feature.getName(), prefix) != null || feature.getName().startsWith(prefix + ":temp") || feature.getName().startsWith(prefix) && feature.getName().indexOf("tmp") > 0;
            prefix = "CG";
        } else if (feature instanceof AnnotatedFeature) {
            prefix = "CG";
            is_ID = this.getCG(feature.getName(), prefix) != null || feature.getName().startsWith(prefix + ":temp") || feature.getName().startsWith(prefix) && feature.getName().indexOf("tmp") > 0;
            prefix = "CR";
        } else {
            prefix = "???";
        }
        return is_ID |= this.getCG(feature.getName(), prefix) != null || feature.getName().startsWith(prefix + ":temp") || feature.getName().startsWith(prefix) && feature.getName().indexOf("tmp") > 0;
    }

    protected boolean isAnnotId(SeqFeatureI annot) {
        return annot.getName().startsWith(this.getIDPrefix(annot));
    }

    private boolean isNoName(String name) {
        return name.equals("no_name");
    }

    public CompoundTransaction setAnnotName(AnnotatedFeatureI annot, String newName) {
        CompoundTransaction ct = new CompoundTransaction(this);
        String oldName = annot.getName();
        ct.addTransaction(this.setName(annot, newName));
        ct.addTransaction(this.addSynonym(annot, oldName));
        ct.addTransaction(this.setAllTranscriptNamesFromAnnot(annot));
        return ct;
    }

    private CompoundTransaction setAllTranscriptNamesFromAnnot(AnnotatedFeatureI annot) {
        CompoundTransaction compTrans = new CompoundTransaction(this);
        for (int i = 0; i < annot.size(); ++i) {
            AnnotatedFeatureI trans = annot.getFeatureAt(i).getAnnotatedFeature();
            CompoundTransaction t = this.setTranscriptNameFromAnnot(trans, annot);
            compTrans.addTransaction(t);
        }
        return compTrans;
    }

    public CompoundTransaction setTranscriptNameFromAnnot(AnnotatedFeatureI trans, AnnotatedFeatureI ann) {
        String transcriptSuffix = this.getTranscriptSuffix(trans, ann);
        String transcript_name = ann.getName() + transcriptSuffix;
        return this.setTranscriptName(trans, transcript_name);
    }

    public CompoundTransaction setTranscriptName(AnnotatedFeatureI trans, String name) {
        CompoundTransaction compTrans = new CompoundTransaction(this);
        if (trans.getName() != null && trans.getName().equals(name)) {
            return null;
        }
        String oldName = trans.getName();
        UpdateTransaction ut = super.setName(trans, name);
        compTrans.addTransaction(ut);
        if (trans.getRefFeature().isProteinCodingGene()) {
            CompoundTransaction seqTrans = this.setSeqNamesFromTranscript(trans);
            compTrans.addTransaction(seqTrans);
        }
        AddTransaction at = super.addSynonym(trans, oldName);
        compTrans.addTransaction(at);
        return compTrans;
    }

    public CompoundTransaction setTranscriptId(SeqFeatureI trans, String id) {
        CompoundTransaction compTrans = super.setTranscriptId(trans, id);
        if (trans.getRefFeature().isProteinCodingGene()) {
            compTrans.addTransaction(this.setPeptideIdFromTranscript(trans));
        }
        compTrans.setSource(this);
        return compTrans;
    }

    protected UpdateTransaction setPeptideIdFromTranscript(SeqFeatureI transcript) {
        if (transcript.getPeptideSequence() != null && transcript.getPeptideSequence().getAccessionNo() != null && !this.isTemp(transcript.getId())) {
            return null;
        }
        String tempPepId = this.generatePeptideNameFromTranscriptName(transcript.getId());
        if (tempPepId == null) {
            tempPepId = transcript.getName() + this.getPeptideSuffixRoot() + this.getTempSuffix();
        }
        if (!this.isTemp(tempPepId)) {
            tempPepId = tempPepId + this.getTempSuffix();
        }
        Object oldPepId = null;
        TransactionSubpart ts = TransactionSubpart.PEPTIDE_ID;
        UpdateTransaction ut = new UpdateTransaction(transcript, ts, oldPepId, tempPepId);
        ut.editModel();
        return ut;
    }

    protected String getTranscriptSuffix(SeqFeatureI trans, AnnotatedFeatureI annot) {
        int index;
        String transcriptName = trans.getName();
        int n = index = transcriptName != null ? transcriptName.lastIndexOf("-") : -1;
        if (index > 0) {
            return transcriptName.substring(index);
        }
        if (annot != null) {
            boolean addTemp = !this.isTemp(annot.getName());
            return this.generateTranscriptSuffix(annot.getFeatureIndex(trans), annot.getFeatures(), addTemp);
        }
        System.err.println("FlyNameAdap.getTransSuffix trans " + trans + " has no suffix");
        return "";
    }

    protected CompoundTransaction setSeqNamesFromTranscript(AnnotatedFeatureI trans) {
        CompoundTransaction ct = new CompoundTransaction(this);
        if (trans.hasPeptideSequence()) {
            String pepName = this.generatePeptideNameFromTranscriptName(trans.getName());
            TransactionSubpart ts = TransactionSubpart.PEPTIDE_NAME;
            UpdateTransaction t = new UpdateTransaction(trans, ts);
            t.setOldSubpartValue(trans.getPeptideSequence().getName());
            t.setNewSubpartValue(pepName);
            t.editModel();
            ct.addTransaction(t);
        }
        return ct;
    }

    public String generatePeptideNameFromTranscriptName(String transcriptName) {
        String pepName = transcriptName;
        int index = transcriptName.indexOf(this.getTranscriptSuffixRoot());
        if (index == -1) {
            return null;
        }
        String ordinal = transcriptName.substring(index + this.getTranscriptSuffixRoot().length());
        pepName = transcriptName.substring(0, index) + this.getPeptideSuffixRoot() + ordinal;
        return pepName;
    }

    public String generatePeptideIdFromTranscriptId(String transcriptId) {
        return this.generatePeptideNameFromTranscriptName(transcriptId);
    }

    protected String getTranscriptSuffixRoot() {
        return transcriptSuffixRoot;
    }

    protected String getPeptideSuffixRoot() {
        return peptideSuffixRoot;
    }

    public String getTranscriptNamePattern() {
        String pat = ".*" + this.getTranscriptSuffixRoot() + this.getTranscriptOrdinalPattern();
        if (this.transcriptCanHaveTempSuffix()) {
            pat = pat + "(" + this.getTempSuffix() + ")*";
        }
        return pat;
    }

    protected String getTranscriptOrdinalPattern() {
        if (this.transcriptOrdinalIsNumeric()) {
            return "\\d+";
        }
        return "[A-Z]+";
    }

    protected boolean transcriptOrdinalIsNumeric() {
        return true;
    }

    protected boolean transcriptCanHaveTempSuffix() {
        return true;
    }

    private String getTempSuffix() {
        return ":temp";
    }

    public boolean typeChangeCausesIdChange(String oldType, String newType) {
        return !this.getIDPrefix(oldType).equals(this.getIDPrefix(newType));
    }

    public String getNewIdFromTypeChange(String oldId, String oldType, String newType) {
        String oldPrefix = this.getIDPrefix(oldType);
        String oldSuffix = oldId.substring(oldPrefix.length());
        String newPrefix = this.getIDPrefix(newType);
        return newPrefix + oldSuffix;
    }

    protected boolean match(SeqFeatureI sf, String matchString) {
        if (sf.getFeatureType().equals("transcript")) {
            return Pattern.matches(this.getTranscriptNamePattern(), matchString);
        }
        if (sf.getId().indexOf("temp") >= 0 || sf.getId().indexOf("tmp") >= 0) {
            FeatureProperty fp = Config.getPropertyScheme().getFeatureProperty(sf.getTopLevelType());
            if (fp == null || fp != null && fp.getIdFormat() == null) {
                return true;
            }
            return Pattern.matches(this.getPrefix(fp.getIdFormat()), this.getPrefix(matchString));
        }
        return super.match(sf, matchString);
    }

    private String getCG(String name, String prefix) {
        String cg_name = null;
        String tmp_name = name;
        if (tmp_name.startsWith(prefix)) {
            int index = tmp_name.indexOf(":");
            if (index > 0) {
                tmp_name = tmp_name.substring(0, index);
            }
            if (!tmp_name.equals(prefix)) {
                cg_name = tmp_name;
            }
        }
        return cg_name;
    }

    public boolean suffixInUse(Vector transcripts, String suffix, int t_index) {
        boolean used = false;
        for (int i = 0; i < transcripts.size() && !used; ++i) {
            if (i == t_index) continue;
            Transcript t = (Transcript)transcripts.elementAt(i);
            used = t.getName().endsWith(suffix);
        }
        return used;
    }

    protected String getIDPrefix(SeqFeatureI sf) {
        return this.getIDPrefix(sf.getFeatureType());
    }

    private String getIDPrefix(String type) {
        FeatureProperty fp = Config.getPropertyScheme().getFeatureProperty(type);
        if (fp == null || fp != null && fp.getIdFormat() == null) {
            return this.getDefaultIDPrefix();
        }
        String idFormat = fp.getIdFormat();
        return this.getPrefix(idFormat);
    }

    protected String getDefaultIDPrefix() {
        return "GMOD";
    }

    protected String getPrefix(String idFormat) {
        Pattern p = Pattern.compile("[a-zA-Z_]+:*");
        Matcher m = p.matcher(idFormat);
        boolean patternFound = m.find();
        if (!patternFound) {
            return idFormat;
        }
        return idFormat.substring(0, m.end());
    }
}

