/*
 * Decompiled with CFR 0.152.
 */
package apollo.config;

import apollo.config.ApolloNameAdapterI;
import apollo.config.Config;
import apollo.config.FeatureProperty;
import apollo.datamodel.AnnotatedFeature;
import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.ExonI;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.StrandedFeatureSetI;
import apollo.datamodel.Synonym;
import apollo.datamodel.Transcript;
import apollo.editor.AddTransaction;
import apollo.editor.CompoundTransaction;
import apollo.editor.Transaction;
import apollo.editor.TransactionManager;
import apollo.editor.TransactionSubpart;
import apollo.editor.UpdateTransaction;
import apollo.util.SeqFeatureUtil;
import java.util.Vector;
import java.util.regex.Pattern;

public class DefaultNameAdapter
implements ApolloNameAdapterI {
    private static int annotNumber = 1;
    private TransactionManager transactionManager;
    static /* synthetic */ Class class$apollo$datamodel$AnnotatedFeature;
    static /* synthetic */ Class class$apollo$datamodel$Transcript;
    static /* synthetic */ Class class$apollo$datamodel$ExonI;

    protected DefaultNameAdapter() {
    }

    public void setTransactionManager(TransactionManager tm) {
        this.transactionManager = tm;
    }

    protected TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public String generateName(StrandedFeatureSetI annots, String curation_name, SeqFeatureI feature, Vector exonResults) {
        return this.generateName(annots, curation_name, feature);
    }

    public String getSuffixDelimiter() {
        return "-";
    }

    public boolean checkName(String name, Class featureClass) {
        return false;
    }

    public String generateName(StrandedFeatureSetI annots, String curation_name, SeqFeatureI feature) {
        if (feature instanceof AnnotatedFeature) {
            return this.getName(annots, curation_name, class$apollo$datamodel$AnnotatedFeature == null ? (class$apollo$datamodel$AnnotatedFeature = DefaultNameAdapter.class$("apollo.datamodel.AnnotatedFeature")) : class$apollo$datamodel$AnnotatedFeature, this.nextAnnotNumber(annots, class$apollo$datamodel$AnnotatedFeature == null ? (class$apollo$datamodel$AnnotatedFeature = DefaultNameAdapter.class$("apollo.datamodel.AnnotatedFeature")) : class$apollo$datamodel$AnnotatedFeature), "GN", "");
        }
        if (feature instanceof Transcript) {
            return this.getName(annots, curation_name, class$apollo$datamodel$Transcript == null ? (class$apollo$datamodel$Transcript = DefaultNameAdapter.class$("apollo.datamodel.Transcript")) : class$apollo$datamodel$Transcript, this.nextAnnotNumber(annots, class$apollo$datamodel$Transcript == null ? (class$apollo$datamodel$Transcript = DefaultNameAdapter.class$("apollo.datamodel.Transcript")) : class$apollo$datamodel$Transcript), "XS", "");
        }
        if (feature instanceof ExonI) {
            return this.getName(annots, curation_name, class$apollo$datamodel$ExonI == null ? (class$apollo$datamodel$ExonI = DefaultNameAdapter.class$("apollo.datamodel.ExonI")) : class$apollo$datamodel$ExonI, this.nextAnnotNumber(annots, class$apollo$datamodel$ExonI == null ? (class$apollo$datamodel$ExonI = DefaultNameAdapter.class$("apollo.datamodel.ExonI")) : class$apollo$datamodel$ExonI), "EX", "");
        }
        return "???";
    }

    public String generateAnnotSplitName(SeqFeatureI annot, StrandedFeatureSetI annotParent, String curationName) {
        return this.generateName(annotParent, curationName, annot);
    }

    public String generateId(StrandedFeatureSetI annots, String curation_name, SeqFeatureI feature) {
        if (feature.isTranscript()) {
            return this.getId(annots, curation_name, class$apollo$datamodel$Transcript == null ? (class$apollo$datamodel$Transcript = DefaultNameAdapter.class$("apollo.datamodel.Transcript")) : class$apollo$datamodel$Transcript, this.nextAnnotNumber(annots, class$apollo$datamodel$Transcript == null ? (class$apollo$datamodel$Transcript = DefaultNameAdapter.class$("apollo.datamodel.Transcript")) : class$apollo$datamodel$Transcript), "XS", "");
        }
        if (feature.isExon()) {
            return this.getId(annots, curation_name, class$apollo$datamodel$ExonI == null ? (class$apollo$datamodel$ExonI = DefaultNameAdapter.class$("apollo.datamodel.ExonI")) : class$apollo$datamodel$ExonI, this.nextAnnotNumber(annots, class$apollo$datamodel$ExonI == null ? (class$apollo$datamodel$ExonI = DefaultNameAdapter.class$("apollo.datamodel.ExonI")) : class$apollo$datamodel$ExonI), "EX", "");
        }
        if (feature.hasAnnotatedFeature()) {
            return this.getId(annots, curation_name, class$apollo$datamodel$AnnotatedFeature == null ? (class$apollo$datamodel$AnnotatedFeature = DefaultNameAdapter.class$("apollo.datamodel.AnnotatedFeature")) : class$apollo$datamodel$AnnotatedFeature, this.nextAnnotNumber(annots, class$apollo$datamodel$AnnotatedFeature == null ? (class$apollo$datamodel$AnnotatedFeature = DefaultNameAdapter.class$("apollo.datamodel.AnnotatedFeature")) : class$apollo$datamodel$AnnotatedFeature), "GN", "");
        }
        return "???";
    }

    public String generateExonId(SeqFeatureI exon, String geneId) {
        return geneId + ":" + exon.getStart() + "-" + exon.getEnd();
    }

    protected UpdateTransaction setName(AnnotatedFeatureI annFeat, String newName) {
        TransactionSubpart ts = TransactionSubpart.NAME;
        UpdateTransaction ut = new UpdateTransaction(annFeat, ts, annFeat.getName(), newName);
        ut.editModel();
        return ut;
    }

    public CompoundTransaction setAnnotName(AnnotatedFeatureI annot, String newName) {
        CompoundTransaction ct = new CompoundTransaction(this);
        String oldName = annot.getName();
        ct.addTransaction(this.setName(annot, newName));
        ct.addTransaction(this.addSynonym(annot, oldName));
        return ct;
    }

    public CompoundTransaction setTranscriptName(AnnotatedFeatureI trans, String name) {
        String oldName = trans.getName();
        CompoundTransaction ct = new CompoundTransaction(this);
        UpdateTransaction ut = this.setName(trans, name);
        ct.addTransaction(ut);
        AddTransaction at = this.addSynonym(trans, oldName);
        ct.addTransaction(at);
        return ct;
    }

    public CompoundTransaction setTranscriptId(SeqFeatureI trans, String id) {
        CompoundTransaction ct = new CompoundTransaction(this);
        ct.addTransaction(this.setId(trans, id));
        return ct;
    }

    public CompoundTransaction setTranscriptNameFromAnnot(AnnotatedFeatureI trans, AnnotatedFeatureI gene) {
        return this.setTranscriptName(trans, gene.getName());
    }

    protected AddTransaction addSynonym(AnnotatedFeatureI annFeat, String synString) {
        if (synString == null || synString.equals("no_name") || this.isTemp(synString)) {
            return null;
        }
        if (annFeat.hasSynonym(synString)) {
            return null;
        }
        TransactionSubpart ts = TransactionSubpart.SYNONYM;
        Synonym synonym = new Synonym(synString);
        AddTransaction at = new AddTransaction(annFeat, ts, synonym);
        at.editModel();
        return at;
    }

    public boolean isTemp(String idOrName) {
        return idOrName.indexOf(":temp") >= 0;
    }

    protected boolean isTemp(SeqFeatureI feat) {
        return this.isTemp(feat.getName());
    }

    public boolean nameIsId(SeqFeatureI feature) {
        String prefix = feature instanceof AnnotatedFeature ? "GN" : (feature instanceof Transcript ? "XS" : (feature instanceof ExonI ? "EX" : "???"));
        return feature.getName().startsWith(prefix);
    }

    private String getId(StrandedFeatureSetI annots, String curation_name, Class featureClass, int start, String prefix, String suffix) {
        prefix = prefix + ":temp";
        Vector features = SeqFeatureUtil.getFeaturesOfClass(annots, featureClass, false);
        int num = start;
        for (int i = 0; i < features.size(); ++i) {
            SeqFeatureI g = (SeqFeatureI)features.elementAt(i);
            String this_id = g.getId();
            if (this_id == null || !this_id.startsWith(prefix)) continue;
            try {
                String id;
                int idnum;
                int index = this_id.indexOf(":" + curation_name);
                if (index > 0) {
                    this_id = this_id.substring(0, index);
                }
                if ((idnum = Integer.parseInt(id = this_id.substring(prefix.length()))) < num) continue;
                num = idnum + 1;
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return prefix + num + suffix;
    }

    private String getName(StrandedFeatureSetI annots, String curation_name, Class featureClass, int start, String prefix, String suffix) {
        prefix = prefix + ":temp";
        Vector features = SeqFeatureUtil.getFeaturesOfClass(annots, featureClass, false);
        int num = start;
        for (int i = 0; i < features.size(); ++i) {
            SeqFeatureI g = (SeqFeatureI)features.elementAt(i);
            String this_name = g.getName();
            if (!this_name.startsWith(prefix)) continue;
            try {
                String num_str;
                int namenum;
                int index = this_name.indexOf(":" + curation_name);
                if (index > 0) {
                    this_name = this_name.substring(0, index);
                }
                if ((namenum = Integer.parseInt(num_str = this_name.substring(prefix.length()))) < num) continue;
                num = namenum + 1;
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return prefix + num + suffix;
    }

    public boolean suffixInUse(Vector transcripts, String suffix, int t_index) {
        boolean used = false;
        for (int i = 0; i < transcripts.size() && !used; ++i) {
            if (i == t_index) continue;
            Transcript t = (Transcript)transcripts.elementAt(i);
            used = t.getName().endsWith(suffix);
        }
        return used;
    }

    public boolean checkFormat(SeqFeatureI feat, String idOrName) {
        return this.match(feat, idOrName);
    }

    public boolean idAndNameHaveSameFormat(SeqFeatureI feat, String id, String name) {
        FeatureProperty fp = Config.getPropertyScheme().getFeatureProperty(feat.getFeatureType());
        if (fp == null || fp != null && fp.getIdFormat() == null) {
            return false;
        }
        return this.checkFormat(feat, id) && this.match(feat, name);
    }

    protected boolean match(SeqFeatureI sf, String matchString) {
        FeatureProperty fp = Config.getPropertyScheme().getFeatureProperty(sf.getFeatureType());
        if (fp == null || fp != null && fp.getIdFormat() == null) {
            return true;
        }
        return Pattern.matches(fp.getIdFormat(), matchString);
    }

    public String getTranscriptNamePattern() {
        return null;
    }

    public boolean typeChangeCausesIdChange(String oldType, String newType) {
        return false;
    }

    public String getNewIdFromTypeChange(String oldId, String oldType, String newType) {
        return oldId;
    }

    protected int nextAnnotNumber(StrandedFeatureSetI annots, Class featClass) {
        int i;
        int num = annotNumber;
        Vector features = SeqFeatureUtil.getFeaturesOfClass(annots, featClass, false);
        for (i = 0; i < features.size(); ++i) {
            SeqFeatureI g = (SeqFeatureI)features.elementAt(i);
            String this_id = g.getId();
            num = this.skipUsedTempNum(this_id, num);
        }
        for (i = 0; i < this.transactionManager.size(); ++i) {
            Transaction trans = this.transactionManager.getTransaction(i);
            String id = trans.getProperty("id", Transaction.OLD);
            num = this.skipUsedTempNum(id, num);
            id = trans.getProperty("id", Transaction.NEW);
            num = this.skipUsedTempNum(id, num);
            id = trans.getProperty("annotation_id", Transaction.OLD);
            num = this.skipUsedTempNum(id, num);
        }
        annotNumber = num;
        return annotNumber;
    }

    protected int skipUsedTempNum(String id, int num) {
        int tempIdNum = -1;
        if (id != null && !id.equals("")) {
            if (id.indexOf("temp") < 0) {
                return num;
            }
            try {
                int prefixOffset = id.indexOf(":temp");
                String tempNumString = id.substring(prefixOffset + ":temp".length());
                tempIdNum = Integer.parseInt(tempNumString);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (tempIdNum >= num) {
            num = tempIdNum + 1;
        }
        return num;
    }

    public CompoundTransaction setAnnotId(AnnotatedFeatureI annot, String id) {
        UpdateTransaction ut = this.setId(annot, id);
        CompoundTransaction compoundTrans = new CompoundTransaction(this);
        compoundTrans.addTransaction(ut);
        return compoundTrans;
    }

    protected UpdateTransaction setId(SeqFeatureI annot, String newId) {
        TransactionSubpart ts = TransactionSubpart.ID;
        String oldId = annot.getId();
        UpdateTransaction ut = new UpdateTransaction(annot, ts, oldId, newId);
        ut.setOldId(oldId);
        ut.setNewId(newId);
        ut.editModel();
        return ut;
    }

    public String generatePeptideNameFromTranscriptName(String transcriptName) {
        return transcriptName;
    }

    public String generatePeptideIdFromTranscriptId(String transcriptId) {
        return transcriptId;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

