/*
 * Decompiled with CFR 0.152.
 */
package apollo.config;

import apollo.config.Config;
import apollo.config.DisplayPrefsI;
import apollo.config.FeatureProperty;
import apollo.datamodel.CurationSet;
import apollo.datamodel.ExonI;
import apollo.datamodel.FeaturePair;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.RangeI;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.SequenceI;
import apollo.datamodel.Transcript;
import apollo.gui.URLQueryGenerator;
import apollo.gui.drawable.DrawableSeqFeature;
import javax.swing.JOptionPane;

public class DefaultDisplayPrefs
implements DisplayPrefsI {
    protected String getIdForURL(SeqFeatureI f) {
        return this.getDisplayName(f);
    }

    protected String getURLPrefix(FeatureProperty prop, SeqFeatureI f, String id) {
        return prop.getURLString();
    }

    public String generateURL(SeqFeatureI f) {
        String id = this.getIdForURL(f);
        FeatureProperty prop = Config.getPropertyScheme().getFeatureProperty(f.getFeatureType());
        String urlPrefix = this.getURLPrefix(prop, f, id);
        if (urlPrefix == null) {
            String m = "Sorry, no URL registered for type " + f.getFeatureType() + " in types file";
            JOptionPane.showMessageDialog(null, m);
            return null;
        }
        return URLQueryGenerator.getURL(urlPrefix, id);
    }

    public String getDisplayName(RangeI sf) {
        if (sf instanceof SeqFeatureI) {
            return this.getDisplayName((SeqFeatureI)sf);
        }
        return sf.getName();
    }

    private String getDisplayName(SeqFeatureI sf) {
        if (sf.hasHitFeature()) {
            SeqFeatureI hit = sf.getHitFeature();
            SequenceI seq = hit.getRefSequence();
            if (seq != null) {
                return seq.getName();
            }
            return hit.getName();
        }
        return sf.getName();
    }

    public String getHeader(RangeI sf) {
        return this.getDisplayName(sf);
    }

    public String getTitle(CurationSet curation) {
        String title = curation.getChildCurationSets().size() <= 0 ? (curation.getRefSequence() == null ? (curation.getName() != null ? curation.getName() : "Unknown sequence") : curation.getRefSequence().getName()) : "composite";
        return title;
    }

    public String getBioTypeForDisplay(SeqFeatureI sf) {
        return sf.getTopLevelType();
    }

    public String getPublicName(SeqFeatureI origSF) {
        String name = null;
        SeqFeatureI sf = origSF instanceof DrawableSeqFeature ? ((DrawableSeqFeature)((Object)origSF)).getFeature() : origSF;
        if (sf instanceof ExonI) {
            ExonI exon = (ExonI)sf;
            if (exon.getRefFeature() != null) {
                name = exon.getRefFeature().getName();
            } else {
                System.out.println("WARNING: No transcript for exon " + exon.getName());
                name = exon.getName();
            }
        } else if (sf instanceof FeaturePair) {
            FeaturePair fp = (FeaturePair)sf;
            name = fp.getHitFeature().getName();
            if (name == null || name.equals("")) {
                name = fp.getName();
            }
        } else if (sf instanceof Transcript) {
            Transcript trans = (Transcript)sf;
            name = trans.getName();
        } else {
            SeqFeatureI hit;
            SeqFeatureI sf2;
            FeatureSetI fs;
            SequenceI seq;
            name = sf instanceof FeatureSetI ? ((seq = (fs = (FeatureSetI)sf).getHitSequence()) != null ? seq.getName() : ((sf2 = fs.getFeatureAt(0)) instanceof FeaturePair ? ((seq = (hit = ((FeaturePair)sf2).getHitFeature()).getRefSequence()) != null ? seq.getName() : fs.getName()) : (sf2 != null ? sf2.getName() : sf.getName()))) : sf.getName();
        }
        if (name == null) {
            System.err.println("WARNING: null group name  class=" + sf.getClass().getName() + " name=" + sf.getName() + " type=" + sf.getFeatureType());
            name = "SeqFeatureI.NO_NAME";
        }
        return name;
    }
}

