/*
 * Decompiled with CFR 0.152.
 */
package apollo.analysis.filter;

import apollo.analysis.filter.AnalysisInput;
import apollo.analysis.filter.FilterPanel;
import apollo.util.GuiUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;

public class Sim4FilterPanel
extends FilterPanel {
    private JPanel filterConfigurationPanel;
    private JButton showFilterConfiguration;
    private JTextField min_score = new JTextField("90");
    private JTextField min_length = new JTextField("80");
    private JComboBox length_units = new JComboBox();
    private JToggleButton use_length = new JCheckBox("Remove HITs where length of aligned sequence is below threshold", false);
    private JTextField max_coverage = new JTextField("10");
    private JCheckBox limit_coverage = new JCheckBox("Remove redundant HITs to limit depth of coverage", false);
    private JCheckBox use_score = new JCheckBox("Remove alignments with a % identity below threshold", false);
    private JCheckBox join_reads = new JCheckBox("Join 5' and 3' alignments (indicated by a common prefix)", false);
    private JCheckBox revcomp3 = new JCheckBox("Reverse complement 3' reads (indicated by suffix)", false);
    private JTextField suffix = new JTextField("3prime");
    private JCheckBox remove_polyA = new JCheckBox("Remove alignments of polyA tails", false);
    private JCheckBox limit_exons = new JCheckBox("Limit number of alignments (useful for STS and other short contiguous markers)", false);
    private JTextField exon_max = new JTextField("");
    private JCheckBox limit_gaps = new JCheckBox("Delete matches with alignment gaps (in the mRNA) > this percentage of length ", false);
    private JTextField gap_max = new JTextField("50");

    public Sim4FilterPanel(Color bg_color) {
        this.setBackground(bg_color);
        this.buildGUI();
    }

    protected void buildGUI() {
        this.setLayout(new GridBagLayout());
        int row = 0;
        int textBoxHeight = 20;
        this.min_score.setPreferredSize(new Dimension(80, textBoxHeight));
        this.use_score.setBackground(this.getBackground());
        this.add((Component)this.use_score, GuiUtil.makeConstraintAt(0, row, 1));
        this.add((Component)this.min_score, GuiUtil.makeConstraintAt(1, row, 1));
        this.add((Component)GuiUtil.makeJLabelWithFont(" %"), GuiUtil.makeConstraintAt(2, row++, 1));
        this.min_length.setPreferredSize(new Dimension(80, textBoxHeight));
        this.length_units.setEditable(false);
        this.length_units.insertItemAt("percentage", 0);
        this.length_units.insertItemAt("fixed minimum", 1);
        this.length_units.setSelectedItem("percentage");
        this.use_length.setBackground(this.getBackground());
        this.add((Component)this.use_length, GuiUtil.makeConstraintAt(0, row, 1));
        this.add((Component)this.min_length, GuiUtil.makeConstraintAt(1, row, 1));
        this.add((Component)this.length_units, GuiUtil.makeConstraintAt(2, row++, 1));
        this.max_coverage.setPreferredSize(new Dimension(80, textBoxHeight));
        this.limit_coverage.setBackground(this.getBackground());
        this.add((Component)this.limit_coverage, GuiUtil.makeConstraintAt(0, row, 1));
        this.add((Component)this.max_coverage, GuiUtil.makeConstraintAt(1, row++, 1));
        this.join_reads.setBackground(this.getBackground());
        this.add((Component)this.join_reads, GuiUtil.makeConstraintAt(0, row++, 1));
        this.suffix.setPreferredSize(new Dimension(80, textBoxHeight));
        this.revcomp3.setBackground(this.getBackground());
        this.add((Component)this.revcomp3, GuiUtil.makeConstraintAt(0, row, 1));
        this.add((Component)this.suffix, GuiUtil.makeConstraintAt(1, row++, 1));
        this.remove_polyA.setBackground(this.getBackground());
        this.add((Component)this.remove_polyA, GuiUtil.makeConstraintAt(0, row++, 1));
        this.exon_max.setPreferredSize(new Dimension(80, textBoxHeight));
        this.limit_exons.setBackground(this.getBackground());
        this.add((Component)this.limit_exons, GuiUtil.makeConstraintAt(0, row, 1));
        this.add((Component)this.exon_max, GuiUtil.makeConstraintAt(1, row++, 1));
        this.gap_max.setPreferredSize(new Dimension(80, textBoxHeight));
        this.limit_gaps.setBackground(this.getBackground());
        this.add((Component)this.limit_gaps, GuiUtil.makeConstraintAt(0, row, 1));
        this.add((Component)this.gap_max, GuiUtil.makeConstraintAt(1, row++, 1));
    }

    public Properties getProperties() {
        Properties stateInfo = new Properties();
        stateInfo.setProperty("min_score", this.min_score.getText());
        stateInfo.setProperty("use_score", this.use_score.isSelected() ? "true" : "false");
        stateInfo.setProperty("min_length", this.min_length.getText());
        stateInfo.setProperty("use_length", this.use_length.isSelected() ? "true" : "false");
        stateInfo.setProperty("length_units", (String)this.length_units.getSelectedItem());
        stateInfo.setProperty("max_coverage", this.max_coverage.getText());
        stateInfo.setProperty("limit_coverage", this.limit_coverage.isSelected() ? "true" : "false");
        stateInfo.setProperty("join_reads", this.join_reads.isSelected() ? "true" : "false");
        stateInfo.setProperty("suffix", this.suffix.getText());
        stateInfo.setProperty("revcomp3", this.revcomp3.isSelected() ? "true" : "false");
        stateInfo.setProperty("remove_polyA", this.remove_polyA.isSelected() ? "true" : "false");
        stateInfo.setProperty("exon_max", this.exon_max.getText());
        stateInfo.setProperty("limit_exons", this.limit_exons.isSelected() ? "true" : "false");
        stateInfo.setProperty("gap_max", this.gap_max.getText());
        stateInfo.setProperty("limit_gaps", this.limit_gaps.isSelected() ? "true" : "false");
        return stateInfo;
    }

    public void setProperties(Properties properties) {
        String propValue = properties.getProperty("min_score");
        if (propValue != null) {
            this.min_score.setText(propValue);
        }
        if ((propValue = properties.getProperty("use_score")) != null && propValue.equals("true")) {
            this.use_score.setSelected(true);
        }
        if ((propValue = properties.getProperty("min_length")) != null) {
            this.min_length.setText(propValue);
        }
        if ((propValue = properties.getProperty("use_length")) != null && propValue.equals("true")) {
            this.use_length.setSelected(true);
        }
        propValue = properties.getProperty("length_units");
        propValue = properties.getProperty("max_coverage");
        if (propValue != null) {
            this.max_coverage.setText(propValue);
        }
        if ((propValue = properties.getProperty("limit_coverage")) != null && propValue.equals("true")) {
            this.limit_coverage.setSelected(true);
        }
        if ((propValue = properties.getProperty("join_reads")) != null && propValue.equals("true")) {
            this.join_reads.setSelected(true);
        }
        if ((propValue = properties.getProperty("suffix")) != null) {
            this.suffix.setText(propValue);
        }
        if ((propValue = properties.getProperty("revcomp3")) != null && propValue.equals("true")) {
            this.revcomp3.setSelected(true);
        }
        if ((propValue = properties.getProperty("remove_polyA")) != null && propValue.equals("true")) {
            this.remove_polyA.setSelected(true);
        }
        if ((propValue = properties.getProperty("exon_max")) != null) {
            this.exon_max.setText(propValue);
        }
        if ((propValue = properties.getProperty("limit_exons")) != null && propValue.equals("true")) {
            this.limit_exons.setSelected(true);
        }
        if ((propValue = properties.getProperty("gap_max")) != null) {
            this.gap_max.setText(propValue);
        }
        if ((propValue = properties.getProperty("limit_gaps")) != null && propValue.equals("true")) {
            this.limit_gaps.setSelected(true);
        }
    }

    public void setInputs(AnalysisInput inputs) {
        if (this.use_score.isSelected()) {
            inputs.setMinScore(this.min_score.getText());
        } else {
            inputs.setMinScore(AnalysisInput.NO_LIMIT);
        }
        if (this.use_length.isSelected()) {
            inputs.setMinLength(this.min_length.getText());
            String units = (String)this.length_units.getSelectedItem();
            inputs.setLengthUnits(units.equals("percentage"));
        } else {
            inputs.setMinLength(AnalysisInput.NO_LIMIT);
        }
        if (this.limit_coverage.isSelected()) {
            inputs.setMaxCover(this.max_coverage.getText());
        } else {
            inputs.setMaxCover(AnalysisInput.NO_LIMIT);
        }
        inputs.trimPolyA(this.remove_polyA.isSelected());
        inputs.joinESTends(this.join_reads.isSelected());
        if (this.revcomp3.isSelected()) {
            inputs.revComp3Prime(this.suffix.getText());
        }
        if (this.limit_exons.isSelected()) {
            inputs.setMaxExons(this.exon_max.getText());
        } else {
            inputs.setMaxExons(AnalysisInput.NO_LIMIT);
        }
        if (this.limit_gaps.isSelected()) {
            inputs.setMaxAlignGap(this.gap_max.getText());
        } else {
            inputs.setMaxAlignGap(AnalysisInput.NO_LIMIT);
        }
    }
}

