/*
 * Decompiled with CFR 0.152.
 */
package apollo.analysis;

import apollo.analysis.SeqAnalysisBase;
import apollo.analysis.SeqAnalysisI;
import apollo.datamodel.CurationSet;
import apollo.datamodel.SequenceI;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.bdgp.io.DataAdapter;
import org.bdgp.io.DataAdapterException;
import org.bdgp.io.DataAdapterUI;
import org.bdgp.io.IOOperation;

public class SeqAnalysisGUI
extends JPanel
implements DataAdapterUI {
    public static final int MAX_HISTORY_LENGTH = 5;
    protected SeqAnalysisI seqAnalysis;
    protected IOOperation op;
    JComboBox pathList;
    JLabel typeLabel;
    Vector filePaths;
    JButton browseButton;
    Properties props;
    Hashtable jboxes;

    public SeqAnalysisGUI(SeqAnalysisBase seqAnalysis, IOOperation op) {
        this.op = op;
        this.setPreferredSize(new Dimension(400, 400));
        this.typeLabel = new JLabel("File type not set");
        this.setDataAdapter((DataAdapter)seqAnalysis);
        this.buildGUI();
        this.attachListeners();
        System.out.println("seqA = " + seqAnalysis);
    }

    public void yo() {
        if (this.seqAnalysis.launch()) {
            System.out.println("Launched analysis!");
            while (!this.seqAnalysis.isFinished()) {
                System.out.println("waiting....");
            }
            if (this.seqAnalysis.hasResults()) {
                CurationSet cs = this.seqAnalysis.getCurationSet();
                String raw = this.seqAnalysis.getAllRawResults();
                System.out.println("Output = " + raw);
                JFrame jf = new JFrame("Analysis Results");
                JTextArea ta = new JTextArea(40, 85);
                ta.setFont(new Font("Courier", 0, 12));
                ta.setText(raw);
                ta.setWrapStyleWord(true);
                ta.setLineWrap(true);
                jf.getContentPane().add(new JScrollPane(ta));
                jf.pack();
                jf.show();
            }
        }
    }

    public Object doOperation(Object values) throws DataAdapterException {
        System.out.println("Doing op " + values);
        Vector proplist = this.seqAnalysis.getAllowedProperties();
        for (int i = 0; i < proplist.size(); ++i) {
            String p = (String)proplist.elementAt(i);
            JComboBox jbox = (JComboBox)this.jboxes.get(p);
            String item = (String)jbox.getSelectedItem();
            System.out.println(p + " selected " + item);
            this.seqAnalysis.addProperty(p, item);
        }
        LaunchRunnable runnable = new LaunchRunnable();
        Thread launcher = new Thread(runnable);
        launcher.start();
        return null;
    }

    public void buildGUI() {
        this.jboxes = new Hashtable();
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.typeLabel);
        JPanel seqPanel = new JPanel();
        seqPanel.setLayout(new BoxLayout(seqPanel, 0));
        JComboBox seqBox = new JComboBox();
        Vector<String> v2 = new Vector<String>();
        SequenceI sequence = this.seqAnalysis.getInputSequence();
        if (sequence != null) {
            v2.addElement(sequence.getName());
        } else {
            v2.addElement("unknown seq for " + this.seqAnalysis);
        }
        JLabel seqLabel = new JLabel("Input Sequence");
        this.add(seqLabel);
        seqBox.setEditable(true);
        seqBox.setModel(new DefaultComboBoxModel(v2));
        seqPanel.add(seqBox);
        this.add(seqPanel);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        this.add(panel);
        System.out.println("seqAnalysis = " + this.seqAnalysis);
        System.out.println("seqAnalysis = " + this.seqAnalysis.getAllowedProperties());
        Vector proplist = this.seqAnalysis.getAllowedProperties();
        for (int i = 0; i < proplist.size(); ++i) {
            String p = (String)proplist.elementAt(i);
            String type = this.seqAnalysis.getPropertyType(p);
            final String desc = this.seqAnalysis.getPropertyDescription(p);
            JLabel pLabel = new JLabel(p);
            this.add(pLabel);
            JPanel ppanel = new JPanel();
            ppanel.setLayout(new BoxLayout(ppanel, 0));
            if (desc != null) {
                JButton help = new JButton("?");
                help.setFont(this.getFont());
                ppanel.add(help);
                SeqAnalysisGUI me = this;
                try {
                    help.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent evt) {
                            System.out.println("DESC=" + desc);
                            JFrame jf = new JFrame("Property Description");
                            JTextArea ta = new JTextArea(10, 85);
                            ta.setFont(new Font("Courier", 0, 12));
                            ta.setText(desc);
                            ta.setWrapStyleWord(true);
                            ta.setLineWrap(true);
                            jf.getContentPane().add(new JScrollPane(ta));
                            jf.pack();
                            jf.show();
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            JComboBox jbox = new JComboBox();
            jbox.setEditable(true);
            Vector v = this.seqAnalysis.getAllowedValues(p);
            if (v == null) {
                v = new Vector();
            }
            jbox.setModel(new DefaultComboBoxModel(v));
            ppanel.add(jbox);
            if (type != null && type.equals("path")) {
                JButton browse = new JButton("Browse...");
                browse.setFont(this.getFont());
                ppanel.add(browse);
                SeqAnalysisGUI me = this;
                try {
                    browse.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent evt) {
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.add(ppanel);
            this.jboxes.put(p, jbox);
        }
    }

    public void attachListeners() {
    }

    public void setDataAdapter(DataAdapter seqAnalysis) {
        this.seqAnalysis = (SeqAnalysisI)seqAnalysis;
        this.typeLabel.setText(seqAnalysis.getType());
    }

    public void setInput(Object o) {
    }

    public void setProperties(Properties in) {
        this.props = in;
        this.filePaths = new Vector();
        if (this.props == null) {
            this.props = new Properties();
        }
        String historyItems = this.props.getProperty("historyItems");
        try {
            int items = Integer.parseInt(historyItems);
            for (int i = 0; i < items; ++i) {
                this.filePaths.addElement(this.props.getProperty("historyItem" + i));
            }
        }
        catch (NumberFormatException e) {
            System.out.println("Can't parse " + historyItems);
        }
    }

    public Properties getProperties() {
        Properties out = new Properties();
        if (this.filePaths.size() > 5) {
            out.setProperty("historyItems", "5");
        } else {
            out.setProperty("historyItems", this.filePaths.size() + "");
        }
        for (int i = 0; i < this.filePaths.size() && i < 5; ++i) {
            out.setProperty("historyItem" + i, (String)this.filePaths.elementAt(i));
        }
        return out;
    }

    public boolean validOperation() throws DataAdapterException {
        return true;
    }

    protected class LaunchRunnable
    implements Runnable {
        protected LaunchRunnable() {
        }

        public void run() {
            SeqAnalysisGUI.this.yo();
        }
    }
}

