/*
 * Decompiled with CFR 0.152.
 */
package apollo.analysis;

import apollo.analysis.AnalysisDataAdapterI;
import apollo.analysis.SeqAnalysisI;
import apollo.datamodel.CurationSet;
import apollo.datamodel.FeatureSet;
import apollo.datamodel.SequenceI;
import java.util.Hashtable;
import java.util.Vector;
import org.bdgp.io.AbstractDataAdapter;
import org.bdgp.io.IOOperation;

public abstract class SeqAnalysisBase
extends AbstractDataAdapter
implements SeqAnalysisI,
AnalysisDataAdapterI {
    protected SequenceI sequence;
    protected CurationSet curationSet;
    private Hashtable properties;
    private Hashtable propertyDescriptions;
    private Hashtable propertyTypes;
    private Hashtable defaultProperties;
    private Hashtable allowedValues;
    private Vector allowedProperties;
    protected Hashtable rawResults;
    IOOperation[] supportedOperations = new IOOperation[]{AnalysisDataAdapterI.OP_ANALYZE_DATA};

    public SeqAnalysisBase() {
        this.initSeqAnalysis();
    }

    public SeqAnalysisBase(Hashtable ht) {
        this.initSeqAnalysis();
        this.properties = ht;
    }

    public void init() {
    }

    protected void initSeqAnalysis() {
        this.properties = new Hashtable();
        this.propertyDescriptions = new Hashtable();
        this.propertyTypes = new Hashtable();
        this.defaultProperties = new Hashtable();
        this.allowedValues = new Hashtable();
        this.allowedProperties = new Vector();
        this.rawResults = new Hashtable();
    }

    public IOOperation[] getSupportedOperations() {
        return this.supportedOperations;
    }

    public void addProperty(String name, String value) {
        if (value != null && !value.equals("")) {
            this.properties.put(name, value);
        }
    }

    public String getProperty(String name) {
        if (this.properties.get(name) != null) {
            return (String)this.properties.get(name);
        }
        return null;
    }

    public Hashtable getProperties() {
        return this.properties;
    }

    public Vector getAllowedProperties() {
        return this.allowedProperties;
    }

    protected void setAllowedProperties(Vector in) {
        this.allowedProperties = in;
    }

    public String getPropertyDescription(String name) {
        if (this.propertyDescriptions.get(name) != null) {
            return (String)this.propertyDescriptions.get(name);
        }
        return null;
    }

    protected void setPropertyDescription(String name, String desc) {
        this.propertyDescriptions.put(name, desc);
    }

    public String getPropertyType(String name) {
        if (this.propertyTypes.get(name) != null) {
            return (String)this.propertyTypes.get(name);
        }
        return null;
    }

    protected void setPropertyType(String name, String type) {
        this.propertyTypes.put(name, type);
    }

    public Vector getAllowedValues(String name) {
        if (this.allowedValues.get(name) != null) {
            return (Vector)this.allowedValues.get(name);
        }
        return null;
    }

    protected void setAllowedValues(Hashtable in) {
        this.allowedValues = in;
    }

    protected void setAllowedValues(String name, Vector in) {
        this.allowedValues.put(name, in);
    }

    public String getName() {
        return this.getProperty("name");
    }

    public String getType() {
        return this.getProperty("name");
    }

    public void setName(String name) {
        this.addProperty("name", name);
    }

    public String getDesc() {
        return this.getProperty("desc");
    }

    public void setDesc(String desc) {
        this.addProperty("desc", desc);
    }

    public String getProgramName() {
        return this.getProperty("programName");
    }

    protected String getProgramParams() {
        return this.getProperty("programParams");
    }

    public SequenceI getInputSequence() {
        return null;
    }

    public void setInputSequence(SequenceI inseq) {
        this.sequence = inseq;
    }

    public Vector getInputSequences() {
        return null;
    }

    public void setInputSequence(Vector sequences) {
    }

    public int getInputSequenceCount() {
        return 1;
    }

    public boolean isAsynchronous() {
        String v = this.getProperty("isAsynchronous");
        return v != null && !v.equals("");
    }

    public boolean launch() {
        return false;
    }

    public boolean isStarted() {
        String v = this.getProperty("isStarted");
        return v != null;
    }

    public boolean isFinished() {
        String v = this.getProperty("isFinished");
        return v != null;
    }

    public boolean hasResults() {
        String v = this.getProperty("isFinished");
        return v.equals("true");
    }

    public CurationSet getCurationSet() {
        return this.curationSet;
    }

    public FeatureSet getFeatureSet() {
        return null;
    }

    public String getAllRawResults() {
        return (String)this.rawResults.get("out");
    }

    public Vector getRawResultVector() {
        Vector<String> v = new Vector<String>();
        v.addElement((String)this.rawResults.get("out"));
        return v;
    }

    public Hashtable getRawResultHashtable() {
        return this.rawResults;
    }

    protected void setRawResultHashtable(Hashtable in) {
        this.rawResults = in;
    }
}

