/*
 * Decompiled with CFR 0.152.
 */
package apollo.analysis;

import apollo.analysis.HashDB;
import apollo.datamodel.Sequence;
import apollo.datamodel.SequenceI;
import apollo.seq.io.FastaFile;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Vector;
import org.bdgp.util.DNAUtils;

public class HashMatch {
    HashDB hash;
    SequenceI seq;

    public HashMatch(SequenceI seq, HashDB hash) {
        this.hash = hash;
        this.seq = seq;
    }

    public void run() {
        long start = System.currentTimeMillis();
        this.hash.run();
        long end = System.currentTimeMillis();
        System.out.println("Time for hash " + (end - start + 1L) / 1000L);
        this.matchSeq(this.seq);
    }

    public void matchSeq(SequenceI seq) {
        long start = System.currentTimeMillis();
        int wordsize = this.hash.getWordSize() - 1;
        for (int i = 1; i < seq.getLength(); ++i) {
            String str;
            Vector pos;
            int end = i + wordsize;
            if (end >= seq.getLength() || (pos = this.hash.getPositions(str = seq.getResidues(i, end))) == null) continue;
            for (int j = 0; j < pos.size(); ++j) {
                int hashpos = (Integer)pos.elementAt(j);
                System.out.println(seq.getName() + "\thash\tsimilarity\t" + i + "\t" + (i + wordsize - 1) + "\t100\t1\t.\t" + "hit\t" + hashpos + "\t" + (hashpos + wordsize - 1) + "\n");
            }
        }
        String rev = DNAUtils.reverseComplement((String)seq.getResidues());
        for (int i = 0; i < rev.length(); ++i) {
            String str;
            Vector pos;
            int end = i + wordsize;
            if (end >= rev.length() || (pos = this.hash.getPositions(str = rev.substring(i, end + 1))) == null) continue;
            for (int j = 0; j < pos.size(); ++j) {
                int hashpos = (Integer)pos.elementAt(j);
                System.out.println(seq.getName() + "\thash\tsimilarity\t" + (seq.getLength() - i - wordsize + 1) + "\t" + (seq.getLength() - i) + "\t100\t-1\t.\t" + "hit\t" + hashpos + "\t" + (hashpos + wordsize - 1) + "\n");
            }
        }
        long end = System.currentTimeMillis();
        System.out.println("Time for match " + (double)(end - start + 1L) / 1000.0);
    }

    public static void main(String[] args) {
        try {
            DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(args[0])));
            HashDB hashdb = new HashDB(dis);
            hashdb.setWordSize(Integer.parseInt(args[1]));
            DataInputStream dis2 = new DataInputStream(new BufferedInputStream(new FileInputStream(args[2])));
            FastaFile ff = new FastaFile(dis2, false);
            for (int i = 0; i < ff.getSeqs().size(); ++i) {
                Sequence seq = (Sequence)ff.getSeqs().elementAt(0);
                HashMatch hm = new HashMatch(seq, hashdb);
                hm.run();
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Exception " + e);
        }
    }
}

