/*
 * Decompiled with CFR 0.152.
 */
package apollo.analysis;

import apollo.analysis.ProgramHandlerI;
import apollo.analysis.SeqAnalysisI;
import apollo.analysis.SeqAnalysisLocal;
import apollo.datamodel.CurationSet;

public class GenericProgramHandler
implements ProgramHandlerI {
    public String createUnixShellCommand(SeqAnalysisLocal seqAnalysis) {
        String path = seqAnalysis.getProperty("programName");
        String dbpath = seqAnalysis.getProperty("datasourcePath");
        if (dbpath == null) {
            String dbdir = seqAnalysis.getProperty("datasourceDir");
            String dbname = seqAnalysis.getProperty("datasourceName");
            dbpath = dbdir == null ? dbname : dbdir + "/" + dbname;
        }
        if (dbpath == null) {
            dbpath = "";
        }
        String cmd = "";
        String seqpath = seqAnalysis.getSeqFile();
        try {
            String args = seqAnalysis.getProperty("programParams");
            if (args == null) {
                args = "";
            }
            cmd = path + " " + args + " " + seqpath + " " + dbpath;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cmd;
    }

    public CurationSet parseAnalysisResults(SeqAnalysisI seqAnalysis) {
        System.out.println("not implementated!");
        return null;
    }
}

