/* sql-schema.c generated by valac 0.14.0, the Vala compiler
 * generated from sql-schema.vala, do not modify */

/* sql-schema.vala
 *
 * Copyright © 2011 Collabora Ltd.
 *             By Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 * Copyright © 2011 Canonical Ltd.
 *             By Michal Hruby <michal.hruby@canonical.com>
 *
 * Based upon a Python implementation (2009-2011) by:
 *  Markus Korn <thekorn@gmx.net>
 *  Mikkel Kamstrup Erlandsen <mikkel.kamstrup@gmail.com>
 *  Seif Lotfy <seif@lotfy.com>
 *  Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <sqlite3.h>


#define ZEITGEIST_SQ_LITE_TYPE_DATABASE_SCHEMA (zeitgeist_sq_lite_database_schema_get_type ())
#define ZEITGEIST_SQ_LITE_DATABASE_SCHEMA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_SQ_LITE_TYPE_DATABASE_SCHEMA, ZeitgeistSQLiteDatabaseSchema))
#define ZEITGEIST_SQ_LITE_DATABASE_SCHEMA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_SQ_LITE_TYPE_DATABASE_SCHEMA, ZeitgeistSQLiteDatabaseSchemaClass))
#define ZEITGEIST_SQ_LITE_IS_DATABASE_SCHEMA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_SQ_LITE_TYPE_DATABASE_SCHEMA))
#define ZEITGEIST_SQ_LITE_IS_DATABASE_SCHEMA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_SQ_LITE_TYPE_DATABASE_SCHEMA))
#define ZEITGEIST_SQ_LITE_DATABASE_SCHEMA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_SQ_LITE_TYPE_DATABASE_SCHEMA, ZeitgeistSQLiteDatabaseSchemaClass))

typedef struct _ZeitgeistSQLiteDatabaseSchema ZeitgeistSQLiteDatabaseSchema;
typedef struct _ZeitgeistSQLiteDatabaseSchemaClass ZeitgeistSQLiteDatabaseSchemaClass;
typedef struct _ZeitgeistSQLiteDatabaseSchemaPrivate ZeitgeistSQLiteDatabaseSchemaPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block3Data Block3Data;

struct _ZeitgeistSQLiteDatabaseSchema {
	GObject parent_instance;
	ZeitgeistSQLiteDatabaseSchemaPrivate * priv;
};

struct _ZeitgeistSQLiteDatabaseSchemaClass {
	GObjectClass parent_class;
};

typedef enum  {
	ZEITGEIST_ENGINE_ERROR_DATABASE_ERROR,
	ZEITGEIST_ENGINE_ERROR_INVALID_ARGUMENT,
	ZEITGEIST_ENGINE_ERROR_INVALID_KEY,
	ZEITGEIST_ENGINE_ERROR_BACKUP_FAILED
} ZeitgeistEngineError;
#define ZEITGEIST_ENGINE_ERROR zeitgeist_engine_error_quark ()
struct _Block3Data {
	int _ref_count_;
	gint schema_version;
};


static gpointer zeitgeist_sq_lite_database_schema_parent_class = NULL;

GType zeitgeist_sq_lite_database_schema_get_type (void) G_GNUC_CONST;
enum  {
	ZEITGEIST_SQ_LITE_DATABASE_SCHEMA_DUMMY_PROPERTY
};
#define ZEITGEIST_SQ_LITE_DATABASE_SCHEMA_CORE_SCHEMA "core"
#define ZEITGEIST_SQ_LITE_DATABASE_SCHEMA_CORE_SCHEMA_VERSION 5
GQuark zeitgeist_engine_error_quark (void);
void zeitgeist_sq_lite_database_schema_ensure_schema (sqlite3* database, GError** error);
gboolean zeitgeist_utils_using_in_memory_database (void);
static gint zeitgeist_sq_lite_database_schema_get_schema_version (sqlite3* database);
void zeitgeist_sq_lite_database_schema_create_schema (sqlite3* database, GError** error);
void zeitgeist_utils_backup_database (GError** error);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
static gint __lambda0_ (Block3Data* _data3_, gint n_cols, gchar** values, int values_length1, gchar** column_names, int column_names_length1);
static gint ___lambda0__sqlite3_callback (gpointer self, gint n_columns, gchar** values, gchar** column_names);
static void zeitgeist_sq_lite_database_schema_exec_query (sqlite3* database, const gchar* sql, GError** error);
ZeitgeistSQLiteDatabaseSchema* zeitgeist_sq_lite_database_schema_new (void);
ZeitgeistSQLiteDatabaseSchema* zeitgeist_sq_lite_database_schema_construct (GType object_type);


void zeitgeist_sq_lite_database_schema_ensure_schema (sqlite3* database, GError** error) {
	gint _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	gint _tmp4_;
	gint schema_version;
	gint _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (database != NULL);
	_tmp1_ = zeitgeist_utils_using_in_memory_database ();
	if (_tmp1_) {
		_tmp0_ = -1;
	} else {
		sqlite3* _tmp2_;
		gint _tmp3_ = 0;
		_tmp2_ = database;
		_tmp3_ = zeitgeist_sq_lite_database_schema_get_schema_version (_tmp2_);
		_tmp0_ = _tmp3_;
	}
	_tmp4_ = _tmp0_;
	schema_version = _tmp4_;
	_tmp5_ = schema_version;
	if (_tmp5_ == (-1)) {
		sqlite3* _tmp6_;
		_tmp6_ = database;
		zeitgeist_sq_lite_database_schema_create_schema (_tmp6_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	} else {
		gint _tmp7_;
		_tmp7_ = schema_version;
		if (_tmp7_ == 4) {
			sqlite3* _tmp13_;
			{
				zeitgeist_utils_backup_database (&_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch12_g_error;
				}
			}
			goto __finally12;
			__catch12_g_error:
			{
				GError* backup_error = NULL;
				GError* _tmp8_;
				const gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* msg;
				const gchar* _tmp11_;
				GError* _tmp12_;
				backup_error = _inner_error_;
				_inner_error_ = NULL;
				_tmp8_ = backup_error;
				_tmp9_ = _tmp8_->message;
				_tmp10_ = g_strconcat ("Database backup failed: ", _tmp9_, NULL);
				msg = _tmp10_;
				_tmp11_ = msg;
				_tmp12_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_BACKUP_FAILED, _tmp11_);
				_inner_error_ = _tmp12_;
				_g_free0 (msg);
				_g_error_free0 (backup_error);
				goto __finally12;
			}
			__finally12:
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_tmp13_ = database;
			zeitgeist_sq_lite_database_schema_create_schema (_tmp13_, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		} else {
			gint _tmp14_;
			_tmp14_ = schema_version;
			if (_tmp14_ < ZEITGEIST_SQ_LITE_DATABASE_SCHEMA_CORE_SCHEMA_VERSION) {
				gint _tmp15_;
				gchar* _tmp16_ = NULL;
				gchar* _tmp17_;
				GError* _tmp18_;
				GError* _tmp19_;
				_tmp15_ = schema_version;
				_tmp16_ = g_strdup_printf ("Unable to upgrade from schema version %d", _tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_ERROR, _tmp17_);
				_tmp19_ = _tmp18_;
				_g_free0 (_tmp17_);
				_inner_error_ = _tmp19_;
				if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
	}
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (Block3Data* _data3_) {
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		g_slice_free (Block3Data, _data3_);
	}
}


static gint _sqlite3_exec (sqlite3* self, const gchar* sql, sqlite3_callback callback, void* callback_target, gchar** errmsg) {
	gchar* _vala_errmsg = NULL;
	gint result = 0;
	const gchar* sqlite_errmsg = NULL;
	const gchar* _tmp0_;
	sqlite3_callback _tmp1_;
	void* _tmp1__target;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint ec;
	const gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_tmp0_ = sql;
	_tmp1_ = callback;
	_tmp1__target = callback_target;
	_tmp3_ = sqlite3_exec (self, _tmp0_, _tmp1_, _tmp1__target, (char**) (&_tmp2_));
	sqlite_errmsg = _tmp2_;
	ec = _tmp3_;
	if ((&_vala_errmsg) != NULL) {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = sqlite_errmsg;
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (_vala_errmsg);
		_vala_errmsg = _tmp5_;
	}
	_tmp6_ = sqlite_errmsg;
	sqlite3_free ((void*) _tmp6_);
	result = ec;
	if (errmsg) {
		*errmsg = _vala_errmsg;
	} else {
		_g_free0 (_vala_errmsg);
	}
	return result;
}


static gint __lambda0_ (Block3Data* _data3_, gint n_cols, gchar** values, int values_length1, gchar** column_names, int column_names_length1) {
	gint result = 0;
	gchar** _tmp0_;
	gint _tmp0__length1;
	const gchar* _tmp1_;
	_tmp0_ = values;
	_tmp0__length1 = values_length1;
	_tmp1_ = _tmp0_[0];
	if (_tmp1_ != NULL) {
		gchar** _tmp2_;
		gint _tmp2__length1;
		const gchar* _tmp3_;
		gint _tmp4_ = 0;
		_tmp2_ = values;
		_tmp2__length1 = values_length1;
		_tmp3_ = _tmp2_[0];
		_tmp4_ = atoi (_tmp3_);
		_data3_->schema_version = _tmp4_;
	}
	result = 0;
	return result;
}


static gint ___lambda0__sqlite3_callback (gpointer self, gint n_columns, gchar** values, gchar** column_names) {
	gint result;
	result = __lambda0_ (self, n_columns, values, -1, column_names, -1);
	return result;
}


static gint zeitgeist_sq_lite_database_schema_get_schema_version (sqlite3* database) {
	gint result = 0;
	Block3Data* _data3_;
	gchar* _tmp0_;
	gchar* sql;
	sqlite3* _tmp1_;
	g_return_val_if_fail (database != NULL, 0);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_tmp0_ = g_strdup ("SELECT version FROM schema_version WHERE schema='core'");
	sql = _tmp0_;
	_data3_->schema_version = -1;
	_tmp1_ = database;
	_sqlite3_exec (_tmp1_, sql, ___lambda0__sqlite3_callback, _data3_, NULL);
	g_debug ("sql-schema.vala:89: schema_version is %d", _data3_->schema_version);
	result = _data3_->schema_version;
	_g_free0 (sql);
	block3_data_unref (_data3_);
	_data3_ = NULL;
	return result;
}


void zeitgeist_sq_lite_database_schema_create_schema (sqlite3* database, GError** error) {
	sqlite3* _tmp0_;
	sqlite3* _tmp1_;
	sqlite3* _tmp2_;
	sqlite3* _tmp3_;
	sqlite3* _tmp4_;
	sqlite3* _tmp5_;
	sqlite3* _tmp6_;
	sqlite3* _tmp7_;
	sqlite3* _tmp8_;
	sqlite3* _tmp9_;
	sqlite3* _tmp10_;
	sqlite3* _tmp11_;
	sqlite3* _tmp12_;
	sqlite3* _tmp13_;
	sqlite3* _tmp14_;
	sqlite3* _tmp15_;
	sqlite3* _tmp16_;
	sqlite3* _tmp17_;
	sqlite3* _tmp18_;
	sqlite3* _tmp19_;
	sqlite3* _tmp20_;
	sqlite3* _tmp21_;
	sqlite3* _tmp22_;
	sqlite3* _tmp23_;
	sqlite3* _tmp24_;
	sqlite3* _tmp25_;
	sqlite3* _tmp26_;
	sqlite3* _tmp27_;
	sqlite3* _tmp28_;
	sqlite3* _tmp29_;
	sqlite3* _tmp30_;
	sqlite3* _tmp31_;
	sqlite3* _tmp32_;
	sqlite3* _tmp33_;
	sqlite3* _tmp34_;
	sqlite3* _tmp35_;
	gchar* _tmp36_ = NULL;
	gchar* schema_sql;
	sqlite3* _tmp37_;
	const gchar* _tmp38_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (database != NULL);
	_tmp0_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp0_, "PRAGMA journal_mode = WAL", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp1_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp1_, "\n" \
"                CREATE TABLE IF NOT EXISTS uri (\n" \
"                    id INTEGER PRIMARY KEY,\n" \
"                    value VARCHAR UNIQUE\n" \
"                )\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp2_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp2_, "\n" \
"                CREATE UNIQUE INDEX IF NOT EXISTS uri_value ON uri(val" \
"ue)\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp3_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp3_, "\n" \
"                CREATE TABLE IF NOT EXISTS interpretation (\n" \
"                    id INTEGER PRIMARY KEY,\n" \
"                    value VARCHAR UNIQUE\n" \
"                )\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp4_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp4_, "\n" \
"                CREATE UNIQUE INDEX IF NOT EXISTS interpretation_value" \
"\n" \
"                    ON interpretation(value)\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp5_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp5_, "\n" \
"                CREATE TABLE IF NOT EXISTS manifestation (\n" \
"                    id INTEGER PRIMARY KEY,\n" \
"                    value VARCHAR UNIQUE\n" \
"                )\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp6_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp6_, "\n" \
"                CREATE UNIQUE INDEX IF NOT EXISTS manifestation_value\n" \
"                    ON manifestation(value)\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp7_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp7_, "\n" \
"                CREATE TABLE IF NOT EXISTS mimetype (\n" \
"                    id INTEGER PRIMARY KEY,\n" \
"                    value VARCHAR UNIQUE\n" \
"                )\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp8_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp8_, "\n" \
"                CREATE UNIQUE INDEX IF NOT EXISTS mimetype_value\n" \
"                    ON mimetype(value)\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp9_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp9_, "\n" \
"                CREATE TABLE IF NOT EXISTS actor (\n" \
"                    id INTEGER PRIMARY KEY,\n" \
"                    value VARCHAR UNIQUE\n" \
"                )\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp10_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp10_, "\n" \
"                CREATE UNIQUE INDEX IF NOT EXISTS actor_value\n" \
"                    ON actor(value)\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp11_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp11_, "\n" \
"                CREATE TABLE IF NOT EXISTS text (\n" \
"                    id INTEGER PRIMARY KEY,\n" \
"                    value VARCHAR UNIQUE\n" \
"                )\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp12_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp12_, "\n" \
"                CREATE UNIQUE INDEX IF NOT EXISTS text_value\n" \
"                    ON text(value)\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp13_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp13_, "\n" \
"                CREATE TABLE IF NOT EXISTS payload\n" \
"                    (id INTEGER PRIMARY KEY, value BLOB)\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp14_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp14_, "\n" \
"                CREATE TABLE IF NOT EXISTS storage (\n" \
"                    id INTEGER PRIMARY KEY,\n" \
"                    value VARCHAR UNIQUE,\n" \
"                    state INTEGER,\n" \
"                    icon VARCHAR,\n" \
"                    display_name VARCHAR\n" \
"                )\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp15_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp15_, "\n" \
"                CREATE UNIQUE INDEX IF NOT EXISTS storage_value\n" \
"                    ON storage(value)\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp16_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp16_, "\n" \
"                CREATE TABLE IF NOT EXISTS event (\n" \
"                    id INTEGER,\n" \
"                    timestamp INTEGER,\n" \
"                    interpretation INTEGER,\n" \
"                    manifestation INTEGER,\n" \
"                    actor INTEGER,\n" \
"                    payload INTEGER,\n" \
"                    subj_id INTEGER,\n" \
"                    subj_interpretation INTEGER,\n" \
"                    subj_manifestation INTEGER,\n" \
"                    subj_origin INTEGER,\n" \
"                    subj_mimetype INTEGER,\n" \
"                    subj_text INTEGER,\n" \
"                    subj_storage INTEGER,\n" \
"                    origin INTEGER,\n" \
"                    subj_id_current INTEGER,\n" \
"                    CONSTRAINT interpretation_fk\n" \
"                        FOREIGN KEY(interpretation)\n" \
"                        REFERENCES interpretation(id)\n" \
"                        ON DELETE CASCADE,\n" \
"                    CONSTRAINT manifestation_fk\n" \
"                        FOREIGN KEY(manifestation)\n" \
"                        REFERENCES manifestation(id)\n" \
"                        ON DELETE CASCADE,\n" \
"                    CONSTRAINT actor_fk\n" \
"                        FOREIGN KEY(actor)\n" \
"                        REFERENCES actor(id)\n" \
"                        ON DELETE CASCADE,\n" \
"                    CONSTRAINT origin_fk\n" \
"                        FOREIGN KEY(origin)\n" \
"                        REFERENCES uri(id)\n" \
"                        ON DELETE CASCADE,\n" \
"                    CONSTRAINT payload_fk\n" \
"                        FOREIGN KEY(payload)\n" \
"                        REFERENCES payload(id)\n" \
"                        ON DELETE CASCADE,\n" \
"                    CONSTRAINT subj_id_fk\n" \
"                        FOREIGN KEY(subj_id)\n" \
"                        REFERENCES uri(id)\n" \
"                        ON DELETE CASCADE,\n" \
"                    CONSTRAINT subj_id_current_fk\n" \
"                        FOREIGN KEY(subj_id_current)\n" \
"                        REFERENCES uri(id)\n" \
"                        ON DELETE CASCADE,\n" \
"                    CONSTRAINT subj_interpretation_fk\n" \
"                        FOREIGN KEY(subj_interpretation)\n" \
"                        REFERENCES interpretation(id)\n" \
"                        ON DELETE CASCADE,\n" \
"                    CONSTRAINT subj_manifestation_fk\n" \
"                        FOREIGN KEY(subj_manifestation)\n" \
"                        REFERENCES manifestation(id)\n" \
"                        ON DELETE CASCADE,\n" \
"                    CONSTRAINT subj_origin_fk\n" \
"                        FOREIGN KEY(subj_origin)\n" \
"                        REFERENCES uri(id)\n" \
"                        ON DELETE CASCADE,\n" \
"                    CONSTRAINT subj_mimetype_fk\n" \
"                        FOREIGN KEY(subj_mimetype)\n" \
"                        REFERENCES mimetype(id)\n" \
"                        ON DELETE CASCADE,\n" \
"                    CONSTRAINT subj_text_fk\n" \
"                        FOREIGN KEY(subj_text)\n" \
"                        REFERENCES text(id)\n" \
"                        ON DELETE CASCADE,\n" \
"                    CONSTRAINT subj_storage_fk\n" \
"                        FOREIGN KEY(subj_storage)\n" \
"                        REFERENCES storage(id)\n" \
"                        ON DELETE CASCADE,\n" \
"                    CONSTRAINT unique_event UNIQUE (timestamp, interpr" \
"etation,\n" \
"                        manifestation, actor, subj_id)\n" \
"                )\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp17_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp17_, "\n" \
"                CREATE INDEX IF NOT EXISTS event_id\n" \
"                    ON event(id)\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp18_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp18_, "\n" \
"                CREATE INDEX IF NOT EXISTS event_timestamp\n" \
"                    ON event(timestamp)\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp19_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp19_, "\n" \
"                CREATE INDEX IF NOT EXISTS event_interpretation\n" \
"                    ON event(interpretation)\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp20_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp20_, "\n" \
"                CREATE INDEX IF NOT EXISTS event_manifestation\n" \
"                    ON event(manifestation)\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp21_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp21_, "\n" \
"                CREATE INDEX IF NOT EXISTS event_actor\n" \
"                    ON event(actor)\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp22_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp22_, "\n" \
"                CREATE INDEX IF NOT EXISTS event_origin\n" \
"                    ON event(origin)\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp23_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp23_, "\n" \
"                CREATE INDEX IF NOT EXISTS event_subj_id\n" \
"                    ON event(subj_id)\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp24_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp24_, "\n" \
"                CREATE INDEX IF NOT EXISTS event_subj_id_current\n" \
"                    ON event(subj_id_current)\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp25_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp25_, "\n" \
"                CREATE INDEX IF NOT EXISTS event_subj_interpretation\n" \
"                    ON event(subj_interpretation)\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp26_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp26_, "\n" \
"                CREATE INDEX IF NOT EXISTS event_subj_manifestation\n" \
"                    ON event(subj_manifestation)\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp27_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp27_, "\n" \
"                CREATE INDEX IF NOT EXISTS event_subj_origin\n" \
"                    ON event(subj_origin)\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp28_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp28_, "\n" \
"                CREATE INDEX IF NOT EXISTS event_subj_mimetype\n" \
"                    ON event(subj_mimetype)\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp29_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp29_, "\n" \
"                CREATE INDEX IF NOT EXISTS event_subj_text\n" \
"                    ON event(subj_text)\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp30_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp30_, "\n" \
"                CREATE INDEX IF NOT EXISTS event_subj_storage\n" \
"                    ON event(subj_storage)\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp31_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp31_, "\n" \
"                CREATE TABLE IF NOT EXISTS extensions_conf (\n" \
"                    extension VARCHAR,\n" \
"                    key VARCHAR,\n" \
"                    value BLOB,\n" \
"                    CONSTRAINT unique_extension UNIQUE (extension, key" \
")\n" \
"                )\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp32_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp32_, "\n" \
"                CREATE UNIQUE INDEX IF NOT EXISTS extensions_conf_key\n" \
"                    ON extensions_conf (extension, key)\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp33_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp33_, "DROP VIEW IF EXISTS event_view", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp34_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp34_, "\n" \
"                CREATE VIEW IF NOT EXISTS event_view AS\n" \
"                    SELECT event.id,\n" \
"                        event.timestamp,\n" \
"                        event.interpretation,\n" \
"                        event.manifestation,\n" \
"                        event.actor,\n" \
"                        (SELECT value FROM payload\n" \
"                            WHERE payload.id=event.payload)\n" \
"                            AS payload,\n" \
"                        (SELECT value FROM uri\n" \
"                            WHERE uri.id=event.subj_id)\n" \
"                            AS subj_uri,\n" \
"                        event.subj_id, --//this points to an id in the" \
" uri table\n" \
"                        event.subj_interpretation,\n" \
"                        event.subj_manifestation,\n" \
"                        event.subj_origin,\n" \
"                        (SELECT value FROM uri\n" \
"                            WHERE uri.id=event.subj_origin)\n" \
"                            AS subj_origin_uri,\n" \
"                        event.subj_mimetype,\n" \
"                        (SELECT value FROM text\n" \
"                            WHERE text.id = event.subj_text)\n" \
"                            AS subj_text,\n" \
"                        (SELECT value FROM storage\n" \
"                            WHERE storage.id=event.subj_storage)\n" \
"                            AS subj_storage,\n" \
"                        (SELECT state FROM storage\n" \
"                            WHERE storage.id=event.subj_storage)\n" \
"                            AS subj_storage_state,\n" \
"                        event.origin,\n" \
"                        (SELECT value FROM uri\n" \
"                            WHERE uri.id=event.origin)\n" \
"                            AS event_origin_uri,\n" \
"                        (SELECT value FROM uri\n" \
"                            WHERE uri.id=event.subj_id_current)\n" \
"                            AS subj_current_uri,\n" \
"                        event.subj_id_current,\n" \
"                        event.subj_text AS subj_text_id,\n" \
"                        event.subj_storage AS subj_storage_id,\n" \
"                        (SELECT value FROM actor\n" \
"                            WHERE actor.id=event.actor)\n" \
"                            AS actor_uri\n" \
"                    FROM event\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp35_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp35_, "\n" \
"                CREATE TABLE IF NOT EXISTS schema_version (\n" \
"                    schema VARCHAR PRIMARY KEY ON CONFLICT REPLACE,\n" \
"                    version INT\n" \
"                )\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp36_ = g_strdup_printf ("INSERT INTO schema_version VALUES ('%s', %d)", ZEITGEIST_SQ_LITE_DATABASE_SCHEMA_CORE_SCHEMA, ZEITGEIST_SQ_LITE_DATABASE_SCHEMA_CORE_SCHEMA_VERSION);
	schema_sql = _tmp36_;
	_tmp37_ = database;
	_tmp38_ = schema_sql;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp37_, _tmp38_, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (schema_sql);
			return;
		} else {
			_g_free0 (schema_sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_free0 (schema_sql);
}


/**
         * Execute the given SQL. If the query doesn't succeed, log a
         * critical warning (potentially aborting the program).
         *
         * @param database the database on which to run the query
         * @param sql the SQL query to run
         */
static void zeitgeist_sq_lite_database_schema_exec_query (sqlite3* database, const gchar* sql, GError** error) {
	sqlite3* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_ = 0;
	gint rc;
	gint _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (database != NULL);
	g_return_if_fail (sql != NULL);
	_tmp0_ = database;
	_tmp1_ = sql;
	_tmp2_ = _sqlite3_exec (_tmp0_, _tmp1_, NULL, NULL, NULL);
	rc = _tmp2_;
	_tmp3_ = rc;
	if (_tmp3_ != SQLITE_OK) {
		static const char fmt_str[] = "Can't create database: %d, %s\n\n" "Unable to execute SQL:\n%s";
		gint _tmp4_;
		sqlite3* _tmp5_;
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_;
		gchar* _tmp8_ = NULL;
		gchar* err_msg;
		const gchar* _tmp9_;
		GError* _tmp10_;
		_tmp4_ = rc;
		_tmp5_ = database;
		_tmp6_ = sqlite3_errmsg (_tmp5_);
		_tmp7_ = sql;
		_tmp8_ = g_strdup_printf (fmt_str, _tmp4_, _tmp6_, _tmp7_);
		err_msg = _tmp8_;
		_tmp9_ = err_msg;
		_tmp10_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_ERROR, _tmp9_);
		_inner_error_ = _tmp10_;
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (err_msg);
			return;
		} else {
			_g_free0 (err_msg);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_free0 (err_msg);
	}
}


ZeitgeistSQLiteDatabaseSchema* zeitgeist_sq_lite_database_schema_construct (GType object_type) {
	ZeitgeistSQLiteDatabaseSchema * self = NULL;
	self = (ZeitgeistSQLiteDatabaseSchema*) g_object_new (object_type, NULL);
	return self;
}


ZeitgeistSQLiteDatabaseSchema* zeitgeist_sq_lite_database_schema_new (void) {
	return zeitgeist_sq_lite_database_schema_construct (ZEITGEIST_SQ_LITE_TYPE_DATABASE_SCHEMA);
}


static void zeitgeist_sq_lite_database_schema_class_init (ZeitgeistSQLiteDatabaseSchemaClass * klass) {
	zeitgeist_sq_lite_database_schema_parent_class = g_type_class_peek_parent (klass);
}


static void zeitgeist_sq_lite_database_schema_instance_init (ZeitgeistSQLiteDatabaseSchema * self) {
}


GType zeitgeist_sq_lite_database_schema_get_type (void) {
	static volatile gsize zeitgeist_sq_lite_database_schema_type_id__volatile = 0;
	if (g_once_init_enter (&zeitgeist_sq_lite_database_schema_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistSQLiteDatabaseSchemaClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_sq_lite_database_schema_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistSQLiteDatabaseSchema), 0, (GInstanceInitFunc) zeitgeist_sq_lite_database_schema_instance_init, NULL };
		GType zeitgeist_sq_lite_database_schema_type_id;
		zeitgeist_sq_lite_database_schema_type_id = g_type_register_static (G_TYPE_OBJECT, "ZeitgeistSQLiteDatabaseSchema", &g_define_type_info, 0);
		g_once_init_leave (&zeitgeist_sq_lite_database_schema_type_id__volatile, zeitgeist_sq_lite_database_schema_type_id);
	}
	return zeitgeist_sq_lite_database_schema_type_id__volatile;
}



