/*
 * Zaz
 * Copyright (C) Remigiusz Dybka 2009 <remigiusz.dybka@gmail.com>
 *
 Zaz is free software: you can redistribute it and/or modify it
 under the terms of the GNU General Public License as published by the
 Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 Zaz is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along
 with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <sstream>
#include <fstream>
#include <iostream>
#include "hiscores.h"
#include "error.h"
#include "common.h"

using namespace std;

namespace Scenes
{

    HiScores::HiScores(string filename)
            : filename(filename)
    {
        ifstream inph(filename.c_str());
        if (!inph) // may be empty or not exist
            return;

        string l;
        while (!getline(inph, l).fail())
        {
            int score;
            string name;
            string level;
            istringstream sl;

            Strip(l);
            sl.clear();
            sl.str(l);
            sl >> score;

            bool ok = (!getline(inph, l).fail());
            Strip(l);
            name = l;

            ok = ok && (!getline(inph, l).fail());
            Strip(l);
            level = l;

            if (ok)
                scores.push_back(HiScoreEntry(score, name, level));
        }
        inph.close();
    }

    HiScores::~HiScores()
    {
        ofstream oph(filename.c_str());
        if (!oph) // very bad
        {
            ERR(filename + ": could not save hi scores");
        }

        vector<HiScoreEntry>::iterator i;

        int f = 0;
        for (i = scores.begin(); i != scores.end(); ++i)
        {
            if ((f < 10) && (i->score > 0))
            {
                oph << i->score << std::endl;
                oph << i->name << std::endl;
                oph << i->level << std::endl;
            }
            ++f;
        }

        oph.close();
    }

    void HiScores::SubmitHiScore(HiScoreEntry ent)
    {
        vector<HiScoreEntry>::iterator i;
        vector<HiScoreEntry>::iterator ii;

        ii = scores.begin();
        for (i = scores.begin(); i != scores.end(); ++i)
        {
            if (i->score > ent.score)
            {
                ii = i + 1;
            }
        }

        scores.insert(ii, ent);
    }

    bool HiScores::GoodEnough(int s)
    {
        vector<HiScoreEntry>::iterator i;

        if (s == 0)
            return false;

        if (scores.size() < 10)
            return true;

        int f = 0;
        for (i = scores.begin(); i != scores.end(); ++i)
        {
            if (f < 10)
            {
                if (i->score < s)
                    return true;
            }
            ++f;
        }

        return false;
    }
}
