/*
 *  XMail by Davide Libenzi ( Intranet and Internet mail server )
 *  Copyright (C) 1999,..,2004  Davide Libenzi
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  Davide Libenzi <davidel@xmailserver.org>
 *
 */

#ifndef _SSLBIND_H
#define _SSLBIND_H


#define BSSL_BIO_NAME "SSL"
#define BSSL_CERT_ISSUER 1
#define BSSL_CERT_SUBJECT 2

#define BSSLF_WANT_VERIFY (1 << 0)
#define BSSLF_WANT_CERT (1 << 1)
#define BSSLF_ALLOW_SEFLSIGNED (1 << 2)


struct SslServerBind {
	char *pszKeyFile;
	char *pszCertFile;
	unsigned long ulFlags;
	int iMaxDepth;
	char *pszCAFile;
	char *pszCAPath;
};

struct SslBindEnv {
	char *pszIssuer;
	char *pszSubject;
};


int BSslInit(void);
void BSslCleanup(void);
int BSslBindClient(BSOCK_HANDLE hBSock, SslServerBind const *pSSLB,
		   int (*pfEnvCB)(void *, int, void const *), void *pPrivate);
int BSslBindServer(BSOCK_HANDLE hBSock, SslServerBind const *pSSLB,
		   int (*pfEnvCB)(void *, int, void const *), void *pPrivate);

#endif

