/*                                   */
/* xemeraldia   ---- init-graphics.c */
/*                                   */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gdk/gdkkeysyms.h>

#include "graphics.h"
#include "bitmaps.h"

static void  createBWPixmaps(GdkDrawable *w, int depth), createColoredPixmaps(GdkDrawable *w, int depth);
static void  createGCs(GdkDrawable *), createCrushAnimePixmaps(GdkDrawable *w, int depth);

GtkWidget  *board_w, *nextItem_w, *quit, *start, *scores, *score_disp, *level_disp, *about;
GtkWidget  *score_frame, *score_text, *high_sc_w, *topLevel;
GdkGC *draw_gc, *delete_gc;
GdkPixmap  *block[BLOCK_VARIETY * 2 + 1], *crush[CRUSH_ANIME_FRAMES];
GdkPixmap  *board_pix, *star;
GdkColor     black, white;
int     colored;

void  initXlib (GdkDrawable *w)
{
	int     depth;
	GdkVisual *vi;

	gdk_color_black(gdk_colormap_get_system(), &black);
	gdk_color_white(gdk_colormap_get_system(), &white);

	vi = gdk_visual_get_system();
	depth = vi->depth;
	colored = ((depth != 1) && (vi->type != GDK_VISUAL_GRAYSCALE));

	board_pix = gdk_pixmap_new(w, WIN_WIDTH, WIN_HEIGHT, -1);
	createGCs (w);
	createCrushAnimePixmaps (w, depth);
	if (colored)
	  createColoredPixmaps (w, depth);
	else
	  createBWPixmaps (w, depth);
	clearNextItem ();
	clearScreen();


	animated_score_font = pango_font_description_from_string("New Century Schoolbook 20");
	pause_font = pango_font_description_from_string("New Century Schoolbook Bold Italic 22");
	game_over_font = pango_font_description_from_string("New Century Schoolbook Bold 10");
}

gboolean keyPressed(GtkWidget *widget G_GNUC_UNUSED,
	GdkEventKey *event G_GNUC_UNUSED,
	gpointer user_data G_GNUC_UNUSED)
{
	switch(event->keyval)
	{
		case GDK_K:
		case GDK_k:
		case GDK_I:
		case GDK_i:
		case GDK_Down:
		case GDK_Begin:
			Rotation();
			return TRUE;
		case GDK_Up:
		case GDK_J:
		case GDK_j:
			CCRotation();
			return TRUE;
		case GDK_Left:
		case GDK_H:
		case GDK_h:
		case GDK_U:
		case GDK_u:
			MoveLeft();
			return TRUE;
		case GDK_Right:
		case GDK_L:
		case GDK_l:
			MoveRight();
			return TRUE;
		case GDK_space:
			MoveDown();
			return TRUE;
		case GDK_S:
		case GDK_s:
		case GDK_P:
		case GDK_p:
		case GDK_Pause:
			StartGame();
			break;
		case GDK_Q:
		case GDK_q:
			Quit();
	}
	return FALSE;
}

void initGTK(GtkWidget *w)
{
	GtkWidget  *nextBox, *Score, *Level, *Next, *hbox, *vbox, *vbox2, *align, *frame, *framevbox, *x;

	g_signal_connect(G_OBJECT(w), "key-press-event", G_CALLBACK(keyPressed), NULL);

	hbox = gtk_hbox_new(FALSE, 2);
	gtk_container_add(GTK_CONTAINER(w), hbox);
	
	align = gtk_alignment_new(.5,.5,0,0);
	gtk_box_pack_start(GTK_BOX(hbox), align, TRUE, TRUE, 3);
	
	board_w = gtk_drawing_area_new();
	gtk_widget_set_size_request(board_w, WIN_WIDTH, WIN_HEIGHT);
	g_signal_connect (G_OBJECT (board_w), "expose_event",
		G_CALLBACK (RedrawBoard), NULL);
	gtk_container_add(GTK_CONTAINER(align), board_w);

	vbox = gtk_vbox_new(FALSE, 6);
	gtk_box_pack_start(GTK_BOX(hbox), vbox, TRUE, TRUE, 3);

	x = gtk_label_new(NULL);
	gtk_box_pack_start(GTK_BOX(vbox), x, FALSE, FALSE, 0);

	nextBox = gtk_frame_new(NULL);
	gtk_box_pack_start(GTK_BOX(vbox), nextBox, FALSE, FALSE, 0);

	vbox2 = gtk_vbox_new(FALSE, 1);
	gtk_container_add(GTK_CONTAINER(nextBox), vbox2);

	Next = gtk_label_new(NULL);
	gtk_label_set_markup(GTK_LABEL(Next), _("<b>NEXT</b>"));
	gtk_box_pack_start(GTK_BOX(vbox2), Next, TRUE, TRUE, 0);

	nextItem_w = gtk_drawing_area_new();
	gtk_widget_set_size_request(nextItem_w, BLOCK_WIDTH * 3, BLOCK_HEIGHT * 3);
	g_signal_connect (G_OBJECT (nextItem_w), "expose_event",
		G_CALLBACK (RedrawNextItem), NULL);
	gtk_box_pack_start(GTK_BOX(vbox2), nextItem_w, TRUE, TRUE, 0);

	frame = gtk_frame_new(NULL);
	gtk_box_pack_start(GTK_BOX(vbox), frame, FALSE, FALSE, 0);

	framevbox = gtk_vbox_new(FALSE, 2);
	gtk_container_add(GTK_CONTAINER(frame), framevbox);
	
	Score = gtk_label_new(NULL);
	gtk_label_set_markup(GTK_LABEL(Score), _("<b>SCORE</b>"));
	gtk_box_pack_start(GTK_BOX(framevbox), Score, TRUE, TRUE, 0);

	score_disp = gtk_label_new("      0");
	gtk_box_pack_start(GTK_BOX(framevbox), score_disp, TRUE, TRUE, 0);

	x = gtk_label_new(NULL);
	gtk_box_pack_start(GTK_BOX(framevbox), x, TRUE, TRUE, 0);

	Level = gtk_label_new(NULL);
	gtk_label_set_markup(GTK_LABEL(Level), _("<b>LEVEL</b>"));
	gtk_box_pack_start(GTK_BOX(framevbox), Level, TRUE, TRUE, 0);

	level_disp = gtk_label_new("      0");
	gtk_box_pack_start(GTK_BOX(framevbox), level_disp, TRUE, TRUE, 0);


	frame = gtk_alignment_new(.5,0.2,.9,.15);
	gtk_box_pack_start(GTK_BOX(vbox), frame, TRUE, TRUE, 0);

	framevbox = gtk_vbutton_box_new();
	gtk_container_add(GTK_CONTAINER(frame), framevbox);

	start = gtk_button_new_with_label(_("Start"));
/*  GTK_WIDGET_SET_FLAGS(start, GTK_CAN_DEFAULT); */
	gtk_box_pack_start(GTK_BOX(framevbox), start, TRUE, FALSE, 0);

	if(app_data.usescorefile)
	{
		scores = gtk_button_new_with_label(_("Scores"));
		gtk_box_pack_start(GTK_BOX(framevbox), scores, TRUE, FALSE, 0);
	}

#ifdef GTK_STOCK_ABOUT
	about = gtk_button_new_from_stock(GTK_STOCK_ABOUT);
#else
	about = gtk_button_new_with_label(_("About..."));
#endif
	gtk_box_pack_start(GTK_BOX(framevbox), about, TRUE, FALSE, 0);

	quit = gtk_button_new_from_stock(GTK_STOCK_QUIT);
	gtk_box_pack_start(GTK_BOX(framevbox), quit, TRUE, FALSE, 0);

/*
	frame = gtk_label_new(NULL);
	gtk_box_pack_start(GTK_BOX(vbox), frame, TRUE, FALSE, 0);
*/
}


static void  createGCs (GdkDrawable *w)
{
  GdkGCValues values;

  values.foreground  = white;
  values.background  = black;
  draw_gc = gdk_gc_new_with_values(w, &values, GDK_GC_FOREGROUND | GDK_GC_BACKGROUND);
  values.foreground  = black;
  values.background  = black;
  delete_gc = gdk_gc_new_with_values(w, &values, GDK_GC_FOREGROUND | GDK_GC_BACKGROUND);
}


static void  createBWPixmaps (GdkDrawable *w, int depth)
{
  int   i;
  const char *block_bits[BLOCK_VARIETY * 2 + 1];

  star = gdk_pixmap_create_from_data(w, star_bits, BLOCK_WIDTH, BLOCK_HEIGHT, depth, &white, &black);
  block_bits[1] = block1_bits;
  block_bits[2] = block2_bits;
  block_bits[3] = block3_bits;
  block_bits[4] = block4_bits;
  block_bits[5] = block5_bits;
  block_bits[6] = block6_bits;
  block_bits[7] = block1cr_bits;
  block_bits[8] = block2cr_bits;
  block_bits[9] = block3cr_bits;
  block_bits[10] = block4cr_bits;
  block_bits[11] = block5cr_bits;
  block_bits[12] = block6cr_bits;
  for (i = 1; i <= BLOCK_VARIETY * 2; i++)
    {
      block[i] = gdk_pixmap_create_from_data(w, block_bits[i],
                          BLOCK_WIDTH, BLOCK_HEIGHT, depth, &white, &black);
    }
}


static void  createColoredPixmaps (GdkDrawable *w, int depth)
{
  int   i;
  GdkColor block_pixel[BLOCK_VARIETY + 1];

  star = gdk_pixmap_create_from_data(w, star_bits, BLOCK_WIDTH, BLOCK_HEIGHT, depth, &app_data.starpixel, &black);
  block_pixel[1] = app_data.block1pixel;
  block_pixel[2] = app_data.block2pixel;
  block_pixel[3] = app_data.block3pixel;
  block_pixel[4] = app_data.block4pixel;
  block_pixel[5] = app_data.block5pixel;
  block_pixel[6] = app_data.block6pixel;
  for (i = 1; i <= BLOCK_VARIETY; i++)
      block[i] = gdk_pixmap_create_from_data(w, colorblock_bits,
                          BLOCK_WIDTH, BLOCK_HEIGHT, depth, &block_pixel[i], &black);
  for (i = BLOCK_VARIETY + 1; i <= BLOCK_VARIETY * 2; i++)
      block[i] = gdk_pixmap_create_from_data(w, colorblockcr_bits,
                          BLOCK_WIDTH, BLOCK_HEIGHT, depth, &block_pixel[i - BLOCK_VARIETY], &black);
}


static void  createCrushAnimePixmaps (GdkDrawable *w, int depth)
{
  int   i;
  const unsigned char *crush_bits[CRUSH_ANIME_FRAMES];

  crush_bits[0] = crush0_bits;
  crush_bits[1] = crush1_bits;
  crush_bits[2] = crush2_bits;
  crush_bits[3] = crush3_bits;
  crush_bits[4] = crush4_bits;
  for (i = 0; i < CRUSH_ANIME_FRAMES; i++)
    crush[i] = gdk_pixmap_create_from_data(w, (char*)crush_bits[i],
                          BLOCK_WIDTH, BLOCK_HEIGHT, depth, &white, &black);
}
