/*  Wordtrans, front-end for several dictionaries, for the Qt toolkit.
    Copyright (C) 2000-2004 Ricardo Villalba <rvm@escomposlinux.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "acercade.h"
#include "acercadeData.cpp"
#include "acercadeData.moc.cpp"

#include <qglobal.h>
#include <qapplication.h>
#include <qpixmap.h>
#include <qpalette.h> //QT3

#include "pixmaps/debian_powered.xpm"
#include "logo.cpp"
#include "intern.h"
#include "version.h"

#ifndef MAQUINA
#define MAQUINA "unknown"
#endif

#ifndef FECHA
#define FECHA "Sun,  3 Dec 2000 01:09:37 +0100"
#endif


Acercade::Acercade
(
	QWidget* parent,
	const char* name
)
	:
	AcercadeData( parent, name, TRUE )
{

#if QT_VERSION < 300
	QColorGroup grp=texto->paperColorGroup();
	grp.setColor( QColorGroup::Base, QApplication::palette().normal().background() );
	texto->setPaperColorGroup( grp );
#else
	texto->setPaper( QBrush(QApplication::palette().active().background()) );
#endif

	logo_debian->setPixmap( QPixmap(debian_xpm) );
	//QToolTip::add(logo_debian, 
	//	"This application has been made with the power of a Debian Potato");

	setDefaultText();

	//Cargamos el logo
	QPixmap logo;
	logo.loadFromData( logo_png, len );
	imagen->setPixmap( logo );
}

Acercade::~Acercade() {
	debug("Destruyendo Acercade");
}


void Acercade::setDefaultText() {
	//bgcolor=\"#C0C0C0\"
	//"<li>QConfig Copyright (C) 2000 Ricardo Villalba, which includes code from\n"

	QString s=
		_( "<qt title=\"acercade\">\n"
		   "<h2>Multi Language Word Translator %1</h2>\n"
		  "<h3>Copyright (C) 2000-2004 %2</h3>\n"
		  "<p>This program is free software; you can redistribute it and/or modify it under "
		  "the terms of the GNU General Public License.</p>\n")
			.arg(VERSION)
			.arg("Ricardo Villalba");

	s += _(
		  "<p><b>Wordtrans</b> includes some code from:\n"
		  "<ul>\n"
		  "<li>BabyTrans by %1</li>\n"
		  "<li>AppConf by %2 & %3</li>"
		  "<li>KDE by several authors</li>"
		  "</ul></p>\n")
			.arg("Frederic Jolliton")
			.arg("Karsten Ballder")
			.arg("Vadim Zeitlin");

	s += _("<p>Translators:\n"
           "<ul>"
           "<li>French: %1</li>"
           "<li>German: %2</li>"
           "<li>Greek: %3</li>"
           "</ul></p>\n")
           .arg("Iznogood")
           .arg("Jens Schler")
           .arg("Vivia Nikolaidou");

	s += _( "<p>Compiling info:\n"
		  "<ul>\n"
		  "<li>Qt version: %1</li>"
		  "<li>Machine: %2</li>"
		  "<li>Date: %3</li>")
			.arg(QT_VERSION_STR)
			.arg(MAQUINA).arg(FECHA);

	s += _( "<li>Support for Babylon dictionaries: %1</li>"
		    "<ul><li>Fribidi for Hebrew: %2</li></ul>")
#ifdef NO_LIBBAB
			.arg( _("no") )
#else
			.arg( _("yes") )
#endif
#ifdef USE_FRIBIDI
			.arg( _("yes") );
#else
			.arg( _("no") );
#endif

	s += _("<li>Process communication: %1</li>")
#ifdef USE_PIPES
			.arg( _("pipes") );
#else
			.arg( _("temporary files") );
#endif

	s += _("<li>Input widget: %1</li>")
#ifdef SIMPLE_INPUT
			.arg( "QLineEdit" );
#else
			.arg( "QComboBox" );
#endif

/*
	s += _("<li>Runtime style changing: %1</li>")
#ifdef CAMBIAR_ESTILOS
			.arg( _("yes") );
#else
			.arg( _("no" ) );
#endif
*/

/*
	s += _("<li>Extra styles: %1</li>")
#ifdef TEMAS_EXTRA
			.arg( _("yes") );
#else
			.arg( _("no" ) );
#endif
*/

	s += _("<li>Menu for history: %1</li>")
#ifdef MENU_HISTORY
			.arg( _("yes") );
#else
			.arg( _("no" ) );
#endif

/*
	s += _("<li>File menu: %1</li>")
#ifdef HAVE_FILE_MENU
			.arg( _("yes") );
#else
			.arg( _("no" ) );
#endif
*/

	s += "</ul></p>";

/*
	s += _( "<p>Developing info:\n"
		  "<ul>"
		  "<li>Text editor: mcedit</li>"
          "<li>Dialog editor: qt-designer</li>"
          "<li>Debugger: gdb</li>"
          "<li>Compiler: (the extremely slow) gcc 2.95.2</li>"
          "<li>Graphics: gimp, xv</li>"
          "</ul></p></qt>");
*/
	s+="</qt>";
	
	setTexto(s);
}

/*
void Acercade::aceptar() {
	done(1);
}
*/

void Acercade::setTexto(const QString& mensaje) {
	texto->setText( mensaje );
}

void Acercade::setImagen(const QString& fichero) {
	QPixmap pixmap;
	pixmap.load( fichero );
	imagen->setBackgroundPixmap( pixmap );
}

void Acercade::setDebugInfo(bool b) {
	debug_info->setChecked(b);
}

bool Acercade::getDebugInfo() {
	return debug_info->isChecked();
}

#include "acercade.moc.cpp"

