/*  Wordtrans, front-end for several dictionaries, for the Qt toolkit.
    Copyright (C) 2000-2004 Ricardo Villalba <rvm@escomposlinux.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef _QDICTDICCIONARIO_H_
#define _QDICTDICCIONARIO_H_

#include "DiccionarioBase.h"
#include <qstring.h>

class QDictDiccionario : public DiccionarioBase
{

public:
	QDictDiccionario();
	virtual ~QDictDiccionario();

	virtual QString getFullName();

	virtual bool busca(const QString& palabra, QString & resultado, 
                       bool con_formato=false);

	virtual bool aprende(const QString& texto_idioma1, const QString& texto_idioma2);
	virtual bool puedeAprender() { return false; };

	virtual void save();
    virtual void load(const QString& fichero);

	virtual bool canSelectPalabrasCompletas() { return false; };
	virtual bool canSelectCaseSensitive() { return false; };
	virtual bool canSelectInvertirResultados() { return false; };

	//virtual bool isBabyDict() { return false; };
	//virtual bool isDictdDict() { return true; };
    //virtual bool isTextDict() { return false; };

	virtual bool update();

	void setEstrategia(const QString& metodo) { estrategia=metodo; };
	QString getEstrategia() { return estrategia; };
	
	void setDatabase(const QString& nombre) { database=nombre; };
	QString getDatabase() { return database; };

	void setServidor(const QString& server) { servidor=server; };
	QString getServidor() { return servidor; };

	void setPuerto(const QString& port) { puerto=port; };
	QString getPuerto() { return puerto; };

	QStringList getAllDatabases();
	QStringList getAllStrategies();

	virtual QString getGeneralInfo(bool con_formato=false);
	virtual bool canGetGeneralInfo() { return true; };

	virtual QString getDictionaryInfo(bool con_formato=false);
	virtual bool canGetDictionaryInfo() { return true; };

	static bool esValidoServidor( const QString& server );
	static bool esValidoPuerto( const QString& port );

protected:
	bool ejecuta_orden(QCString orden, QStringList & lista, bool otra_cosa=false);
	void extraeDatos(QString& output, QStringList & lista, bool otra_cosa=false);
	void formateaTexto( const QStringList & lista, QString & resultado, bool con_formato );
	QString reemplazaEspacios( const QString & cadena );

private:
	QString estrategia;
	QString database;
	QString servidor;
	QString puerto;

	QString tempo_info;
};

#endif
