/*
 * Decompiled with CFR 0.152.
 */
import java.applet.AudioClip;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Plinko
extends JApplet
implements Runnable,
ActionListener,
ChangeListener,
WindowListener {
    static JSpinner bins;
    static JSpinner rate;
    static JSpinner prob;
    JLabel count;
    JLabel mean;
    JLabel variance;
    JLabel current_bin;
    JLabel current_bin_count;
    JLabel current_bin_prob;
    JLabel confidence;
    JButton start;
    JButton clear;
    JButton close;
    PlinkoBoard plinkoboard;
    Thread thread;
    boolean active = false;
    int countdown = 0;
    JFrame frame;
    SplashPanel splash;
    static AudioClip click;
    static AudioClip ping;
    boolean wims_exercise = false;
    int bins_num = 11;
    int speed = 1;
    int total_balls = 100000;
    double chance = 0.5;
    int frame_x = 600;
    int frame_y = 600;
    int font_size = 14;
    int bin_height = 100;
    String title = "Binomial Distribution";
    String click_text = "CLICK ANYWHERE TO BEGIN";
    String start_text = "START";
    String stop_text = "STOP";
    String clear_text = "CLEAR";
    String close_text = "CLOSE";
    String label_count = "Count: ";
    String label_mean = "Mean: ";
    String label_variance = "Variance: ";
    String label_bin = "Bin: ";
    String label_bins = "Bins: ";
    String label_speed = "Speed: ";
    String label_probability = "Probability: ";
    String label_bin_count = "Bin Count: ";
    String label_bin_probability = "Bin Probability: ";
    String label_confidence = "Confidence Interval: ";
    String some_text = " % of the balls landed in bin ";
    String some_text2 = " % of the balls landed in bins ";
    String through = " through ";
    String label_controls = " Controls ";
    String label_statistics = "Statistics";

    public void init() {
        Object object;
        Object object2;
        String string = this.getParameter("wims_exercise");
        if (string != null && (string.equalsIgnoreCase("yes") || string.equals("1"))) {
            this.wims_exercise = true;
            string = this.getParameter("balls");
            if (string != null && string.length() > 0) {
                this.total_balls = Integer.parseInt(string, 10);
            }
            if ((string = this.getParameter("chance")) != null && string.length() > 0) {
                this.chance = Double.parseDouble(string);
            }
            if ((string = this.getParameter("bins")) != null && string.length() > 0) {
                this.bins_num = Integer.parseInt(string, 10);
            }
            if ((string = this.getParameter("speed")) != null && string.length() > 0) {
                this.speed = Integer.parseInt(string, 10);
            }
            if ((string = this.getParameter("xsize")) != null && string.length() > 0) {
                this.frame_x = Integer.parseInt(string, 10);
            }
            if ((string = this.getParameter("ysize")) != null && string.length() > 0) {
                this.frame_y = Integer.parseInt(string, 10);
            }
            if ((string = this.getParameter("title")) != null && string.length() > 0) {
                this.title = string;
            }
            if ((string = this.getParameter("font_size")) != null && string.length() > 0) {
                this.font_size = Integer.parseInt(string, 10);
            }
            if ((string = this.getParameter("binheight")) != null && string.length() > 0) {
                this.bin_height = Integer.parseInt(string, 10);
            }
        }
        if ((string = this.getParameter("language")) != null && string.length() > 0) {
            if (string.equalsIgnoreCase("nl")) {
                this.click_text = "KLIK HIER OM TE BEGINNEN";
                this.start_text = "START";
                this.stop_text = "STOP";
                this.clear_text = "WISSEN";
                this.close_text = "SLUITEN";
                this.label_count = "Aantal: ";
                this.label_mean = "Gemiddeld: ";
                this.label_variance = "Variantie: ";
                this.label_bin = "Bakje: ";
                this.label_bins = "Bakjes: ";
                this.label_speed = "Snelheid: ";
                this.label_bin_count = "Ballen/bakje: ";
                this.label_probability = "Kans: ";
                this.label_bin_probability = "Kans per bakje: ";
                this.label_confidence = "Betrouwbaarheids interval: ";
                this.some_text = " % van de ballen in bakje: ";
                this.some_text2 = " % van de ballen in bakje: ";
                this.through = " t/m ";
                object2 = " Menu ";
                object = "Statistiek";
            }
            if (string.equalsIgnoreCase("fr")) {
                this.click_text = "CLIQUEZ ICI";
                this.start_text = "COMMENCER";
                this.stop_text = "PAUSE";
                this.clear_text = "EFFACER";
                this.close_text = "FERMER";
                this.label_count = "Quantit\u00e9 : ";
                this.label_mean = "Moyenne : ";
                this.label_variance = "Variance: ";
                this.label_bin = "Panier : ";
                this.label_bins = "Paniers : ";
                this.label_speed = "Vitesse : ";
                this.label_bin_count = "Balles dans ce panier : ";
                this.label_bin_probability = "% de balles dans ce panier : ";
                this.label_probability = "Probabilit\u00e9 : ";
                this.label_confidence = "Intervalle de confiance : ";
                this.some_text = " % de balles dans le panier ";
                this.some_text2 = " % de balles dans les paniers ";
                this.through = " \u00e0 ";
                this.label_controls = "Menu";
                this.label_statistics = "Statistiques";
            }
            if (string.equalsIgnoreCase("de")) {
                this.click_text = "Klicken Sie hier um zu starten";
                this.start_text = "START";
                this.stop_text = "STOP";
                this.clear_text = "CLEAR";
                this.close_text = "CLOSE";
                this.label_count = "Zahl: ";
                this.label_mean = "Mean: ";
                this.label_variance = "Variance: ";
                this.label_bin = "Beh\u2030lter: ";
                this.label_bins = "Beh\u2030lter: ";
                this.label_speed = "Geschwindigkeit : ";
                this.label_bin_count = "Zahl/Beh\u2030lter: ";
                this.label_bin_probability = "Wahrscheinlichkeit in Beh\u2030lter: ";
                this.label_probability = "Wahrscheinlichkeit: ";
                this.label_confidence = "Wahrscheinlichkeits Intervall: ";
                this.some_text = " % der Kugeln f\u2030llt in Beh\u2030lter ";
                this.some_text2 = " % der Kugeln f\u2030llt in Beh\u2030lter ";
                this.through = " bis ";
                object2 = " Menu ";
                object = "Statistik";
            }
        }
        this.setBackground(Color.white);
        this.frame = new JFrame();
        this.frame.setVisible(false);
        this.frame.setSize(this.frame_x, this.frame_y);
        this.frame.setLocation(0, 0);
        this.frame.setTitle(this.title);
        object2 = new Font("Helvetica", 1, this.font_size);
        object = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel(this.label_bins, 2);
        jPanel.add(jLabel);
        bins = new JSpinner(new SpinnerNumberModel(this.bins_num, 2, 101, 1));
        jPanel.add(bins);
        jLabel = new JLabel(this.label_probability, 2);
        jPanel.add(jLabel);
        prob = new JSpinner(new SpinnerNumberModel(0.5, 0.0, 100.0, 0.01));
        SpinnerNumberModel spinnerNumberModel = (SpinnerNumberModel)prob.getModel();
        spinnerNumberModel.setMaximum(new Double(1.0));
        jPanel.add(prob);
        jLabel = new JLabel(this.label_speed, 2);
        jPanel.add(jLabel);
        rate = new JSpinner(new SpinnerNumberModel(1, 1, 10, 1));
        jPanel.add(rate);
        JPanel jPanel2 = new JPanel();
        this.start = new JButton(this.start_text);
        jPanel2.add(this.start);
        this.start.setDefaultCapable(true);
        this.frame.getRootPane().setDefaultButton(this.start);
        this.clear = new JButton(this.clear_text);
        jPanel2.add(this.clear);
        this.close = new JButton(this.close_text);
        jPanel2.add(this.close);
        this.close.setDefaultCapable(false);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add("East", jPanel2);
        JPanel jPanel4 = new JPanel(new GridLayout(2, 3));
        this.count = new JLabel(this.label_count);
        jPanel4.add(this.count);
        this.mean = new JLabel(this.label_mean);
        jPanel4.add(this.mean);
        this.variance = new JLabel(this.label_variance);
        jPanel4.add(this.variance);
        this.current_bin = new JLabel(this.label_bin);
        jPanel4.add(this.current_bin);
        this.current_bin_count = new JLabel(this.label_bin_count);
        jPanel4.add(this.current_bin_count);
        this.current_bin_prob = new JLabel(this.label_bin_probability);
        jPanel4.add(this.current_bin_prob);
        JPanel jPanel5 = new JPanel(new GridLayout(1, 1));
        this.confidence = new JLabel(this.label_confidence);
        jPanel5.add(this.confidence);
        JPanel jPanel6 = new JPanel(new BorderLayout());
        if (!this.wims_exercise) {
            jPanel3.add("West", jPanel);
            jPanel3.setBorder(BorderFactory.createTitledBorder(jPanel3.getBorder(), this.label_controls, 1, 2, new Font("Helvetica", 1, this.font_size)));
        }
        jPanel6.add("Center", jPanel4);
        jPanel6.add("South", jPanel5);
        jPanel6.setBorder(BorderFactory.createTitledBorder(jPanel6.getBorder(), this.label_statistics, 1, 2, new Font("Helvetica", 1, this.font_size)));
        JPanel jPanel7 = new JPanel(new BorderLayout());
        jPanel7.add("Center", jPanel6);
        JLabel jLabel2 = new JLabel("");
        jLabel2.setPreferredSize(new Dimension(15, 15));
        jPanel7.add("South", jLabel2);
        Container container = this.frame.getContentPane();
        container.setLayout(new BorderLayout(10, 10));
        this.plinkoboard = new PlinkoBoard(this);
        container.add("Center", this.plinkoboard);
        container.add("North", jPanel3);
        container.add("South", jPanel7);
        this.start.addActionListener(this);
        this.clear.addActionListener(this);
        this.close.addActionListener(this);
        bins.addChangeListener(this);
        rate.addChangeListener(this);
        prob.addChangeListener(this);
        this.plinkoboard.requestFocus();
        this.frame.addWindowListener(this);
        this.splash = new SplashPanel(this);
        this.getContentPane().add(this.splash);
        click = this.getAudioClip(this.getCodeBase(), "sounds/click.au");
        ping = this.getAudioClip(this.getCodeBase(), "sounds/ping.au");
    }

    public String ReadApplet() {
        String string = this.plinkoboard.ReadData();
        return string;
    }

    public void showFrame() {
        this.frame.setVisible(true);
    }

    public void stop() {
        this.frame.setVisible(false);
        this.splash.start();
    }

    public void run() {
        while (this.active) {
            this.plinkoboard.dropBall(false);
            try {
                if (this.wims_exercise) {
                    Thread.sleep(105 - 10 * this.speed);
                    continue;
                }
                Thread.sleep(105 - 10 * (Integer)rate.getValue());
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void toggleStart() {
        if (this.active) {
            this.active = false;
            this.start.setText(this.start_text);
        } else {
            this.active = true;
            bins.setEnabled(false);
            this.thread = new Thread(this);
            this.thread.start();
            this.start.setText(this.stop_text);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.start) {
            this.toggleStart();
            this.plinkoboard.requestFocus();
        }
        if (object == this.clear) {
            if (this.plinkoboard.FIRST_BALL == null) {
                this.plinkoboard.newHist();
            } else {
                this.plinkoboard.FIRST_BALL = null;
                if (!this.active) {
                    bins.setEnabled(true);
                }
            }
            this.plinkoboard.repaint();
            this.plinkoboard.requestFocus();
        }
        if (object == this.close) {
            this.stop();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object == bins) {
            this.count.setText("0");
            this.plinkoboard.setup();
            this.plinkoboard.newHist();
            this.plinkoboard.drawBackground();
        } else if (object != rate && object == prob) {
            this.plinkoboard.updatePercent();
            this.plinkoboard.repaint();
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public String getAppletInfo() {
        return "Written by Dr. P. Little \n http://www.math.psu.edu/dlittle/java/probability/plinko/index.html";
    }
}

