/*
 * Decompiled with CFR 0.152.
 */
package WIMSchem;

import WIMSchem.MainApplet;
import WIMSchem.Molecule;
import WIMSchem.MoleculeStream;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;

public class Templates {
    ArrayList<Molecule> templ = new ArrayList();

    public static byte[] loadURL(URL url) throws IOException {
        int n;
        int bufSize = 2048;
        byte[] buf = new byte[bufSize];
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        BufferedInputStream in = new BufferedInputStream(url.openStream());
        while ((n = in.read(buf)) > 0) {
            bout.write(buf, 0, n);
        }
        try {
            in.close();
        }
        catch (Exception ignored) {
            // empty catch block
        }
        return bout.toByteArray();
    }

    public static String loadFile(String fname) throws IOException {
        byte[] bytes = Templates.loadURL(new URL("file:" + fname));
        return new String(bytes);
    }

    public static String load(String fileOrURL) throws IOException {
        try {
            URL url = new URL(fileOrURL);
            return new String(Templates.loadURL(url));
        }
        catch (Exception e) {
            return Templates.loadFile(fileOrURL);
        }
    }

    public Templates(Class cls) {
        Molecule mol;
        ArrayList<String> list = new ArrayList<String>();
        boolean inapplet = false;
        if (MainApplet.templateURL != null) {
            Molecule mol2;
            int p;
            for (p = 0; p < MainApplet.templateURL.length; ++p) {
                try {
                    mol2 = MoleculeStream.ReadUnknown(new BufferedReader(new StringReader(Templates.load(MainApplet.templateURL[p]))));
                    this.templ.add(mol2);
                    inapplet = true;
                    System.out.println("loading template" + p);
                    continue;
                }
                catch (IOException e) {
                    System.out.println("FAILED loading template" + p + "\n Are you using correct MDLMol or Native files??");
                }
            }
            if (!inapplet) {
                for (p = 0; p < MainApplet.templateURL.length; ++p) {
                    try {
                        System.out.println("MainApplet.templateURL[p]=" + MainApplet.templateURL[p]);
                        mol2 = MoleculeStream.ReadUnknown(new BufferedReader(new StringReader(MainApplet.templateURL[p].toString())));
                        this.templ.add(mol2);
                        inapplet = true;
                        System.out.println("loading template" + p);
                        continue;
                    }
                    catch (IOException e) {
                        System.out.println("FAILED loading template" + p + "\n Are you using correct javascript strings??");
                    }
                }
            }
        }
        if (!inapplet) {
            try {
                String line;
                InputStream istr = cls.getResourceAsStream("/templ/list");
                BufferedReader in = new BufferedReader(new InputStreamReader(istr));
                while ((line = in.readLine()) != null) {
                    list.add(line);
                }
                istr.close();
            }
            catch (IOException e) {
                System.out.println("Failed to obtain list of templates:\n" + e.toString());
                return;
            }
            try {
                for (int n = 0; n < list.size(); ++n) {
                    InputStream istr = cls.getResourceAsStream("/templ/" + (String)list.get(n));
                    mol = MoleculeStream.ReadNative(istr);
                    this.templ.add(mol);
                    istr.close();
                }
            }
            catch (IOException e) {
                System.out.println("Failed to obtain particular template:\n" + e.toString());
                return;
            }
        }
        int[] complex = new int[this.templ.size()];
        for (int n = 0; n < this.templ.size(); ++n) {
            int i;
            mol = this.templ.get(n);
            complex[n] = mol.NumAtoms() * 100;
            boolean nonCH = false;
            for (i = 1; i <= mol.NumAtoms(); ++i) {
                if (mol.AtomElement(i).compareTo("C") == 0 || mol.AtomElement(i).compareTo("H") == 0) continue;
                nonCH = true;
            }
            if (!nonCH) {
                int n2 = n;
                complex[n2] = complex[n2] - 1000;
            }
            for (i = 1; i <= mol.NumBonds(); ++i) {
                complex[n] = complex[n] + mol.BondOrder(i);
            }
        }
        int p = 0;
        while (p < this.templ.size() - 1) {
            if (complex[p] > complex[p + 1]) {
                int i = complex[p];
                complex[p] = complex[p + 1];
                complex[p + 1] = i;
                Molecule mol3 = this.templ.get(p);
                this.templ.set(p, this.templ.get(p + 1));
                this.templ.set(p + 1, mol3);
                if (p <= 0) continue;
                --p;
                continue;
            }
            ++p;
        }
    }

    public int NumTemplates() {
        return this.templ.size();
    }

    public Molecule GetTemplate(int N) {
        return this.templ.get(N);
    }

    public void AddTemplate(Molecule Mol) {
        this.templ.add(Mol);
    }
}

