/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import java.awt.Frame;
import java.util.Enumeration;
import rene.dialogs.Warning;
import rene.gui.Global;
import rene.util.xml.XmlWriter;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.construction.Count;
import rene.zirkel.dialogs.EditConditionals;
import rene.zirkel.expression.Expression;
import rene.zirkel.expression.InvalidException;
import rene.zirkel.graphics.MyGraphics;
import rene.zirkel.graphics.MyGraphics13;
import rene.zirkel.objects.AngleEditDialog;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.InsideObject;
import rene.zirkel.objects.PointObject;

public class AngleObject
extends ConstructionObject
implements InsideObject {
    protected PointObject P1;
    protected PointObject P2;
    protected PointObject P3;
    static Count N = new Count();
    double A;
    double A1;
    double A2;
    double X;
    double Y;
    boolean Fixed;
    Expression E;
    boolean Filled = false;
    static final double LabelScale = 0.66;
    public static final int NORMALSIZE = 1;
    public static final int SMALL = 0;
    public static final int LARGER = 2;
    public static final int LARGE = 3;
    public static final int RECT = 4;
    protected int DisplaySize = 1;
    double[] x = new double[4];
    double[] y = new double[4];
    public static char[] Translation = new char[]{'a', '\u03b1', 'A', '\u0391', 'b', '\u03b2', 'B', '\u0392', 'c', '\u03b3', 'C', '\u0393', 'd', '\u03b4', 'D', '\u0394', 'e', '\u03b5', 'E', '\u0395', 'f', '\u03d5', 'F', '\u03a6', 'g', '\u03b3', 'G', '\u0393', 'h', '\u03b7', 'H', '\u0397', 'i', '\u03b9', 'I', '\u0399', 'k', '\u03ba', 'K', '\u039a', 'l', '\u03bb', 'L', '\u039b', 'm', '\u03bc', 'M', '\u039c', 'n', '\u03bd', 'N', '\u039d', 'o', '\u03bf', 'O', '\u03a9', 'p', '\u03c0', 'P', '\u03a0', 'q', '\u03c7', 'Q', '\u03a7', 'r', '\u03c1', 'R', '\u03a1', 's', '\u03c3', 'S', '\u03a3', 't', '\u03c4', 'T', '\u03a4', 'u', '\u03c5', 'U', '\u03a5', 'v', '\u03c8', 'V', '\u03a8', 'w', '\u03c9', 'W', '\u03a9', 'x', '\u03be', 'X', '\u039e', 'y', '\u03c7', 'Y', '\u03a7', 'z', '\u03b6', 'Z', '\u0396'};

    public AngleObject(Construction construction, PointObject pointObject, PointObject pointObject2, PointObject pointObject3) {
        super(construction);
        this.P1 = pointObject;
        this.P2 = pointObject2;
        this.P3 = pointObject3;
        this.validate();
        this.setColor(this.ColorIndex);
        this.updateText();
        this.Unit = Global.getParameter("unit.angle", "\u221e");
    }

    public AngleObject(Construction construction) {
        super(construction);
    }

    public String getTag() {
        return "Angle";
    }

    public int getN() {
        return N.next();
    }

    public void updateText() {
        if (!this.Fixed || this.E == null) {
            this.setText(AngleObject.text3(Zirkel.name("text.angle"), this.P1.getName(), this.P2.getName(), this.P3.getName()));
        } else {
            this.setText(AngleObject.text4(Zirkel.name("text.angle.fixed"), this.P1.getName(), this.P2.getName(), this.P3.getName(), "\"" + this.E.toString() + "\""));
        }
    }

    public String getDisplayValue() {
        if (ZirkelCanvas.AnglesFactor <= 2.0) {
            return "" + (int)(this.A / Math.PI * 180.0 + 0.5);
        }
        return "" + this.round(this.A / Math.PI * 180.0, ZirkelCanvas.AnglesFactor);
    }

    public boolean nearto(int n, int n2, ZirkelCanvas zirkelCanvas) {
        boolean bl;
        if (!this.displays(zirkelCanvas)) {
            return false;
        }
        double d2 = zirkelCanvas.x(n) - this.X;
        double d3 = zirkelCanvas.y(n2) - this.Y;
        double d4 = zirkelCanvas.dx((int)zirkelCanvas.selectionSize());
        double d5 = this.getDisplaySize(zirkelCanvas);
        double d6 = Math.sqrt(d2 * d2 + d3 * d3);
        this.Value = Math.abs(d6 - d5);
        if (this.Filled || this.DisplaySize == 4) {
            boolean bl2 = bl = d6 < d5 + d4;
            if (bl) {
                this.Value = 0.0;
            }
        } else {
            boolean bl3 = bl = Math.abs(d6 - d5) < d4;
        }
        if (!bl) {
            return false;
        }
        if (d5 < d4) {
            return bl;
        }
        double d7 = Math.atan2(d3, d2);
        if (d7 < 0.0) {
            d7 += Math.PI * 2;
        }
        double d8 = 0.05;
        if (d7 < this.A1) {
            d7 += Math.PI * 2;
        }
        return d7 > this.A1 - d8 && d7 < this.A1 + this.A + d8;
    }

    public void validate() {
        double d2;
        if (this.P1 == null) {
            return;
        }
        if (!(this.P1.valid() && this.P2.valid() && this.P3.valid())) {
            this.Valid = false;
            return;
        }
        this.X = this.P2.getX();
        this.Y = this.P2.getY();
        double d3 = this.P1.getX() - this.X;
        if (Math.sqrt(d3 * d3 + (d2 = this.P1.getY() - this.Y) * d2) < 1.0E-9) {
            this.Valid = false;
            return;
        }
        this.A1 = Math.atan2(d2, d3);
        if (this.A1 < 0.0) {
            this.A1 += Math.PI * 2;
        }
        if (Math.sqrt((d3 = this.P3.getX() - this.X) * d3 + (d2 = this.P3.getY() - this.Y) * d2) < 1.0E-9) {
            this.Valid = false;
            return;
        }
        this.A2 = Math.atan2(d2, d3);
        if (this.A2 < 0.0) {
            this.A2 += Math.PI * 2;
        }
        this.A = this.A2 - this.A1;
        if (this.A < 0.0) {
            this.A += Math.PI * 2;
        }
        this.Valid = true;
        if (this.Fixed) {
            double d4 = 0.0;
            try {
                d4 = this.E.getValue() / 180.0 * Math.PI;
            }
            catch (Exception exception) {
                return;
            }
            if (this.P3.moveableBy(this)) {
                d3 = this.P3.getX() - this.X;
                double d5 = Math.sqrt(d3 * d3 + (d2 = this.P3.getY() - this.Y) * d2);
                if (d5 < 1.0E-9) {
                    d5 = 1.0E-9;
                }
                this.P3.move(this.X + Math.cos(this.A1 + d4) * d5, this.Y + Math.sin(this.A1 + d4) * d5);
                this.A2 = this.A1 + d4;
            } else {
                this.Fixed = false;
            }
            if (this.Fixed) {
                this.A = d4;
                this.P3.movedBy(this);
                this.P1.movedBy(this);
            }
        } else if (!this.Obtuse && this.A > Math.PI) {
            this.A1 = this.A2;
            this.A = Math.PI * 2 - this.A;
            this.A2 = this.A1 + this.A;
        }
    }

    public void paint(MyGraphics myGraphics, ZirkelCanvas zirkelCanvas) {
        String string;
        if (!this.Valid || this.mustHide(zirkelCanvas)) {
            return;
        }
        double d2 = zirkelCanvas.col(this.getDisplaySize(zirkelCanvas)) - zirkelCanvas.col(0.0);
        double d3 = zirkelCanvas.col(this.X) - d2;
        double d4 = zirkelCanvas.row(this.Y) - d2;
        double d5 = (this.A2 - this.A1) / Math.PI * 180.0;
        if (d5 < 0.0) {
            d5 += 360.0;
        } else if (d5 >= 360.0) {
            d5 -= 360.0;
        }
        if (this.visible(zirkelCanvas)) {
            double d6;
            if (this.isStrongSelected() && myGraphics instanceof MyGraphics13) {
                ((MyGraphics13)myGraphics).drawMarkerArc(d3 + d2, d4 + d2, d2, this.A1 / Math.PI * 180.0, d5);
            }
            if (this.Filled) {
                if (this.DisplaySize == 4) {
                    d6 = Math.cos(this.A1);
                    double d7 = Math.sin(this.A1);
                    double d8 = Math.cos(this.A1 + d5 / 180.0 * Math.PI);
                    double d9 = Math.sin(this.A1 + d5 / 180.0 * Math.PI);
                    double d10 = d6 + d8;
                    double d11 = d7 + d9;
                    if (d5 > 180.0) {
                        d10 = -d10;
                        d11 = -d11;
                    }
                    if (this.Selected || this.getColorType() != 2) {
                        myGraphics.setColor(this);
                        myGraphics.drawLine(d3 + d2 + d2 * d6, d4 + d2 - d2 * d7, d3 + d2 + d2 * d10, d4 + d2 - d2 * d11);
                        myGraphics.drawLine(d3 + d2 + d2 * d10, d4 + d2 - d2 * d11, d3 + d2 + d2 * d8, d4 + d2 - d2 * d9);
                    }
                    this.x[0] = d3 + d2;
                    this.y[0] = d4 + d2;
                    this.x[1] = d3 + d2 + d2 * d6;
                    this.y[1] = d4 + d2 - d2 * d7;
                    this.x[2] = d3 + d2 + d2 * d10;
                    this.y[2] = d4 + d2 - d2 * d11;
                    this.x[3] = d3 + d2 + d2 * d8;
                    this.y[3] = d4 + d2 - d2 * d9;
                    myGraphics.fillPolygon(this.x, this.y, 4, false, this.getColorType() != 1, this);
                } else {
                    myGraphics.fillArc(d3, d4, 2.0 * d2, 2.0 * d2, this.A1 / Math.PI * 180.0, d5, this.Selected || this.getColorType() != 2, this.getColorType() != 1, true, this);
                }
            } else {
                myGraphics.setColor(this);
                if (this.DisplaySize == 4) {
                    d6 = Math.cos(this.A1);
                    double d12 = Math.sin(this.A1);
                    double d13 = Math.cos(this.A1 + d5 / 180.0 * Math.PI);
                    double d14 = Math.sin(this.A1 + d5 / 180.0 * Math.PI);
                    myGraphics.drawLine(d3 + d2 + d2 * d6, d4 + d2 - d2 * d12, d3 + d2 + d2 * (d6 + d13), d4 + d2 - d2 * (d12 + d14));
                    myGraphics.drawLine(d3 + d2 + d2 * (d6 + d13), d4 + d2 - d2 * (d12 + d14), d3 + d2 + d2 * d13, d4 + d2 - d2 * d14);
                } else {
                    myGraphics.drawCircleArc(d3 + d2, d4 + d2, d2, this.A1 / Math.PI * 180.0, d5, this);
                }
            }
        }
        if (!(string = AngleObject.translateToUnicode(this.getDisplayText())).equals("")) {
            myGraphics.setLabelColor(this);
            this.setFont(myGraphics);
            this.DisplaysText = true;
            double d15 = Math.cos(this.A1 + this.A / 2.0);
            double d16 = Math.sin(this.A1 + this.A / 2.0);
            if (string.equals("90" + this.getUnit()) || this.Name.startsWith(".")) {
                if (this.KeepClose) {
                    double d17 = Math.sqrt(this.XcOffset * this.XcOffset + this.YcOffset * this.YcOffset);
                    this.TX1 = zirkelCanvas.col(this.X + d17 * d15) - 3.0;
                    this.TY1 = zirkelCanvas.row(this.Y + d17 * d16) - 3.0;
                    this.TX2 = this.TX1 + 9.0;
                    this.TY2 = this.TY1 + 9.0;
                    myGraphics.drawRect(zirkelCanvas.col(this.X + d17 * d15) - 1.0, zirkelCanvas.row(this.Y + d17 * d16) - 1.0, 3.0, 3.0);
                } else {
                    this.TX1 = zirkelCanvas.col(this.X + zirkelCanvas.dx(d2 * 0.66) * d15 + this.XcOffset) - 3.0;
                    this.TY1 = zirkelCanvas.row(this.Y + zirkelCanvas.dy(d2 * 0.66) * d16 + this.YcOffset) - 3.0;
                    this.TX2 = this.TX1 + 9.0;
                    this.TY2 = this.TY1 + 9.0;
                    myGraphics.drawRect(zirkelCanvas.col(this.X + zirkelCanvas.dx(d2 * 0.66) * d15 + this.XcOffset) - 1.0, zirkelCanvas.row(this.Y + zirkelCanvas.dy(d2 * 0.66) * d16 + this.YcOffset) - 1.0, 3.0, 3.0);
                }
            } else if (this.KeepClose) {
                double d18 = Math.sqrt(this.XcOffset * this.XcOffset + this.YcOffset * this.YcOffset);
                this.drawCenteredLabel(myGraphics, string, zirkelCanvas, this.X + d18 * d15, this.Y + d18 * d16, 0.0, 0.0);
            } else {
                this.drawCenteredLabel(myGraphics, string, zirkelCanvas, this.X + zirkelCanvas.dx(d2 * 0.66) * d15, this.Y + zirkelCanvas.dy(d2 * 0.66) * d16, this.XcOffset, this.YcOffset);
            }
        }
    }

    public boolean canKeepClose() {
        return true;
    }

    public void setKeepClose(double d2, double d3) {
        this.KeepClose = true;
        this.XcOffset = d2 - this.X;
        this.YcOffset = d3 - this.Y;
    }

    double getDisplaySize(ZirkelCanvas zirkelCanvas) {
        double d2 = zirkelCanvas.dx((int)(12.0 * zirkelCanvas.pointSize()));
        if (this.DisplaySize == 0 || this.DisplaySize == 4) {
            d2 /= 2.0;
        } else if (this.DisplaySize == 2) {
            d2 *= 2.0;
        } else if (this.DisplaySize == 3) {
            double d3 = this.P1.getX() - this.X;
            double d4 = this.P1.getY() - this.Y;
            d2 = Math.sqrt(d3 * d3 + d4 * d4);
        }
        return d2;
    }

    public double getLength() {
        return this.A;
    }

    public boolean fixed() {
        return this.Fixed;
    }

    public void setFixed(boolean bl) {
        this.Fixed = bl;
        this.updateText();
    }

    public void setFixed(String string) {
        this.Fixed = true;
        this.E = new Expression(string, this.getConstruction(), this);
        this.updateText();
    }

    public boolean canFix() {
        return this.P3.moveableBy(this);
    }

    public void printArgs(XmlWriter xmlWriter) {
        if (this.P1 != null) {
            xmlWriter.printArg("first", this.P1.getName());
            xmlWriter.printArg("root", this.P2.getName());
            xmlWriter.printArg("second", this.P3.getName());
        }
        if (this.DisplaySize == 0) {
            xmlWriter.printArg("display", "small");
        }
        if (this.DisplaySize == 3) {
            xmlWriter.printArg("display", "large");
        }
        if (this.DisplaySize == 2) {
            xmlWriter.printArg("display", "larger");
        }
        if (this.DisplaySize == 4) {
            xmlWriter.printArg("display", "rectangle");
        }
        if (this.Filled) {
            xmlWriter.printArg("filled", "true");
        }
        if (this.Fixed && this.E != null) {
            xmlWriter.printArg("fixed", this.E.toString());
        }
        if (!this.Obtuse) {
            xmlWriter.printArg("acute", "true");
        }
        super.printArgs(xmlWriter);
    }

    public void edit(ZirkelCanvas zirkelCanvas) {
        AngleEditDialog angleEditDialog = new AngleEditDialog(zirkelCanvas.getFrame(), this);
        angleEditDialog.setVisible(true);
        zirkelCanvas.repaint();
        if (this.E != null && !this.E.isValid()) {
            Frame frame = zirkelCanvas.getFrame();
            Warning warning = new Warning(frame, this.E.getErrorText(), Zirkel.name("warning"), true);
            warning.center(frame);
            warning.setVisible(true);
        }
        if (angleEditDialog.wantsMore()) {
            new EditConditionals(zirkelCanvas.getFrame(), this);
            this.validate();
        }
    }

    public void setDisplaySize(int n) {
        this.DisplaySize = n;
    }

    public int getDisplaySize() {
        return this.DisplaySize;
    }

    public Enumeration depending() {
        super.depending();
        if (this.P1 == null) {
            return DL.elements();
        }
        if (!this.Fixed) {
            return this.depset(this.P1, this.P2, this.P3);
        }
        this.depset(this.P1, this.P2, this.P3);
        Enumeration enumeration = this.E.getDepList().elements();
        while (enumeration.hasMoreElements()) {
            DL.add((ConstructionObject)enumeration.nextElement());
        }
        return DL.elements();
    }

    public boolean equals(ConstructionObject constructionObject) {
        if (!(constructionObject instanceof AngleObject) || !constructionObject.valid()) {
            return false;
        }
        AngleObject angleObject = (AngleObject)constructionObject;
        return this.equals(this.X, angleObject.X) && this.equals(this.Y, angleObject.Y) && this.equals(this.A1, angleObject.A1) && this.equals(this.A2, angleObject.A2);
    }

    public static String translateToUnicode(String string) {
        if (string.startsWith("$")) {
            return string;
        }
        if (string.indexOf(92) < 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            int n;
            char c2 = string.charAt(i);
            if (c2 != '\\') {
                stringBuffer.append(c2);
                continue;
            }
            if (++i >= string.length()) continue;
            c2 = string.charAt(i);
            if (c2 == '0') {
                n = 0;
                ++i;
                while (i < string.length()) {
                    char c3 = string.charAt(i);
                    if (c3 >= '0' && c3 <= '9') {
                        n = n * 16 + (c3 - 48);
                    } else {
                        if (c3 < 'A' || c3 > 'F') break;
                        n = n * 16 + (c3 - 65 + 10);
                    }
                    ++i;
                }
                if (n > 0) {
                    c2 = (char)n;
                    stringBuffer.append(c2);
                }
                --i;
                continue;
            }
            n = 0;
            for (n = 0; n < Translation.length; n += 2) {
                if (Translation[n] != c2) continue;
                stringBuffer.append(Translation[n + 1]);
                break;
            }
            if (n < Translation.length) continue;
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public void translate() {
        this.P1 = (PointObject)this.P1.getTranslation();
        this.P2 = (PointObject)this.P2.getTranslation();
        this.P3 = (PointObject)this.P3.getTranslation();
        if (this.Fixed) {
            try {
                this.setFixed(this.E.toString());
                this.E.translate();
            }
            catch (Exception exception) {
                this.Fixed = false;
            }
        }
    }

    public String getE() {
        if (this.Fixed && this.E != null) {
            return this.E.toString();
        }
        return "" + this.round(this.A / Math.PI * 180.0);
    }

    public double getValue() throws ConstructionException {
        if (!this.Valid) {
            throw new InvalidException("exception.invalid");
        }
        return this.A / Math.PI * 180.0;
    }

    public void setFilled(boolean bl) {
        this.Filled = bl;
    }

    public boolean isFilled() {
        return this.Filled;
    }

    public boolean maybeTransparent() {
        return true;
    }

    public boolean isFilledForSelect() {
        return false;
    }

    public double containsInside(PointObject pointObject) {
        double d2 = pointObject.getX() - this.X;
        double d3 = pointObject.getY() - this.Y;
        double d4 = Math.atan2(d3, d2);
        if (d4 < 0.0) {
            d4 += Math.PI * 2;
        }
        if (d4 < this.A1) {
            d4 += Math.PI * 2;
        }
        double d5 = 1.0E-5;
        if (d4 > this.A1 && d4 < this.A1 + this.A) {
            return 1.0;
        }
        if (d4 > this.A1 - d5 && d4 < this.A1 + this.A + d5) {
            return 0.5;
        }
        return 0.0;
    }

    public boolean keepInside(PointObject pointObject) {
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        if (this.containsInside(pointObject) > 0.0) {
            return true;
        }
        double d8 = pointObject.getX();
        double d9 = pointObject.getY();
        double d10 = this.P2.getX();
        double d11 = this.P2.getY();
        double d12 = d10;
        double d13 = d11;
        double d14 = 1.0E20;
        double d15 = this.P1.getX();
        double d16 = d15 - d10;
        double d17 = d16 * (d8 - d10) / (d7 = d16 * d16 + (d6 = (d5 = this.P1.getY()) - d11) * d6) + d6 * (d9 - d11) / d7;
        if (d17 < 0.0) {
            d17 = 0.0;
        }
        if ((d4 = Math.sqrt((d8 - (d3 = d10 + d17 * d16)) * (d8 - d3) + (d9 - (d2 = d11 + d17 * d6)) * (d9 - d2))) < d14) {
            d14 = d4;
            d12 = d3;
            d13 = d2;
        }
        if ((d17 = (d16 = (d15 = this.P3.getX()) - d10) * (d8 - d10) / (d7 = d16 * d16 + (d6 = (d5 = this.P3.getY()) - d11) * d6) + d6 * (d9 - d11) / d7) < 0.0) {
            d17 = 0.0;
        }
        if ((d4 = Math.sqrt((d8 - (d3 = d10 + d17 * d16)) * (d8 - d3) + (d9 - (d2 = d11 + d17 * d6)) * (d9 - d2))) < d14) {
            d14 = d4;
            d12 = d3;
            d13 = d2;
        }
        pointObject.move(d12, d13);
        return false;
    }
}

