/*
 * ScriptEdit.h
 *
 * Copyright (C) 2003 J. "MUFTI" Scheurich
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#ifndef _ECMA_SCRIPT_EDIT_H
#define _ECMA_SCRIPT_EDIT_H

#include "NodeScript.h"
#include "Scene.h"
#include "Array.h"
#include "swt.h"

typedef void  (*EditorReadyCallback)(void *data);

class ScriptEdit {
public:
			ScriptEdit(NodeScript* node, SWND wnd, 
                                   EditorReadyCallback editorReadyCallback,
                                   void *data);
    		       ~ScriptEdit();

    char	       *ecmaScriptEdit(void);
    void		OnTimer(void);
    void 		ecmaScriptReadEditorfile(char* filename = NULL);

protected:

    bool		write2file(int f, const char* string);

    bool		WriteSFStringUrl(int f, char* string);
    bool		ecmaScriptStartEditor(void);
    bool 		ecmaScriptCheckEditorData(void);

private:

    NodeScript	       *_scriptNode;
    SWND                _wnd;
    STIMER          	_timer;
    char                _editorFile[1024];
    Array<int>          _urlStartData;
    Array<int>          _urlEndData;
    char	       *_urlData;
    int			_urlDataLength;
    void	       *_data;
    EditorReadyCallback _editorReadyCallback;
};

#endif


