/*
 * ArrayDialog.h
 *
 * Copyright (C) 1999 Stephen F. White, 2004 J. "MUFTI" Scheurich
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#ifndef ARRAY_DIALOG_H
#define ARRAY_DIALOG_H

#ifndef _DIALOG_H
#include "Dialog.h"
#endif

#include "swttypedef.h"

#include "SFVec3f.h"
#include "SFRotation.h"

class ArrayDialog : public Dialog 
{
public:
			ArrayDialog(SWND parent);
    virtual	       ~ArrayDialog();

    void		LoadData();
    virtual void	SaveData();
    virtual bool	Validate();
    int                 getNumberCopies() {return _numberCopies;}
    SFVec3f             getTranslation() {return _translation;}
    SFRotation          getRotation() {return _rotation;}
    SFVec3f             getCenter() {return _center;}
    SFVec3f             getScale() {return _scale;}
private:
    int                 _numberCopies;
    SFVec3f             _translation;
    SFRotation          _rotation;
    SFVec3f             _center;
    SFVec3f             _scale;
};

#endif
